<?php
/**
 * @package	upload2.0
 * @version 2.0.a (dernire rvision le 07-11-2003)
 * @author	Olivier VEUJOZ <o.veujoz@miasmatik.net>
 * SECURITY CONSIDERATION: If you are saving all uploaded files to a directory accesible with an URL, remember to filter files not only by mime-type (e.g. image/gif), but also by extension. The mime-type is reported by the client, if you trust him, he can upload a php file as an image and then request it, executing malicious code. 
   I hope I am not giving hackers a good idea anymore than I am giving it to good-intended developers. Cheers.
   Some restrictive firewalls may not let file uploads happen via a form with enctype="multipart/form-data".
   We were having problems with an upload script hanging (not returning content) when a file was uploaded through a remote office firewall. Removing the enctype parameter of the form allowed the form submit to happen but then broke the file upload capability. Everything but the file came through. Using a dial-in or other Internet connection (bypassing the bad firewall) allowed everything to function correctly.
   So if your upload script does not respond when uploading a file, it may be a firewall issue.
 * Compatibilit :
    - compatible safe_mode
    - compatible open_basedir pour peu que les droits sur le rpertoire temporaire d'upload soit allou
    - marche avec les chemins relatifs et absolu
    - test sous environnement Linux/Windows sous Apache 1.3
    - test avec les version PHP 4.2.0, 4.3.1, 4.3.4
    - Version minimum de php : 4.2.0
 * Par dfaut :
    - autorise tout type de fichier
    - autorise les fichier allant jusqu' la taille maximale spcifie dans le php.ini
    - envoie le(s) fichier(s) dans le rpertoire de la classe
    - estime le temps d'execution du script par rapport  un modem 33.6Ko
 	- n'affiche qu'un champ de type file
    - permet de laisser les champs de fichiers vides
    - crase le fichier s'il existe dj
    - n'excute aucune vrification
 * Notes :
    - le chemin de destination peut tre soit absolu soit relatif
    - si $SecurityMax est positionn  "true", la classe va ignorer tout type de fichier rentrant dans la catgorie des application/octetstream
    - set_time_limit n'a pas d'effet lorsque PHP fonctionne en mode safe mode . Il n'y a pas d'autre solution que de changer de mode, ou de modifier la dure maximale d'excution dans le php.ini
    - la variable $UploadErreur (type bool) est rutilisable dans vos scripts afin de tester le bon droulement des oprations. S'il y a eu des erreurs, la variable est positionne  "true".
 */

global $UploadError;

class Upload {
    
    /**
	 * Taille maximum exprime en kilo-octets pour l'upload d'un fichier.
     * Type : numrique
     * Valeur par dfaut : celle configure dans le php.ini
	 * @access public
	 */
    var $MaxFilesize;
    
    /**
	 * Largeur maximum d'une image exprime en pixel.
     * Type : entier
     * Valeur par dfaut : null (aucune vrification)
	 * @access public
	 */
    var $ImgMaxWidth;
    
    /**
	 * Hauteur maximum d'une image exprime en pixel.
     * Type : entier
     * Valeur par dfaut : null (aucune vrification)
	 * @access public
	 */
    var $ImgMaxHeight;
    
    /**
	 * Largeur minimum d'une image exprime en pixel.
     * Type : entier
     * Valeur par dfaut : null (aucune vrification)
	 * @access public
	 */
    var $ImgMinWidth;
    
    /**
	 * Hauteur minimum d'une image exprime en pixel.
     * Type : entier
     * Valeur par dfaut : null (aucune vrification)
	 * @access public
	 */
    var $ImgMinHeight;
    
    /**
	 * Rpertoire de destination dans lequel vont tre charg les fichiers. Accepte les chemins relatifs et absolus
     * Type : chaine
     * Valeur par dfaut : chaine vide (le rpertoire dans lequelle est situe la classe upload sera dsign comme chemin de destination)
	 * @access public
	 */
	var $DirUpload;
    
    /**
	 * Dbit de la connexion utilisateur, exprime en kilobit, sur laquelle sera base le calcul de la fonction set_time_limit
     * Type : valeur numrique
     * Valeur par dfaut : 33.6
	 * @access public
	 */
	var $Debit;
    
    /**
	 * Nombre de champs de type file que la classe devra grer.
     * Type : entier
     * Valeur par dfaut : 1
	 * @access public
	 */
	var $Fields;
    
    /**
	 * Paramtres  ajouter aux champ de type file (ex: balise style, venements JS...)
     * Type : chaine
     * Valeur par dfaut : chaine vide
	 * @access public
	 */
	var $FieldOptions;
    
    /**
	 * Dfinit si les champs sont obligatoires ou non.
     * Type : boolen
     * Valeur par dfaut : false
	 * @access public
	 */
	var $Required;
    
    /**
	 * Politique de scurit max : ignore tous les fichiers excutables / interprtable.
     * Type : boolen
     * Valeur par dfaut : false
	 * @access public
	 */
	var $SecurityMax;
    
    /**
	 * Permet de prciser un nom pour le fichier  uploader. Peut s'utiliser conjointement avec les proprits $Suffixe / $Prefixe
     * Type : chaine
     * Valeur par dfaut : chaine vide
	 * @access public
	 */
	var $Filename;
    
    /**
	 * Prfixe pour un nom de fichier
     * Type : chaine
     * Valeur par dfaut : chaine vide
	 * @access public
	 */
	var $Prefixe;
    
    /**
	 * Suffixe pour un nom de fichier
     * Type : chaine
     * Valeur par dfaut : chaine vide
	 * @access public
	 */
	var $Suffixe;
    
    /**
	 * Mthode  employer pour l'criture des fichiers :
     *  0 : si un fichier de mme nom est prsent dans le rpertoire, il est cras par le nouveau fichier
     *  1 : si un fichier de mme nom est prsent dans le rpertoire, le nouveau fichier est upload mais prcd de la mention 'copie_de_'
     *  2 : si un fichier de mme nom est prsent dans le rpertoire, le nouveau fichier est ignor
     * Type : entier compris entre 0 et 2
     * Valeur par dfaut : 0
	 * @access public
	 */
	var $WriteMode;
    
    /**
	 * Indique s'il faut vrifier la provenance du formulaire d'upload des fichiers. Si la chaine est vide, aucune vrification n'est effectue.
     * Pour lancer la vrification, il faut indiquer l'URI du formulaire de soumission des donnes.
     * Type : chaine
     * Valeur par dfaut : chaine vide
	 * @access public
	 */
	var $CheckReferer;
    
    /**
	 * Chaine de caractres reprsentant les enttes de fichiers autoriss (mime-type).
     * Les enttes doivent tre spares par des points virgules.
     * Type : chaine
     * Valeur par dfaut : chaine vide (tout type d'entte autoris)
	 * @access public
	 */
	var $MimeType;
    
    /**
	 * Dfinit si les erreurs de configuration de la classe doivent tre affiches en sortie cran et doivent stopper le script courant.
     * Type : boolen
     * Valeur par dfaut : true
	 * @access public
	 */
	var $TrackError;
    
    
    
	/***********************************************************************************
								METHODES PUBLIQUES										
	***********************************************************************************/
	
    /**
     * Constructeur
	 *
	 * @access public
	 * @return object   initialise les valeurs par dfaut
	 */
	function Upload() {
		$this-> Extension    = '';
        $this-> DirUpload    = '';
        $this-> MimeType     = '';
		$this-> Filename     = '';
        $this-> FieldOptions = '';
		$this-> Fields       = 1;
		$this-> WriteMode    = 0;
        $this-> Debit        = 33.6;
        $this-> SecurityMax  = false;
		$this-> CheckReferer = false;
        $this-> Required     = false;
        $this-> TrackError   = true;
        $this-> ArrOfError   = Array();
        $this-> MaxFilesize  = @ereg_replace('M', '', ini_get('upload_max_filesize')) * 1024;
	}
	
	
	
    /**
	 * Lance l'initialisation de la classe pour la gnration du formulaire
	 * @access public
	 */
	function InitForm() {
		$this-> SetMaxFilesize();
        $this-> CreateFields();
	}
    
    
    
    /**
	 * Retourne le tableau des erreurs survenues durant l'upload
	 *
	 * <code>
     * if ($UploadError) {
     *     print_r($Upload-> GetError);
     * }
     * </code>
	 *
	 * @access public
     * @param integer $num_field    numro du champ 'file' sur lequel on souhaite rcuprer l'erreur
	 * @return array                tableau des erreurs
	 */
    function GetError($num_field='') {
        if (Empty($num_field)) return $this-> ArrOfError;
        else                  return $this-> ArrOfError[$num_field];
    }
	
	
	
	/**
	 * Retourne le tableau contenant les informations sur les fichiers uploads
	 *
	 * <code>
     * if (!$UploadError) {
     *     print_r($Upload-> GetSummary());
     * }
     * </code>
	 *
	 * @access public
     * @param integer $num_field    numro du champ 'file' sur lequel on souhaite rcuprer les informations
	 * @return array                tableau des infos fichiers
	 */
    function GetSummary($num_field='') {
        if ($num_field == '') return $this-> Infos;
        else                  return $this-> Infos[$num_field];
    }
	
	
	
	/**
	 * Lance les diffrents traitements ncessaires  l'upload
	 * @access public
	 */
	function Execute(){
        $this-> CheckConfig();
		$this-> VerifyReferer();
		//$this-> SetTimeLimit();
		$this-> CheckUpload();
	}
	
	
	
	
	/*******************************************************************************************
								METHODES A USAGE INTERNE										
	********************************************************************************************/
	
    /**
	 * Mthode lanant les vrifications sur les fichiers. Initialisation de la variable $UploadError  true si erreur, lance la 
     * mthode d'criture toutes les vrifications sont ok.
	 * @access private
	 */
	function CheckUpload() {
		global $UploadError;
        
        // Parcours des fichiers  uploader
	//echo count($_FILES['userfile']['tmp_name']);
		//for ($i=0; $i < count($_FILES['userfile']['tmp_name']); $i++)  {
            
			// Rcup des proprits
            $this-> _field = 1;                                // position du champ dans le formulaire  partir de 1 (0 tant rserv au champ max_file_size)
			$this-> _size  = $_FILES['userfile']['size'];     // poids du fichier
			$this-> _type  = $_FILES['userfile']['type'];     // type mime
			$this-> _name  = $_FILES['userfile']['name'];     // nom du fichier
			$this-> _temp  = $_FILES['userfile']['tmp_name']; // emplacement temporaire
			$this-> _ext   = strtolower(substr($this-> _name, strrpos($this-> _name, '.'))); // extension du fichier
            
            // On excute les vrifications demandes
			if (is_uploaded_file($_FILES['userfile']['tmp_name'])) {
				$this-> CheckSecurity();
				$this-> CheckMimeType();
				$this-> CheckExtension();
                $this-> CheckImg();
			} else 
			{
				if ($_FILES['userfile']['error']!=0)
				{
					$this-> AddError($_FILES['userfile']['error']); // Le fichier n'a pas t upload, on rcupre l'erreur
				}
			}
            
            // Si le fichier a pass toutes les vrifications, on procde  l'upload, sinon on positionne la variable globale UploadError  'true'
            if (!isset($this-> ArrOfError[$this-> _field])) $this-> WriteFile($this-> _name, $this-> _type, $this-> _temp, $this-> _size, $this-> _ext, $this-> _field);
            else $UploadError = true;
		//}
	}
	
	
	
    /**
	 * Ecrit le fichier sur le serveur.
	 *
	 * @access private
     * @param string $name        nom du fichier sans son extension
     * @param string $type        entete du fichier
     * @param string $temp        chemin du fichier temporaire
     * @param string $size        taille du fichier en octets
     * @param string $temp        extension du fichier prcde d'un point
     * @param string $temp        extension du fichier prcde d'un point
     * @param string $num_fied    position du champ dans le formulaire  compter de 1
	 * @return bool               true/false => succes/erreur
	 */
	function WriteFile($name, $type, $temp, $size, $ext, $num_field) {
        
        $new_filename = NULL;
        
        if (is_uploaded_file($temp)) {
            
            // Nettoyage du nom original du fichier
            if (Empty($this-> Filename)) $new_filename = $this-> CleanStr(substr($name, 0, strrpos($name, '.')));
            else $new_filename = $this-> Filename;
            
            // Ajout prfixes / suffixes + extension :
            $new_filename = $this-> Prefixe . $new_filename . $this-> Suffixe . strtoupper($ext);
            
            switch ($this-> WriteMode) {
                // Si le fichier existe, on crase
                case 0 : $uploaded = move_uploaded_file($temp, $this-> DirUpload . $new_filename);
                         break;
                    
                // Si le fichier existe, on en fait une copie
                case 1 : if ($this-> AlreadyExist($new_filename)) $new_filename = 'copie_de_' . $new_filename;
                		 $uploaded = move_uploaded_file($temp, $this-> DirUpload . $new_filename);
                		 break;
                
                // Si le fichier existe, on ne fait rien
                case 2 :  if ($this-> AlreadyExist($new_filename)) $uploaded = true;
                          else $uploaded = move_uploaded_file($temp, $this-> DirUpload . $new_filename);
                          break;
            }
            
            // Informations pouvant tre utiles au dveloppeur (si le fichier a pu tre copi)
            if ($uploaded != false) {
                $this-> Infos[$num_field]['nom']          = $new_filename;
                $this-> Infos[$num_field]['nom_originel'] = $name;
                $this-> Infos[$num_field]['chemin']       = $this-> DirUpload . $new_filename;
                $this-> Infos[$num_field]['poids']        = number_format(filesize($this-> DirUpload . $new_filename)/1024, 3, '.', '');
                $this-> Infos[$num_field]['mime-type']    = $type;
                $this-> Infos[$num_field]['extension']    = $ext;
            }
            
            return true;
        }// End is_uploaded_file
        
        return false;
	} // End function
    
    
    
	/**
	 * Vrifie si le fichier pass en paramtre existe dj dans le rpertoire DirUpload
	 * @access private
     * @return bool
	 */
	function AlreadyExist($file) {
		if (!file_exists($this-> DirUpload . $file)) return false;
		else return true;
	}
	
	
	
	/**
	 * Vrifie la hauteur/largeur d'une image
	 * @access private
     * @return bool
	 */
	function CheckImg() {
        // Vrification de la largeur puis de la hauteur
        if ($taille = @getimagesize($this-> _temp) ) {
	        if (!Empty($this-> ImgMaxWidth)  && $taille[0] > $this-> ImgMaxWidth)  $this-> AddError(8);
	        if (!Empty($this-> ImgMaxHeight) && $taille[1] > $this-> ImgMaxHeight) $this-> AddError(9);
            if (!Empty($this-> ImgMinWidth)  && $taille[0] < $this-> ImgMinWidth) $this-> AddError(10);
            if (!Empty($this-> ImgMinHeight) && $taille[1] < $this-> ImgMinHeight) $this-> AddError(11);
        }
        
        return true;
	}
	
	
	
	/**
	 * Vrifie l'extension des fichiers suivant celles prcises dans $Extension
	 * @access private
     * @return bool
	 */
	function CheckExtension() {
        $ArrOfExtension = explode(';', strtolower($this-> Extension));
        
		if (!Empty($this-> Extension) && !in_array($this-> _ext, $ArrOfExtension)) {
            $this-> AddError(7);
            return false;
		}
        
		return true;
	}
	
	
	
	/**
	 * Vrifie l'entte des fichiers suivant ceux prciss dans $MimeType
	 * @access private
     * @return bool
	 */
	function CheckMimeType() {
        $ArrOfMimeType = explode(';', $this-> MimeType);
        
        if (!Empty($this-> MimeType) && !in_array($this-> _type, $ArrOfMimeType)) {
            $this-> AddError(6);
			return false;
		}
        
		return true;
	}
	
	
    
    /**
	 * Ajoute une erreur pour le fichier spcifi dans le tableau des erreur
	 * @access private
	 */
    function AddError($code_erreur) {
       
       // Le tableau des erreurs est de la forme :$arr[position_du_champ][code_erreur] = 'description';
       
        switch ($code_erreur) {
	    case 0 : $msg = 'Upload reussi (code 0 ) ('. $this-> _name .')';
                     break;
            case 1 : $msg = 'Le fichier  charger excde la directive upload_max_filesize (php.ini) ('. $this-> _name .')';
                     break;
            
            case 2 : $msg = 'Le fichier excde la directive MAX_FILE_SIZE qui a t spcifie dans le formulaire ('. $this-> _name .')';
                     break;
            
            case 3 : $msg = 'Le fichier n\'a pu tre charg compltement ('. $this-> _name .')';
                     break;
            
            case 4 : $msg = 'Le champ du formulaire est vide';
                     break;
            
            case 5 : $msg = 'Fichier potentiellement dangereux ('. $this-> _name .')';
                     break;
            
            case 6 : $msg = 'Le fichier n\'est pas conforme  la liste des enttes autoriss ('. $this-> _name .')';
                     break;
            
            case 7 : $msg = 'Le fichier n\'est pas conforme  la liste des extensions autorises ('. $this-> _name .')';
                     break;
            
            case 8 : $msg = 'La largeur de l\'image dpasse celle autorise ('. $this-> _name .')';
                     break;
            
            case 9 : $msg = 'La hauteur de l\'image dpasse celle autorise ('. $this-> _name .')';
                     break;
            
            case 10 : $msg = 'La largeur de l\'image est infrieure  celle autorise ('. $this-> _name .')';
                      break;
            
            case 11 : $msg = 'La hauteur de l\'image est infrieure  celle autorise ('. $this-> _name .')';
                      break;
        }
	//echo $code_erreur;
        
        
        if ($this-> Required && $code_erreur == 4) $this-> ArrOfError[$this-> _field][$code_erreur] = $msg;
        else if ($code_erreur != 4)                $this-> ArrOfError[$this-> _field][$code_erreur] = $msg;
    }
    
	
	/**
	 * Vrifie les critres de la politique de scurit
	 * @access private
     * @return bool
	 */
	function CheckSecurity() {
        // Bloque tous les fichiers executables, et tous les fichiers php pouvant tre interprt mais dont l'entte ne peut les identifier comme tant dangereux
		if ($this-> SecurityMax===true) {
			// Note : is_executable ne fonctionne pas => ?
            if (ereg ('application/octet-stream', $this-> _type) || preg_match("/.php$|.inc$|.php3$/i", $this-> _ext) ) {
                $this-> AddError(5);
				return false;
            }
		}
		
		return true;
	}
	
	
	
	/**
	 * Vrifie et formate le chemin de destination :
     *     - dfinit comme rep par dfaut celui de la classe
     *     - teste l'existance du rpertoire et son accs en criture
	 * @access private
	 */
	function CheckDirUpload() {
        // Si aucun rpertoire n'a t prcis, on prend celui de la classe
        if (Empty($this-> DirUpload)) $this-> DirUpload = dirname(__FILE__);
        
        $this-> DirUpload = $this-> FormatDir($this-> DirUpload);
        
		// Le rpertoire existe?
		if (!is_dir($this-> DirUpload)) $this-> Error('Le rpertoire de destination spcifie par la proprit DirUpload n\'existe pas.');
        // Droit en criture ?
		if (!is_writeable($this-> DirUpload)) $this-> Error('Le rpertoire de destination spcifie par la proprit DirUpload est inaccessible en criture.');
	}
	
	
    
    /**
	 * Formate le rpertoire pass en paramtre
     *     - convertit un chemin relatif en chemin absolu
     *     - ajoute si besoin le dernier slash (ou antislash suivant le systme)
	 * @access private
	 */
    function FormatDir($Dir) {
        // Convertit les chemins relatifs en chemins absolus
        if (function_exists('realpath')) {
            if (realpath($Dir)) $Dir = realpath($Dir);
        }
        
        // Position du dernier slash/antislash
        if ($Dir[strlen($Dir)-1] != DIRECTORY_SEPARATOR) $Dir .= DIRECTORY_SEPARATOR;
        
        return $Dir;
    }
	
    
    
    /**
	 * Formate la chaine passe en paramtre en nom de fichier standard (pas de caractres spciaux ni d'espaces)
	 * @access private
     * @param  string $str   chaine  formater
     * @return string        chaine formate
	 */
	function CleanStr($str) {
		$return = '';
		
		for ($i=0; $i <= strlen($str)-1; $i++) {
            if (eregi('[a-z]',$str{$i}))              $return .= $str{$i};
			elseif (eregi('[0-9]', $str{$i}))         $return .= $str{$i};
			elseif (ereg('[]', $str{$i})) $return .= 'a';
			elseif (ereg('[]', $str{$i}))           $return .= 'a';
			elseif (ereg('[]', $str{$i}))           $return .= 'c';
			elseif (ereg('[E]', $str{$i}))    $return .= 'e';
			elseif (ereg('[]', $str{$i}))     $return .= 'i';
			elseif (ereg('[]', $str{$i}))   $return .= 'o';
			elseif (ereg('[]', $str{$i}))     $return .= 'u';
			elseif (ereg('[ݟ]', $str{$i}))         $return .= 'y';
			elseif (ereg('[ ]', $str{$i}))            $return .= '_';
			elseif (ereg('[.]', $str{$i}))            $return .= '_';
			else                                      $return .= $str{$i};
		}
		
		return $return;
	}
	
	
	
	/**
	 * Vrifie que la provenance du formulaire est bien celle prcise dans la proprite CheckReferer.
	 * @access private
     * @return bool
	 */
	function VerifyReferer() {
		if (!Empty($this-> CheckReferer)) {
            $headerref = $_SERVER['HTTP_REFERER'];
            
            // On enlve toutes les variables passes par url
            if (ereg("\?",$headerref)){
			    list($url, $getstuff) = split('\?', $headerref);
			    $headerref = $url;
		    }
            
            if ($headerref == $this-> CheckReferer) return true;
		    else $this-> Error('Accs refus');
        }
	}
	
	
	
	/**
	 * Initialise si possible le temps d'excution max du script en fonction du nombre de fichiers et de la proprit max_file_size
	 * @access private
	 */
	function SetTimeLimit(){
		// Le temps calcul est thoriquement le plus rapide => * 2
		@set_time_limit(ceil(ceil($this->  $_POST['MAX_FILE_SIZE'] * 8) / ($this-> Debit * 1000) * count($_FILES) * 2));
	}
	
    
    
    /**
	 * Conversion du poids maximum d'un fichier exprime en Ko en octets
	 * @access private
	 */
    function SetMaxFilesize() {
        (is_numeric($this-> MaxFilesize)) ? $this-> MaxFilesize = $this-> MaxFilesize * 1024 : $this-> Error('la proprit MaxFilesize doit tre une valeur numrique');
    }
	
    
    
    /**
	 * Cre les champs de type fichier suivant la proprit Fields dans un tableau $Field. Ajoute le contenu de FieldOptions aux champs.
	 * @access private
	 */
    function CreateFields() {
        if (!is_int($this-> Fields)) $this-> Error('la proprit Fields doit tre un entier');
        
        for ($i=0; $i <= $this-> Fields; $i++) {
            if ($i == 0)  $this-> Field[] = '<input type="hidden" name="MAX_FILE_SIZE" value="'. $this-> MaxFilesize .'">';
            else          $this-> Field[] = '<input type="file" name="userfile[]" '. $this-> FieldOptions .'>';
        }
    }
    
	
	
    /**
	 * Vrifie la configuration de la classe.
	 * @access private
	 */
    function CheckConfig() {
        if (!version_compare(phpversion(), '4.2.0')) $this-> Error('la version de php sur ce serveur est trop ancienne. La classe ne peut fonctionner qu\'avec une version gale ou suprieure  la version 4.1.0');
        if (!is_string($this-> Extension)) $this-> Error('la proprit Extension est mal configure.');
        if (!is_string($this-> MimeType)) $this-> Error('la proprit MimeType est mal configure.');
        if (!is_string($this-> Filename)) $this-> Error('la proprit Filename est mal configure.');
        if (!is_numeric($this-> Debit)) $this-> Error('la proprit Debit est mal configure.');
        if (!is_bool($this-> Required)) $this-> Error('la proprit Required est mal configure.');
        if (!is_bool($this-> SecurityMax)) $this-> Error('la proprit SecurityMax est mal configure.');
        if ($this-> WriteMode != 0 && $this-> WriteMode != 1 && $this-> WriteMode != 2) $this-> Error('la proprit WriteMode est mal configure.');
        if (!Empty($this-> CheckReferer) && !@fopen($this-> CheckReferer, 'r')) $this-> Error('la proprit CheckReferer est mal configure.');
        $this-> CheckImgPossibility();
        $this-> CheckDirUpload();
    }
    
    
    
    /**
	 * Vrifie les proprits ImgMaxWidth/ImgMaxHeight
	 * @access private
	 */
    function CheckImgPossibility() {
        if (!Empty($this-> ImgMaxWidth)  && !is_numeric($this-> ImgMaxWidth))   $this-> Error('la proprit ImgMaxWidth est mal configure.');
        if (!Empty($this-> ImgMaxHeight) && !is_numeric($this-> ImgMaxHeight))  $this-> Error('la proprit ImgMaxHeight est mal configure.');
        if (!Empty($this-> ImgMinWidth)  && !is_numeric($this-> ImgMinWidth))   $this-> Error('la proprit ImgMinWidth est mal configure.');
        if (!Empty($this-> ImgMinHeight) && !is_numeric($this-> ImgMinHeight))  $this-> Error('la proprit ImgMinHeight est mal configure.');
    }
    
    
    
    /**
	 * Affiche les erreurs de configuration et stoppe tout traitement 
	 * @access private
	 */
    function Error($error_msg) {
        if ($this-> TrackError) {
            echo 'Erreur classe Upload : ' . $error_msg;
            exit;
        }
    }
    
} // End Class
?>