<?php

	/**
	 * Image générant un code aléatoire
	 * =================================
	 * 6 chiffres et lettres aléatoires
	 * 6 couleurs différentes
	 * 6 polices de caractère différentes*
	 * Inclinaison de -20° à 20°
	 * 
	 * (Attention, pour les polices de caractère, il faut soit les importer dans un dossier (ici pour exemple font/), 
	 * soit renseigner les liens absolut du web et en faire un tableau comme pour les couleurs, et la traiter de même)
	 * 
	 * 
	 * @author     DOUIBI Farah <contact@farahdouibi.fr>
	 * @copyright  2010
	 * @version    1.0
	 **/
 
		// OUVERTURE DE SESSION POUR $_SESSION['code_image']
		session_start();
		
		
		// On créé une image vide (L , H)
		$img = imagecreatetruecolor(200 , 60);
		// Couleur de l'image
		$fond = imagecolorallocate($img, 255, 255, 255);
		// Création du rectangle
		imagefilledrectangle($img, 0, 0, 199, 59, $fond);
		
		
		
		// LISTE DES COULEURS DE POLICE UTILISÉES
		// +++++++++++++++++++++++++++++++++
		$table_color = array (
			imagecolorallocate($img, 80, 39, 6),
			imagecolorallocate($img, 23, 71, 91),
			imagecolorallocate($img, 106, 27, 53),
			imagecolorallocate($img, 21, 99, 39),
			imagecolorallocate($img, 81, 82, 7),
			imagecolorallocate($img, 0, 0, 0)
		);
		// +++++++++++++++++++++++++++++++++
		
		
		
		// LISTE DES POLICES UTILISÉES
		// Dans ce dossier font/, j'ai une dizaine de polices différentes mais lisibles
		// +++++++++++++++++++++++++++++++++
		$table_police = scandir('font');
		// +++++++++++++++++++++++++++++++++
		
		
		
		// LISTE DES CARACTERES UTILISÉS PRIS ALEATOIREMENT
		// +++++++++++++++++++++++++++++++++
		$liste_caracteres = '123456789abcdefghijklmnpqrstuvwxyz';
		$table_lettre = array(
			$liste_caracteres[rand(0,32)], 
			$liste_caracteres[rand(0,32)], 
			$liste_caracteres[rand(0,32)], 
			$liste_caracteres[rand(0,32)], 
			$liste_caracteres[rand(0,32)], 
			$liste_caracteres[rand(0,32)]
		);
		// +++++++++++++++++++++++++++++++++
		
	

		// FONCTION D'ECRITURE ===================================================================================================
		$position_en_x = 10;
		for($a=0 ; $a<6 ; $a++){
			// POLICE DE CARACTERE
			$font_de_police = 'font/'.$table_police[rand(2, (count($table_police)-2))];
			// COULEUR DE POLICE DE CARACTERE
			$couleur_de_police = $table_color[rand(0,5)];
			// CONVERTION DE LA COULEUR DE POLICE EN RGB
			$color2rgb = str_pad(base_convert($couleur_de_police, 10, 16), 6, 0, STR_PAD_LEFT);
			$rgb2array = array(
				base_convert(substr($color2rgb, 0, 2), 16, 10),
				base_convert(substr($color2rgb, 2, 2), 16, 10),
				base_convert(substr($color2rgb, 4, 2), 16, 10),
			);
			// MODIFICATION DE LA COULEUR RGB POUR L'OMBRE
			$couleur_de_police_ombre = imagecolorallocate($img, ($rgb2array[0]+100), ($rgb2array[1]+70), ($rgb2array[2]));
			// ANGLE DE ROTATION EN DEGRES
			$angle = rand(-20,20);
			// OMBRE DU CODE
			imagettftext($img , 30 , $angle , ($position_en_x+2) , 45 , $couleur_de_police_ombre , $font_de_police , $table_lettre[$a]);
			// CODE
			imagettftext($img , 30 , $angle , $position_en_x , 43 , $couleur_de_police , $font_de_police , $table_lettre[$a]);
			// J'INCREMENTE DE 30 LA POSITION x DE LA LETTRE SUIVANTE POUR L'ESPACEMENT ENTRE LES LETTRES
			$position_en_x +=30;
		}
		// ========================================================================================================================
		
		
		// CREATION DE L'IMAGE PAR L'EN-TÊTE / PAS DE MISE EN CACHE
		header('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
		header('Cache-Control: no-store, no-cache, must-revalidate');
		header('Cache-Control: post-check=0, pre-check=0', false);
		header("Content-type: image/jpeg");	// C'est ici que que dis au navigateur d'interprêter ce fichier comme une image
		
		// CREATION DE LA SESSION
		$_SESSION['code_image'] = $table_lettre[0].''.$table_lettre[1].''.$table_lettre[2].''.$table_lettre[3].''.$table_lettre[4].''.$table_lettre[5];
		// CREATION DE L'IMAGE PHYSIQUE
		imagejpeg($img , '' , 100);
		// LIBERATION DE LA MEMOIRE
		imageDestroy($img);
?>