<?php

/**
 * VARIABLE GLOBALE DE SCRIPTS
 *
 */
//Definition des constantes
global $base_url;
global $language;
$lg = $language->language;

define('LG', $lg);


define('BASEURL', $base_url);
define('THEMEURL', base_path().drupal_get_path('theme', 'greeters') . '/');
define('IMAGESURL', THEMEURL . 'images/');


/**
 * Add body classes if certain regions have content.
 */
function greeters_preprocess_html(&$variables) {
  if (!empty($variables['page']['featured'])) {
    $variables['classes_array'][] = 'featured';
  }


  // Add conditional stylesheets for IE
  drupal_add_css(path_to_theme() . '/css/ie.css', array('group' => CSS_THEME, 'browsers' => array('IE' => 'lte IE 7', '!IE' => FALSE), 'preprocess' => FALSE));
  drupal_add_css(path_to_theme() . '/css/ie6.css', array('group' => CSS_THEME, 'browsers' => array('IE' => 'IE 6', '!IE' => FALSE), 'preprocess' => FALSE));
}

/**
 * Override or insert variables into the page template for HTML output.
 */
function greeters_process_html(&$variables) {
  // Hook into color.module.
  if (module_exists('color')) {
    _color_html_alter($variables);
  }
}

/**
 * Override or insert variables into the page template.
 */
function greeters_process_page(&$variables) {
  // Hook into color.module.
  if (module_exists('color')) {
    _color_page_alter($variables);
  }
  // Always print the site name and slogan, but if they are toggled off, we'll
  // just hide them visually.
  $variables['hide_site_name']   = theme_get_setting('toggle_name') ? FALSE : TRUE;
  $variables['hide_site_slogan'] = theme_get_setting('toggle_slogan') ? FALSE : TRUE;
  if ($variables['hide_site_name']) {
    // If toggle_name is FALSE, the site_name will be empty, so we rebuild it.
    $variables['site_name'] = filter_xss_admin(variable_get('site_name', 'Drupal'));
  }
  if ($variables['hide_site_slogan']) {
    // If toggle_site_slogan is FALSE, the site_slogan will be empty, so we rebuild it.
    $variables['site_slogan'] = filter_xss_admin(variable_get('site_slogan', ''));
  }
  // Since the title and the shortcut link are both block level elements,
  // positioning them next to each other is much simpler with a wrapper div.
  if (!empty($variables['title_suffix']['add_or_remove_shortcut']) && $variables['title']) {
    // Add a wrapper div using the title_prefix and title_suffix render elements.
    $variables['title_prefix']['shortcut_wrapper'] = array(
      '#markup' => '<div class="shortcut-wrapper clearfix">',
      '#weight' => 100,
    );
    $variables['title_suffix']['shortcut_wrapper'] = array(
      '#markup' => '</div>',
      '#weight' => -99,
    );
    // Make sure the shortcut link is the first item in title_suffix.
    $variables['title_suffix']['add_or_remove_shortcut']['#weight'] = -100;
  }
  //Ajout d'une variable qui permet de savoir en fct de l'OT, sur quelle page on doit rediriger 
  if(LG == 'fr'){
    $variables['ot_page_greeters'] = array('beaune' => 'node/32', 'nuits' => 'node/33', 'vvds' => 'node/100' ,'dijon' => 'node/112');
  }else{
    $variables['ot_page_greeters'] = array('beaune' => 'node/47', 'nuits' => 'node/4', 'vvds' => 'node/103', 'dijon' => 'node/113');
  }
  
  
  //ajout de la variable de langue
}

/**
 * Implements hook_preprocess_maintenance_page().
 */
function greeters_preprocess_maintenance_page(&$variables) {
  // By default, site_name is set to Drupal if no db connection is available
  // or during site installation. Setting site_name to an empty string makes
  // the site and update pages look cleaner.
  // @see template_preprocess_maintenance_page
  if (!$variables['db_is_active']) {
    $variables['site_name'] = '';
  }
  drupal_add_css(drupal_get_path('theme', 'greeters') . '/css/maintenance-page.css');
}

/**
 * Override or insert variables into the maintenance page template.
 */
function greeters_process_maintenance_page(&$variables) {
  // Always print the site name and slogan, but if they are toggled off, we'll
  // just hide them visually.
  $variables['hide_site_name']   = theme_get_setting('toggle_name') ? FALSE : TRUE;
  $variables['hide_site_slogan'] = theme_get_setting('toggle_slogan') ? FALSE : TRUE;
  if ($variables['hide_site_name']) {
    // If toggle_name is FALSE, the site_name will be empty, so we rebuild it.
    $variables['site_name'] = filter_xss_admin(variable_get('site_name', 'Drupal'));
  }
  if ($variables['hide_site_slogan']) {
    // If toggle_site_slogan is FALSE, the site_slogan will be empty, so we rebuild it.
    $variables['site_slogan'] = filter_xss_admin(variable_get('site_slogan', ''));
  }
}

/**
 * Override or insert variables into the node template.
 */
function greeters_preprocess_node(&$variables) {
  global $lg;
  if ($variables['view_mode'] == 'full' && node_is_page($variables['node'])) {
    $variables['classes_array'][] = 'node-full';
  }

  if(LG == 'fr'){
    $variables['ot_page_greeters'] = array('beaune' => 'node/32/','nuits' => 'node/33', 'vvds' => 'node/100', 'dijon' => 'node/112');
  }else{
    $variables['ot_page_greeters'] = array('beaune' => 'node/47/','nuits' => 'node/48', 'vvds' => 'node/103', 'dijon' => 'node/113');
  }
  $variables['breadcrumb'] = '<a href="' . BASEURL . '/' . $lg .'">Accueil</a> <span> >> </span> <a href="">'. drupal_get_title() .'</a>'; 
}

/**
 * Override or insert variables into the block template.
 */
function greeters_preprocess_block(&$variables) {
  // In the header region visually hide block titles.
  if ($variables['block']->region == 'header') {
    $variables['title_attributes_array']['class'][] = 'element-invisible';
  }
}

/**
 * Implements theme_menu_tree().
 */
function greeters_menu_tree($variables) {
  return '<ul class="menu clearfix">' . $variables['tree'] . '</ul>';
}

/**
 *
 * Hack de la fonction qui génére les menus 
 * [greeters_menu_link description]
 * @param  array  $variables [description]
 * @return [type]            [description]
 */
function greeters_menu_link(array $variables) {
  $delimiter = '';
  $element = $variables['element'];
  $sub_menu = '';
  if ($element['#below']) {
    $sub_menu = drupal_render($element['#below']);
  }
  $output = l($element['#title'], $element['#href'], $element['#localized_options']);
  // on ajoute un delimiter pour le menu footer 
  if (strpos($variables['element']['#theme'], 'menu_footer') > 0 ) {
    $delimiter = (in_array('last', $variables['element']['#attributes']['class'])) ? '' : ' |' ;
  }
  return '<li' . drupal_attributes($element['#attributes']) . '>' . $output . $sub_menu . $delimiter . "</li>\n";
}


/**
 * Implements theme_field__field_type().
 */
function greeters_field__taxonomy_term_reference($variables) {
  $output = '';

  // Render the label, if it's not hidden.
  if (!$variables['label_hidden']) {
    $output .= '<h3 class="field-label">' . $variables['label'] . ': </h3>';
  }

  // Render the items.
  $output .= ($variables['element']['#label_display'] == 'inline') ? '<ul class="links inline">' : '<ul class="links">';
  foreach ($variables['items'] as $delta => $item) {
    $output .= '<li class="taxonomy-term-reference-' . $delta . '"' . $variables['item_attributes'][$delta] . '>' . drupal_render($item) . '</li>';
  }
  $output .= '</ul>';

  // Render the top-level DIV.
  $output = '<div class="' . $variables['classes'] . (!in_array('clearfix', $variables['classes_array']) ? ' clearfix' : '') . '"' . $variables['attributes'] .'>' . $output . '</div>';

  return $output;
}

