<?php

/**
 *  Page de synchronisation des noeuds ADT :
 *  (admin/config/webservices_nodes/synchronisation)
 * 
 *      -> affiche le résultat de chaque requête ADT préformatée
 *      -> créé d'office les noeuds qui n'existent pas encore
 *      -> pour les autres, indique s'ils sont à jour
 *          -> si non, lien pour synchroniser manuellement chaque noeud
 */

function page_synchronisation()
{
    //-- vérifie si le module d'api est activé
    if (module_exists('webservice_api') == FALSE){
        drupal_set_message("Attention, le module Webservice API n'est pas installé!");
        return;
    }
    
    //-- charge les fonctions de synchro du module
    module_load_include('inc', 'webservice_nodes', 'sync.functions');
    
    //-- vérifie si le paramètre auto_update est activé (met à jour les noeuds automatiquement)
    //$autoUpdate = isset($_GET['auto_update']) && $_GET['auto_update'] == 1;
    $autoUpdate = true;
    
    //-- récupère tous les noeuds de type Requête ADT
    $adtRequests = getADTRequests();
    
    //-- lien pour synchroniser tous les liens à la fois (relance la page avec auto_update=1)
    //$href = 'http://' . $_SERVER['HTTP_HOST'] . parse_url($_SERVER['REQUEST_URI'],PHP_URL_PATH) . '?auto_update=1';
    //$output = '<a onclick="location.href=confirm(\'Voulez vous vraiment synchroniser tous les noeuds ?\') ? \''.$href.'\' : \'\'" style="cursor:pointer">Synchroniser tous les noeuds</a>';
    $numCreated = 0;
    
    $idList = array();
    
    $output = '';
    
    //-- Pour chaque requête
    foreach($adtRequests as $adtRequest)
    {
        $fullNode = node_load($adtRequest->nid);
        $title = substr($fullNode->title, 15); //-> enlève "REQUETE ADT - "
        
        $table = $fullNode->{variable_get('FIELD_ADT_TABLE')}['und'][0]['value'];
        $support = $fullNode->{variable_get('FIELD_ADT_SUPPORT')}['und'][0]['value'];
        $params = $fullNode->{variable_get('FIELD_ADT_PARAMS')}['und'][0]['value'];
        $cloneType = $fullNode->{variable_get('FIELD_ASSOC_CLONES_CONTENT_TYPE')}['und'][0]['value'];
        
        $activite = getActiviteByCloneType($cloneType);
        
        //-- Envoie la requête au webservice
        $rawList = sendDataXMLRequest($table, $support, $params, 'all');
        
        $list = @simplexml_load_string($rawList);
        
        if (!$list){
            drupal_set_message("Les paramètres de recherche pour \"" . $title . "\" n'ont pas donné de résultats");
            continue;
        }
        
        $output .= '<h2>' . $title . '</h2>';
        $output .= '<ul>';
        
        foreach($list->obj as $item)
        {
            $id = (string) $item->id;
            $titre = (string) $item->societe;
            
            $idList[] = $id;
            
            //-- vérifie si un noeud existe dans drupal avec le même id
            $result = db_select('field_data_' . variable_get('FIELD_ADT_NODE_ID'), 'f')
            ->fields('f', array('entity_id', variable_get('FIELD_ADT_NODE_ID') . '_value'))
            ->condition(variable_get('FIELD_ADT_NODE_ID') . '_value', $id, '=')
            ->condition('bundle', $cloneType, '=')
            ->execute()
            ->fetchObject();
            
            //-- on envoie aussi une requête spécifique à la base ADT pour récupérer les données du noeud
            $rawData = sendDataXMLRequest($table, $support, $params, $id);
            
            //-- si le noeud n'existe pas encore, on le créé
            if (!$result)
            {
                createADTNode($activite, $cloneType, $id, $titre, $rawData);
                
                $output .= '<li style="color:#33FF33">' . $item->societe . ' <strong><small>[nouveau !]</small></strong></li>';
                $numCreated ++;
            }
            else
            {
                //-- s'il existe, on le charge pour vérifier s'il est à jour
                $node = node_load($result->entity_id);
                
                //-- force la publication du noeud (au cas où il a été dépublié...)
                //   /!\ vérifier si ça peut poser des problèmes... /!\
                $node->status = 1;
                
                //-- si le param auto_update est activé, on lance la mise à jour (quelque soit l'état du noeud)
                if ($autoUpdate)
                {
                    updateADTNode($node->nid, $rawData);
                    $output .= '<li style="color:#CCAA00">' . $item->societe . ' <small>[mis à jour !]</small></li>';
                }
                else
                {
                    //-- s'il n'est pas à jour
                    if ($rawData != $node->{variable_get('FIELD_ADT_NODE_XML_DATA')}['und']['0']['value'])
                    {
                        $output .= '<li style="color:#CCAA00">';
                        $output .= '<a href="'.base_path().'admin/config/webservice_nodes/synchronisation/update/'.$node->nid.'?table='.$table.'&support='.$support.'&params='.urlencode($params).'&id='.$item->id.'">' . $item->societe . ' <small>[mise à jour disponible !]</small></a>';
                        $output .= '</li>';
                    }
                    //-- s'il est à jour
                    else
                    {
                        $output .= '<li>' . $item->societe . ' <small>[à jour]</small></li>';
                    }
                }
            }
        }
        
        $output .= '</ul>';
    }
    
    /*
     *  Gestion de la dépublication des noeuds obsolètes : 
     */
    
    //-- récupère la liste des activités
    $activites = getListeActivites();
    $numUnpublished = 0;
    
    //-- parcours les noeuds Drupal pour vérifier si certains ne sont plus dans les résultats
    foreach ($activites as $activite)
    {
        $nodeType = $activite->clones_content_type;
        
        //-- recherche les noeuds correspondant à l'activité
        $results = db_select('node', 'n')
                    ->fields('n', array('nid'))
                    ->condition('type', $nodeType)
                    ->execute()
                    ->fetchAll();
        
        //-- parcours les résultats
        foreach($results as $result)
        {
            //-- charge le noeud sélectionné
            $node = node_load($result->nid);
            
            //-- extrait l'id de la fiche
            $idFiche = $node->{variable_get('FIELD_ADT_NODE_ID')}['und'][0]['value'];
            
            //-- si la fiche n'est plus dans les résultats XML
            if ($node->status == 1 && !in_array($idFiche, $idList))
            {
                dpm('dépublication : ' . $node->title);
                //-- force la dépublication du noeud
                $numUnpublished ++;
                $node->status = 0;
                node_save($node);
            }
        }
    }
    
    if ($numCreated > 0) drupal_set_message($numCreated . " nouveaux noeuds ont été créés");
    if ($numUnpublished > 0) drupal_set_message($numUnpublished . " noeuds ont été dépubliés");
    
    return $output;
}




?>
