<?php

function page_liste_activites()
{
    //-- inclut la librairie de fonctions utilitaires
    require_once('sites/all/libraries/utils.php');
    
    //-- récupère la liste de toutes les activités
    $activites = getListeActivites();
    
    //-- transforme l'objet en tableau
    $tabActivites = array();
    foreach ($activites as $activite)
    {        
        $tabActivites[] = array(
            'id' => $activite->id,
            'nom' => $activite->nom,
            'clonesContentType' => $activite->clones_content_type,
            'templateId' => $activite->template_id,
        );
    }
    
    //-- trie le tableau par noms
    usort($tabActivites, 'sortByName');
    
    
    /*
     *  Affiche les résultats :
     */
    
    $output = '';
    $output .= '<p><a href="/admin/config/webservice_nodes/ajout_activite">Ajouter une activité</a></p>';
    $output .= '<p><a href="/admin/config/webservice_nodes/synchronisation">Synchroniser les noeuds</a></p>';
    
    $output .= '<table>';
    $output .= ' <tr>';
    $output .= '     <th>Nom</th>';
    $output .= '     <th>Type de contenu associé</th>';
    $output .= '     <th>Template associé</th>';
    $output .= '     <th>Opération</th>';
    $output .= ' </tr>';
    
    foreach ($tabActivites as $activite)
    {
        $id = $activite['id'];
        $nom = $activite['nom'];
        $clonesContentType = $activite['clonesContentType'];
        $templateId = $activite['templateId'];
        $template = getClonesTemplateByID($templateId);
        
        $output .= ' <tr>';
        $output .= '    <td>' . $nom . '</td>';
        $output .= '    <td>' . $clonesContentType . '</td>';
        $output .= '    <td>' . $template->path . '</td>';
        $output .= '    <td><a href="activites/' . $id . '/edit">Éditer</a>&nbsp;&nbsp;&nbsp;<a href="activites/' . $id . '/delete">Supprimer</a></td>';
        $output .= ' </tr>';
    }
    
    $output .= '</table>';
    
    return $output;
}

function sortByName($a, $b)
{
    //-- fonction définie dans utils.php
    return compare_strings($a['nom'], $b['nom']);
}

?>
