<?php

/**
 *  Retourne les données XML d'une fiche individuelle :
 * 
 *  @param id : l'identifiant de la fiche souhaitée
 */
function getItemData($id, $support = 'NATURE', $params = '')
{
    $table = 'c_obj_' . strtolower(substr($id, 0, 3));
    $data = sendDataXMLRequest($table, $support, $params, $id);
    return $data;
}

/**
 *  Retourne les données XML correspondant aux paramètres fournis :
 * 
 *  @param params : les paramètres à envoyer, au format JSON
 */
function getListData($table, $support, $params)
{
    /*/*$table = 'c_obj_rap';
    $table = 'c_obj_asc';
    $support = 'NATURE';*/
    $id = 'all';
    $data = sendDataXMLRequest($table, $support, $params, $id);
    return $data;
}

/**
 *  Envoie une requête de type GetDataXML au serveur ADT :
 * 
 *  @param $table : la table visée par la requête
 *  @param $support : la "source" de la requête (ex: GP ou Nature)
 *  @param $params : les paramètres de la requête (JSON)
 *  @param $id : l'identifiant d'une fiche à extraire (ou "all" pour toutes les fiches)
 */
function sendDataXMLRequest($table, $support, $params, $id)
{
    $query = variable_get('adt_server_path') . 'GetDataXML?ipstrTable='.$table.'&ipstrSupport='.$support.'&ipstrtabParams='.urlencode($params).'&ipstrId='.$id.'';
    $result = drupal_http_request($query);
    return $result->data;
}

/**
 *  Envoie une requête de type GetCritAssXMLv2 au serveur ADT :
 * 
 *  @param $table : la table visée par la requête
 *  @param $support : la "source" de la requête (ex: GP ou Nature)
 *  @param $params : les paramètres de la requête (JSON)
 */
function sendCritXMLRequest()
{
    $table = 'c_obj';
    $support = 'GP';
    $params = '';
    $query = variable_get('adt_server_path') . 'GetCritsAssXMLv2?ipstrTable='.$table.'&ipstrSupport='.$support.'&ipstrtabParams='.urlencode($params);
    $result = drupal_http_request($query);  
    return $result->data;
}

function sendListZoneXMLRequest()
{   
    $table = 'c_obj';
    $support = 'GP';
    $params = '';
    $query = variable_get('adt_server_path') . 'GetListeZonesXML?ipstrTable='.$table.'&ipstrSupport='.$support.'&ipstrType=&ipstrtabParams='.urlencode($params);
    $result = drupal_http_request($query);  
    return $result->data;
}

function sendKMLItemRequest($itemId)
{
    //$result = drupal_http_request('http://flux.cotedor-tourisme.com/kml/itineraire.php?id=' . $itemId);
    //return $result->data;
    $result = drupal_http_request('https://www.cotedor-tourisme.com/sites/all/modules/adt21_carte/parse.php?id='.$itemId.'&support=NATURE');
    return $result->data;
}





?>