﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:php="http://php.net/xsl">
	<xsl:template name="LFsToBRs">
		<xsl:param name="input" />
		<xsl:choose>
			<xsl:when test="contains($input, '&#10;')">
				<xsl:value-of select="substring-before($input, '&#10;')" /><br />
				<xsl:call-template name="LFsToBRs">
					<xsl:with-param name="input" select="substring-after($input, '&#10;')" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$input" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="strip-tags">
		<xsl:param name="descriptif" select="objs/obj/descriptif_fr"/>
		<xsl:choose>
			<xsl:when test="contains($descriptif, '&lt;')">
				<xsl:value-of select="substring-before($descriptif, '&lt;')"/>
				<xsl:call-template name="strip-tags">
					<xsl:with-param name="descriptif" select="substring-after($descriptif, '&gt;')"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$descriptif"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:variable name="_crlf">
		<xsl:text></xsl:text>
	</xsl:variable>
	<xsl:variable name="crlf" select="string($_crlf)"/>

	<xsl:template name="crlf-replace">
		<xsl:param name="subject"/>

		<xsl:choose>
			<xsl:when test="contains($subject, $crlf)">
				<xsl:value-of select="substring-before($subject, $crlf)"/>
				<br/>
				<xsl:call-template name="crlf-replace">
					<xsl:with-param name="subject" select="substring-after($subject, $crlf)"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$subject"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="/">

		<xsl:variable name="image_existante">
			<xsl:value-of select="objs/obj/obj_common/photo/ass_obj_photo[doctype='Photo']"/>
		</xsl:variable>
		<xsl:variable name="imageo">
			<!--<xsl:value-of select="concat('https://www.cotedor-tourisme.com/fics_monespacetourisme/',fic_o)"/>
			-->
					background-image: url('
			<xsl:value-of select="concat('https://www.cotedor-tourisme.com/fics_monespacetourisme/',objs/obj/obj_common/photo/ass_obj_photo[doctype='Photo']/fic_o)"/>
			');
		</xsl:variable>

		<xsl:variable name="id">
			<xsl:value-of select="objs/obj/id"/>
		</xsl:variable>

		<div class="left_column">
			<xsl:for-each select="/objs/obj/obj_common/ass_all[tbl='ass_hot_chaine']|/objs/obj/obj_common/ass_all[tbl='ass_label']">
				<xsl:if test="src_img!=''">
					<img src="{src_img}" alt="{Libelle}" title="{Libelle}" style="float:right;" />
					<xsl:text>&#160;</xsl:text>
				</xsl:if>
			</xsl:for-each>

			<div id="titre">
				<div class="agenda_txt_intro">
					<h1>
						<xsl:value-of select="objs/obj/societe"/>
						<xsl:variable name="etoile">
							<xsl:value-of select="/objs/obj/obj_common/ass_all[tbl='ass_hot_cat']/src_img"/>
						</xsl:variable>
						<xsl:if test="$etoile!=''">
							<img src="{$etoile}"/>
						</xsl:if>
					</h1>
					<xsl:variable name="horaires_existant">
						<xsl:value-of select="objs/obj/obj_common/horaire"/>
					</xsl:variable>
					<xsl:if test="$horaires_existant!=''">
						<h2>Dates et horaires d'accueil</h2>
						<p>
							<xsl:value-of select="objs/obj/obj_common/horaire"/>
						</p>
					</xsl:if>
				</div>
				<div class="agenda_img_intro">
					<xsl:choose>
						<xsl:when test="$image_existante!=''">
							<xsl:for-each select="objs/obj/obj_common/photo/ass_obj_photo[doctype='Photo']">
								<xsl:if test="position() &lt; 2">
								<xsl:variable name="image">
									<!--<xsl:value-of select="concat('https://www.cotedor-tourisme.com/fics_monespacetourisme/',fic_o)"/>
									-->
									<xsl:value-of select="concat('https://www.cotedor-tourisme.com/fics_monespacetourisme/',fic_z)"/>
								</xsl:variable>
								<xsl:variable name="imagem">
									<!--<xsl:value-of select="concat('https://www.cotedor-tourisme.com/fics_monespacetourisme/',fic_o)"/>
									-->
									<xsl:value-of select="concat('https://www.cotedor-tourisme.com/fics_monespacetourisme/',fic_m)"/>
								</xsl:variable>
								<xsl:variable name="copyr">
									<!--<xsl:value-of select="concat('https://www.cotedor-tourisme.com/fics_monespacetourisme/',fic_o)"/>
									-->
								<xsl:value-of select="copyright"/>
								</xsl:variable>
								<xsl:variable name="titre">
									<!--<xsl:value-of select="concat('https://www.cotedor-tourisme.com/fics_monespacetourisme/',fic_o)"/>
									-->
								<xsl:value-of select="titre"/>
								</xsl:variable>

								<img src="{$image}" title="{$copyr}" alt="{$titre}" class="image1" />
								</xsl:if>
							</xsl:for-each>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>&#160;</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</div>
				<hr class="clear"/>
			</div>
			<div id="contenu" >
				<xsl:variable name="descriptif">
					<xsl:value-of select="objs/obj/descriptif_fr"/>
				</xsl:variable>
				<div id="left_desc">
					<xsl:if test="$descriptif!=''">
						<h2>Descriptif</h2>
						<xsl:call-template name="LFsToBRs">
							<xsl:with-param name="input" select="objs/obj/descriptif_fr"/>
						</xsl:call-template>
					</xsl:if>

					<xsl:variable name="tarif_mini_existant">
						<xsl:value-of select="objs/obj/obj_common/ass_all_tar/mini_euro"/>
					</xsl:variable>

					<xsl:variable name="tarif_maxi_existant">
						<xsl:value-of select="objs/obj/obj_common/ass_all_tar/mini_euro"/>
					</xsl:variable>

					<xsl:variable name="tarif_libelle_existant">
						<xsl:value-of select="objs/obj/obj_common/ass_all_tar/Libelle"/>
					</xsl:variable>

					<xsl:if test="$tarif_mini_existant!='' or $tarif_maxi_existant!='' or $tarif_libelle_existant!=''">
						<h2>Tarifs</h2>
						<ul title="Tarifs" id="tarifs">
							<xsl:variable name="tarif_mini">
								<xsl:value-of select="objs/obj/obj_common/ass_all_tar/mini_euro"/>
							</xsl:variable>
							<xsl:variable name="tarif_maxi">
								<xsl:value-of select="objs/obj/obj_common/ass_all_tar/maxi_euro"/>
							</xsl:variable>
							<xsl:variable name="tarif_libelle">
								<xsl:value-of select="objs/obj/obj_common/ass_all_tar/Libelle"/>
							</xsl:variable>
							<xsl:variable name="tarif_complement">
								<xsl:value-of select="objs/obj/obj_common/ass_all_tar/complement"/>
							</xsl:variable>
							<xsl:variable name="mini_euro2">
								<xsl:value-of select="objs/obj/obj_common/ass_all_tar/mini_euro"/>
							</xsl:variable>
							<xsl:variable name="maxi_euro2">
								<xsl:value-of select="objs/obj/obj_common/ass_all_tar/maxi_euro"/>
							</xsl:variable>
							<xsl:if test="$tarif_mini!='' or $tarif_maxi!=''">
								<xsl:for-each select="objs/obj/obj_common/ass_all_tar">
									<li>
										<xsl:value-of select="Libelle"/>
										<xsl:text>:</xsl:text>
										<xsl:variable name="mini_euro">
											<xsl:value-of select="mini_euro"/>
										</xsl:variable>
										<xsl:variable name="maxi_euro">
											<xsl:value-of select="maxi_euro"/>
										</xsl:variable>
										<xsl:if test="$mini_euro=$maxi_euro">
											Tarif unique de
											<xsl:value-of select="maxi_euro"/>
											€
											<xsl:if test="$tarif_complement!=''">
												(
												<xsl:value-of select="complement"/>
												)
											</xsl:if>
										</xsl:if>
										<xsl:if test="$maxi_euro='' and $mini_euro!=''">
											Tarif à partir de
											<xsl:value-of select="mini_euro"/>
											€
											<xsl:if test="$tarif_complement!=''">
												(
												<xsl:value-of select="complement"/>
												)
											</xsl:if>
										</xsl:if>
										<xsl:if test="$mini_euro='' and $maxi_euro!=''">
											Tarif jusqu'à
											<xsl:value-of select="maxi_euro"/>
											€
											<xsl:if test="$tarif_complement!=''">
												(
												<xsl:value-of select="complement"/>
												)
											</xsl:if>
										</xsl:if>
										<xsl:if test="$maxi_euro!=$mini_euro and $maxi_euro!='' and $mini_euro!=''">
											Tarif à partir de
											<xsl:value-of select="mini_euro"/>
											€  jusqu'à
											<xsl:value-of select="maxi_euro"/>
											€
											<xsl:if test="$tarif_complement!=''">
												(
												<xsl:value-of select="complement"/>
												)
											</xsl:if>
										</xsl:if>
									</li>
								</xsl:for-each>
							</xsl:if>
							<xsl:if test="$tarif_libelle!='' and $mini_euro2='' and $maxi_euro2=''">
								<xsl:value-of select="objs/obj/obj_common/ass_all_tar/Libelle"/>
							</xsl:if>
						</ul>
					</xsl:if>
				</div>
				<div id="right_desc">
					<xsl:variable name="adresse_existante">
						<xsl:value-of select="objs/obj/adresse1"/>
					</xsl:variable>

					<xsl:if test="$adresse_existante!=''">
						<p>
							<span class="red">Adresse : </span>
							<xsl:value-of select="objs/obj/adresse1"/>
						</p>
						<p>
							<span class="red">Code postal : </span>
							<xsl:value-of select="objs/obj/cp"/>
						</p>
						<xsl:text></xsl:text>
						<p>
							<span class="red">Localité : </span>
							<xsl:value-of select="objs/obj/localite"/>
						</p>
					</xsl:if>

					<xsl:variable name="telephone">
						<xsl:value-of select="objs/obj/obj_common/tel1"/>
					</xsl:variable>
					<xsl:if test="$telephone!=''">
						<p>
							<span class="red">Téléphone : </span>
							<xsl:value-of select="objs/obj/obj_common/tel1"/>
						</p>
					</xsl:if>

					<xsl:variable name="email">
						<xsl:value-of select="objs/obj/obj_common/mel1"/>
					</xsl:variable>

					<xsl:if test="$email!=''">
						<p>
							<span class="red">Courriel : </span>
							<a href="mailto:{$email}">
								<xsl:value-of select="objs/obj/obj_common/mel1"/>
							</a>
						</p>
					</xsl:if>

					<xsl:variable name="site">
						<xsl:value-of select="objs/obj/obj_common/site1"/>
					</xsl:variable>
					<xsl:if test="$site!=''">
						<p>
							<span class="red">Site Internet : </span>
							<a href="{$site}">
								<xsl:value-of select="objs/obj/obj_common/site1"/>
							</a>
						</p>
					</xsl:if>
					<xsl:value-of select="php:function('getButton',$id)" disable-output-escaping="yes" />
				</div>
			</div>
			<div id="carte" style="width:550px; height: 400px;" >&#160;</div>
		</div>
		<div class="right_column">
			<xsl:value-of select="php:function('buildBlockLeftCol')" disable-output-escaping="yes" />
		</div>
		<hr class="clear"/>
	</xsl:template>
</xsl:stylesheet>