﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template name="coupe">
	<xsl:param name="s" />
	<xsl:if test="contains($s,' ')">
		<xsl:variable name="s2">
			<xsl:call-template name="coupe">
				<xsl:with-param name="s" select="substring-after($s,' ')"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:value-of select="concat(substring-before($s,' '),' ',$s2)"/>
	</xsl:if>
</xsl:template>

<xsl:template name="strip-tags">
	<xsl:param name="descriptif" />
	<xsl:choose>
		<xsl:when test="contains($descriptif, '&lt;')">
			<xsl:value-of select="substring-before($descriptif, '&lt;')"/>
			<xsl:call-template name="strip-tags">
				<xsl:with-param name="descriptif" select="substring-after($descriptif, '&gt;')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="$descriptif"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="string-replace">

	<xsl:param name="str" />

   	<xsl:param name="search" />

	<xsl:param name="replace" />

	<xsl:choose>

		<xsl:when test="$search and contains($str, $search)">

			<xsl:value-of select="substring-before($str, $search)" />

			<xsl:value-of select="$replace" />

			<xsl:call-template name="string-replace">

   				<xsl:with-param name="str" select="substring-after($str, $search)" />

   				<xsl:with-param name="search" select="$search" />

   				<xsl:with-param name="replace" select="$replace" />	

			</xsl:call-template>

		</xsl:when>

		<xsl:otherwise>

			<xsl:value-of select="$str" />

		</xsl:otherwise>

	</xsl:choose>

</xsl:template> 


<xsl:template match="/">


	
			<table cellspacing="0" cellpadding="0" width="100%">
			<xsl:for-each select="objs/obj">
				<xsl:variable name="id">
					<xsl:value-of select="id"/>
				</xsl:variable>
	
				<xsl:variable name="obj">
					<xsl:value-of select="substring($id,1,3)"/>
				</xsl:variable>
				
				<xsl:variable name="objMaj">
				<xsl:value-of select="translate($obj,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')" />					
				</xsl:variable>		
				<xsl:variable name="etoile">
					<xsl:value-of select="obj_common/ass_all[tbl='ass_hot_cat']/src_img"/>
				</xsl:variable>
					
				<xsl:variable name="chemin_photo">
					<xsl:value-of select="obj_common/photo/ass_obj_photo/fic_m"/>
				</xsl:variable>
				
				<xsl:variable name="chaine">
					<xsl:value-of select="obj_common/ass_all[tbl='ass_hot_chaine']/src_img"/>
				</xsl:variable>
								
				<xsl:variable name="label">
					<xsl:value-of select="obj_common/ass_all[tbl='ass_label']/src_img"/>
				</xsl:variable>
				
				<xsl:variable name="hlo_epis">
					<xsl:value-of select="obj_common/obj_hlo_spec/nb_epis"/>
				</xsl:variable>
				
				<xsl:variable name="cht_epis">
					<xsl:value-of select="obj_common/obj_cht_spec/nb_epis"/>
				</xsl:variable>
				
				<tr>	
					<!--<td class="visuliens">
						<ul>
							<xsl:if test="$chemin_photo!=''">
							
							
								<xsl:variable name="chemin">
									<xsl:if test="substring(obj_common/photo/ass_obj_photo/fic_m,21,3)!='://'">
									
									<xsl:value-of select="concat('https://www.cotedor-tourisme.com/fics_monespacetourisme/',obj_common/photo/ass_obj_photo/fic_m)"/>
									</xsl:if>
									<xsl:if test="substring(obj_common/photo/ass_obj_photo/fic_m,21,3)='://'">
									<xsl:value-of select="concat('http',substring(obj_common/photo/ass_obj_photo/fic_m,21))"/>
									
									</xsl:if>
								</xsl:variable>
								<li>
								
								
									<a href="index.php?lg=fr&amp;rub=10&amp;srub=&amp;id_objet={$id}&amp;section=detail"><div ><img  id="image" src="fics_monespacetourisme/redim.php?img_Src={$chemin}" style="cursor:pointer;" class="corners iradiae1001" alt="" /></div></a>
									
								</li>
								
				          		</xsl:if>
							   <li><a href="index.php?vil_court=&amp;lg=fr&amp;rub=19&amp;srub=04&amp;id_objet={$obj}&amp;ajouter"><img src="pics/06/fr/ajouter-espace.gif" alt="" /></a></li>     
					
						</ul>
					</td>!-->
						
					
					
					<td>
					
						
						<xsl:if test="$chaine!=''">
							<img src="{$chaine}"/> <xsl:text> </xsl:text>
						</xsl:if>
						
						<xsl:if test="$label!=''">
						<span class="infoplus">
							<xsl:for-each select="obj_common/ass_all[tbl='ass_label']/src_img">
								<xsl:variable name="lien_label">
									<xsl:value-of select="."/> 
								</xsl:variable>
								<img src="{$lien_label}"/> <xsl:text> </xsl:text>
								
							</xsl:for-each>
						</span>
						</xsl:if>
						
						<h2>
						<img src="pics_communs/icones/gm/{$objMaj}.png" />
						
							<a href="index.php?lg=fr&amp;rub=10&amp;srub=&amp;id_objet={$id}&amp;section=detail"><xsl:value-of select="societe"/></a>
							<xsl:if test="$etoile!=''">
								<sup><img src="{$etoile}"/></sup>
							</xsl:if>
							<xsl:if test="$cht_epis !=''">
								<xsl:variable name="lien_cht_epis">
									<xsl:value-of select="concat('https://www.cotedor-tourisme.com/pics_communs/epis',$cht_epis,'EP.gif')"/>
								</xsl:variable>	
								<img src="{$lien_cht_epis}"/>
							</xsl:if>
							
							<xsl:if test="$hlo_epis !=''">
								<xsl:variable name="lien_hlo_epis">
									<xsl:value-of select="concat('https://www.cotedor-tourisme.com/pics_communs/epis',$hlo_epis,'EP.gif')"/>
								</xsl:variable>	
								<img src="{$lien_hlo_epis}"/>
							</xsl:if>
							
						</h2>
						<xsl:if test="$objMaj='FMA'">
						<i><xsl:value-of select="obj_common/horaire" /></i><br/>
						</xsl:if>
							
						
							<b><xsl:value-of select="localite"/></b><br/>
							<xsl:variable name="descriptif">
								<xsl:value-of select="descriptif_fr"/><br/>
							</xsl:variable>
							<xsl:call-template name="coupe">
								<xsl:with-param name="s" select="substring(normalize-space($descriptif),0,150)"/>
							</xsl:call-template>
							<xsl:if test="$descriptif !=''">
								<xsl:text>...</xsl:text>
							</xsl:if>
							<br />
							<!--<strong>Extrait(s) audio à écouter :</strong><br />		!-->	
							      
							
      
    
      
							
							
							
							<xsl:for-each select="obj_common/photo/ass_obj_photo[doctype='Musique']">
								<xsl:variable name="audi">
									<xsl:value-of select="concat('swf/lecteur_objet.swf?son=../fics_monespacetourisme/',fic_o)"/>				
								</xsl:variable>
								<xsl:variable name="audiosrc">
									<xsl:value-of select="concat('../fics_monespacetourisme/',fic_o)"/>				
								</xsl:variable>
								<xsl:variable name="idaudi">
									<xsl:value-of select="id_ligne"/>				
								</xsl:variable>
								<xsl:variable name="audisrc">
								<xsl:value-of select="concat($audi,'&amp;joue=Cliquer+pour+%C3%A9couter&amp;arret=Arr%C3%AAter')"/>
								</xsl:variable>
								<br />
								
								<xsl:variable name="titreaudio" >
								 <strong><xsl:value-of select="titre"/></strong> - <xsl:value-of select="copyright"/>
								</xsl:variable>
								
								<xsl:variable name="sear1" >\\</xsl:variable>
								<xsl:variable name="rep1"></xsl:variable>
								<i><strong>
								<xsl:variable name="titreaudiocpl">
								<xsl:call-template name="string-replace">
									<xsl:with-param name="str" select="$titreaudio"/>
									<xsl:with-param name="search" select="$sear1"/>
									<xsl:with-param name="replace" select="$rep1"/>
								</xsl:call-template>
								</xsl:variable>
								<xsl:copy-of select="$titreaudiocpl" />
								</strong>
								</i>
								
								
								 <!--
								<xsl:call-template name="string-replace">
									<xsl:with-param name="str" select="copyright"/>
									<xsl:with-param name="search" select="$sear"/>
									<xsl:with-param name="replace" select="$rep"/>
								</xsl:call-template>
								!-->
								<br />
								<!--<div id="flash_sej_mp3_{$idaudi}"></div>
								<script type="text/javascript">
								
								var srcmp3= "<xsl:value-of select="$audisrc"/>";
								// <![CDATA[
								var so = new SWFObject(srcmp3, "titre", "200", "24", "8", "#fcf7df", false);
								so.addParam("allowScriptAccess", "sameDomain");
								so.addParam("menu", "false");
								so.addParam("scale", "exactfit");
								
								// ]]>
								so.write("<xsl:value-of select="concat('flash_sej_mp3_',$idaudi)"/>");
								</script>
								!-->
								  <object type="application/x-shockwave-flash" data="swf/dewplayer.swf" width="200" height="20" id="dewplayer{$idaudi}" name="dewplayer"> 
								  <param name="wmode" value="transparent" />
								  <param name="movie" value="swf/dewplayer.swf" />
								  <param name="flashvars" value="mp3={$audiosrc}&amp;showtime=1" /> </object>
								 <br />
								 
								 <xsl:variable name="descrson">
								 <xsl:call-template name="strip-tags">
									<xsl:with-param name="descriptif" select="description"/>
								</xsl:call-template>
								</xsl:variable>
								
								<xsl:variable name="sear2">d’</xsl:variable>
								<xsl:variable name="rep2">d'</xsl:variable>
								
								 <xsl:call-template name="string-replace">
									<xsl:with-param name="str" select="translate($descrson,'–','-')"/>
									<xsl:with-param name="search" select="$sear2"/>
									<xsl:with-param name="replace" select="$rep2"/>
								</xsl:call-template>
								<xsl:if test="$descrson !=''">
								<br />
								</xsl:if>
							</xsl:for-each>
							
							
							<br/>							
							<!--<a class="plus" href="index.php?lg=fr&amp;rub=10&amp;srub=&amp;id_objet={$id}&amp;section=detail">en savoir plus</a>!-->
						
					</td>
				</tr>
				<tr>
					<td class="separateur moyen" colspan="2"><xsl:text> &#160; </xsl:text></td>
				</tr>
	
			</xsl:for-each>	
			</table>
	

</xsl:template>
</xsl:stylesheet>
