﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:php="http://php.net/xsl">
<xsl:output method="html" version="4.0" />
<xsl:template name="coupe">
	<xsl:param name="s" />
	<xsl:if test="contains($s,' ')">
		<xsl:variable name="s2">
			<xsl:call-template name="coupe">
				<xsl:with-param name="s" select="substring-after($s,' ')"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:value-of select="concat(substring-before($s,' '),' ',$s2)"/>
	</xsl:if>
</xsl:template>
<xsl:template name="removeHtmlTags">
    <xsl:param name="html"/>
    <xsl:choose>
      <xsl:when test="contains($html, '&lt;')">
        <xsl:value-of select="substring-before($html, '&lt;')"/>
        <!-- Recurse through HTML -->
        <xsl:call-template name="removeHtmlTags">
          <xsl:with-param name="html" select="substring-after($html, '&gt;')"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$html"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

<xsl:variable name="coul_picto">
		<xsl:value-of select="php:function('getCoul')"/>
</xsl:variable>

<xsl:template match="/">


	
			<table cellspacing="0" cellpadding="0" width="500px">
			<xsl:for-each select="objs/obj">
				<xsl:variable name="id">
					<xsl:value-of select="id"/>
				</xsl:variable>
	
				<xsl:variable name="obj">
					<xsl:value-of select="substring($id,1,3)"/>
				</xsl:variable>
				
				<xsl:variable name="objMaj">
				<xsl:value-of select="translate($obj,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')" />					
				</xsl:variable>		
				<xsl:variable name="etoile">
					<xsl:value-of select="obj_common/ass_all[tbl='ass_hot_cat']/src_img"/>
				</xsl:variable>
					
				<xsl:variable name="chemin_photo">
					<xsl:value-of select="obj_common/photo/ass_obj_photo/fic_m"/>
				</xsl:variable>
				
				<xsl:variable name="chaine">
					<xsl:value-of select="obj_common/ass_all[tbl='ass_hot_chaine']/src_img"/>
				</xsl:variable>
								
				<xsl:variable name="label">
					<xsl:value-of select="obj_common/ass_all[tbl='ass_label']/src_img"/>
				</xsl:variable>
				
				<xsl:variable name="hlo_epis">
					<xsl:value-of select="obj_common/obj_hlo_spec/nb_epis"/>
				</xsl:variable>
				
				<xsl:variable name="cht_epis">
					<xsl:value-of select="obj_common/obj_cht_spec/nb_epis"/>
				</xsl:variable>
				<xsl:variable name="lien_fiche">
					<xsl:value-of select="php:function('creer_lien_fichepanier',string(societe),$id)"/>
				</xsl:variable>
				
				
				<tr>	
					<td class="visuliens">
						
				          		
							   <xsl:value-of select="php:function('getButton',$id)" disable-output-escaping="yes" />     
					
						
					</td>
						
					
					
					<td>
					
						
						
							<img src="https://www.cotedor-tourisme.com/pics_communs/icones/gm/{$coul_picto}{$objMaj}.png" style="width:20px;padding-right:3px;" />	
						
							<a class="plus" href="{$lien_fiche}"><xsl:value-of select="societe"/></a>
							
							-
						
							<xsl:value-of select="localite"/>
							
						
					</td>
				</tr>
				<tr>
					<td class="separateur moyen" colspan="2"><xsl:text> &#160; </xsl:text></td>
				</tr>
	
			</xsl:for-each>	
			</table>
	

</xsl:template>
</xsl:stylesheet>
