﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:php="http://php.net/xsl">

<xsl:template name="coupe">
	<xsl:param name="s" />
	<xsl:if test="contains($s,' ')">
		<xsl:variable name="s2">
			<xsl:call-template name="coupe">
				<xsl:with-param name="s" select="substring-after($s,' ')"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:value-of select="concat(substring-before($s,' '),' ',$s2)"/>
	</xsl:if>
</xsl:template>



<xsl:template match="/">


	
			
			<xsl:for-each select="objs/obj">
				<xsl:variable name="id">
					<xsl:value-of select="id"/>
				</xsl:variable>
	
				<xsl:variable name="obj">
					<xsl:value-of select="substring($id,1,3)"/>
				</xsl:variable>
				
				<xsl:variable name="objMaj">
				<xsl:value-of select="translate($obj,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')" />					
				</xsl:variable>		
				<xsl:variable name="etoile">
					<xsl:value-of select="obj_common/ass_all[tbl='ass_hot_cat']/src_img"/>
				</xsl:variable>
					
				<xsl:variable name="chemin_photo">
					<xsl:value-of select="obj_common/photo/ass_obj_photo/fic_m"/>
				</xsl:variable>
				
				<xsl:variable name="chaine">
					<xsl:value-of select="obj_common/ass_all[tbl='ass_hot_chaine']/src_img"/>
				</xsl:variable>
								
				<xsl:variable name="label">
					<xsl:value-of select="obj_common/ass_all[tbl='ass_label']/src_img"/>
				</xsl:variable>
				
				<xsl:variable name="hlo_epis">
					<xsl:value-of select="obj_common/obj_hlo_spec/nb_epis"/>
				</xsl:variable>
				
				<xsl:variable name="cht_epis">
					<xsl:value-of select="obj_common/obj_cht_spec/nb_epis"/>
				</xsl:variable>
				
				<xsl:variable name="lien_fiche">
						<xsl:value-of select="php:function('creer_lien_fiche',string(societe),$id)"/>
						</xsl:variable>
						
		
						
					
					
						
						<h3>
						
						
							<a href="bourgogne/toutes-les-sorties{$lien_fiche}"><xsl:value-of select="societe"/></a>
							
							
						</h3>
					
							
							<xsl:if test="$objMaj='FMA'">
								<b><xsl:value-of select="obj_common/horaire" /> - <xsl:value-of select="localite"/></b><br/>
							</xsl:if>
							
						
							
							<xsl:variable name="descriptif">
								<xsl:value-of select="descriptif_fr"/><br/>
							</xsl:variable>
							<xsl:call-template name="coupe">
								<xsl:with-param name="s" select="substring(normalize-space($descriptif),0,150)"/>
							</xsl:call-template>
							<xsl:if test="$descriptif !=''">
								<xsl:text>...</xsl:text>
								
							</xsl:if>			
							
							
							<br />	<a href="bourgogne/toutes-les-sorties{$lien_fiche}" style="float:right;" >en savoir plus</a><br/>
							</xsl:for-each>	

	

</xsl:template>
</xsl:stylesheet>
