<?php
/**
 * Convertitune chaîne XML en tableau PHP
 *
 * @param string $xml
 * @return array
 */
function xml2array($contents, $get_attributes=1, $priority = 'tag') { 
    if(!$contents) return array(); 

    if(!function_exists('xml_parser_create')) { 
        //print "'xml_parser_create()' function not found!"; 
        return array(); 
    } 

    //Get the XML parser of PHP - PHP must have this module for the parser to work 
    $parser = xml_parser_create(''); 
    xml_parser_set_option($parser, XML_OPTION_TARGET_ENCODING, "UTF-8"); # http://minutillo.com/steve/weblog/2004/6/17/php-xml-and-character-encodings-a-tale-of-sadness-rage-and-data-loss 
    xml_parser_set_option($parser, XML_OPTION_CASE_FOLDING, 0); 
    xml_parser_set_option($parser, XML_OPTION_SKIP_WHITE, 1); 
    xml_parse_into_struct($parser, trim($contents), $xml_values); 
    xml_parser_free($parser); 

    if(!$xml_values) return;//Hmm... 

    //Initializations 
    $xml_array = array(); 
    $parents = array(); 
    $opened_tags = array(); 
    $arr = array(); 

    $current = &$xml_array; //Refference 

    //Go through the tags. 
    $repeated_tag_index = array();//Multiple tags with same name will be turned into an array 
    foreach($xml_values as $data) { 
        unset($attributes,$value);//Remove existing values, or there will be trouble 

        //This command will extract these variables into the foreach scope 
        // tag(string), type(string), level(int), attributes(array). 
        extract($data);//We could use the array by itself, but this cooler. 

        $result = array(); 
        $attributes_data = array(); 
         
        if(isset($value)) { 
            if($priority == 'tag') $result = $value; 
            else $result['value'] = $value; //Put the value in a assoc array if we are in the 'Attribute' mode 
        } 

        //Set the attributes too. 
        if(isset($attributes) and $get_attributes) { 
            foreach($attributes as $attr => $val) { 
                if($priority == 'tag') $attributes_data[$attr] = $val; 
                else $result['attr'][$attr] = $val; //Set all the attributes in a array called 'attr' 
            } 
        } 

        //See tag status and do the needed. 
        if($type == "open") {//The starting of the tag '<tag>' 
            $parent[$level-1] = &$current; 
            if(!is_array($current) or (!in_array($tag, array_keys($current)))) { //Insert New tag 
                $current[$tag] = $result; 
                if($attributes_data) $current[$tag. '_attr'] = $attributes_data; 
                $repeated_tag_index[$tag.'_'.$level] = 1; 

                $current = &$current[$tag]; 

            } else { //There was another element with the same tag name 

                if(isset($current[$tag][0])) {//If there is a 0th element it is already an array 
                    $current[$tag][$repeated_tag_index[$tag.'_'.$level]] = $result; 
                    $repeated_tag_index[$tag.'_'.$level]++; 
                } else {//This section will make the value an array if multiple tags with the same name appear together
                    $current[$tag] = array($current[$tag],$result);//This will combine the existing item and the new item together to make an array
                    $repeated_tag_index[$tag.'_'.$level] = 2; 
                     
                    if(isset($current[$tag.'_attr'])) { //The attribute of the last(0th) tag must be moved as well
                        $current[$tag]['0_attr'] = $current[$tag.'_attr']; 
                        unset($current[$tag.'_attr']); 
                    } 

                } 
                $last_item_index = $repeated_tag_index[$tag.'_'.$level]-1; 
                $current = &$current[$tag][$last_item_index]; 
            } 

        } elseif($type == "complete") { //Tags that ends in 1 line '<tag />' 
            //See if the key is already taken. 
            if(!isset($current[$tag])) { //New Key 
                $current[$tag] = $result; 
                $repeated_tag_index[$tag.'_'.$level] = 1; 
                if($priority == 'tag' and $attributes_data) $current[$tag. '_attr'] = $attributes_data; 

            } else { //If taken, put all things inside a list(array) 
                if(isset($current[$tag][0]) and is_array($current[$tag])) {//If it is already an array... 

                    // ...push the new element into that array. 
                    $current[$tag][$repeated_tag_index[$tag.'_'.$level]] = $result; 
                     
                    if($priority == 'tag' and $get_attributes and $attributes_data) { 
                        $current[$tag][$repeated_tag_index[$tag.'_'.$level] . '_attr'] = $attributes_data; 
                    } 
                    $repeated_tag_index[$tag.'_'.$level]++; 

                } else { //If it is not an array... 
                    $current[$tag] = array($current[$tag],$result); //...Make it an array using using the existing value and the new value
                    $repeated_tag_index[$tag.'_'.$level] = 1; 
                    if($priority == 'tag' and $get_attributes) { 
                        if(isset($current[$tag.'_attr'])) { //The attribute of the last(0th) tag must be moved as well
                             
                            $current[$tag]['0_attr'] = $current[$tag.'_attr']; 
                            unset($current[$tag.'_attr']); 
                        } 
                         
                        if($attributes_data) { 
                            $current[$tag][$repeated_tag_index[$tag.'_'.$level] . '_attr'] = $attributes_data; 
                        } 
                    } 
                    $repeated_tag_index[$tag.'_'.$level]++; //0 and 1 index is already taken 
                } 
            } 

        } elseif($type == 'close') { //End of tag '</tag>' 
            $current = &$parent[$level-1]; 
        } 
    } 
     
    return($xml_array); 
}


    
/**
 * Convertit les retours à la ligne systèmes en html
 *  -> remplace la fonction nl2br native
 * 
 * @param string $string La chaîne à traiter
 * @return string la chaîne transformée 
*/  
function nl2br2($string)
{
    $string = str_replace(array('\r\n', '\r', '\n'), '<br />', $string);
    return $string; 
} 


/**
 *  Découpe une chaîne au bout d'un certain nombre de mots :
 * 
 *  @param string $string La chaîne à raccourcir
 *  @param string $numWords Le nombre de mots au bout du quel découper la chaîne
 */
function limitWords($string, $numWords)
{
    $wordCount = 0;
    $newString = '';
    $numLetters = strlen($string);
    
    for ($i = 0; $i < $numLetters; $i++)
    {
        $letter = substr($string, $i, 1);
        
        if (substr($string, $i, 1) == ' ')
        {
            $wordCount ++;
            
            if ($wordCount == $numWords)
                return $newString . '&hellip;';
        }
        
        $newString .= $letter;
    }
    
    //-- si on a pas atteint le nombre de mots max, on renvoit la chaîne telle quelle
    return $string;
}

/**
 *  Remplace tous les accents par des caractères normaux :
 */
function strip_accents($str)
{
    $replace = array('à'=>'a', 
        'á'=>'a', 
        'â'=>'a', 
        'ã'=>'a', 
        'ä'=>'a', 
        'å'=>'a', 
        'ò'=>'o', 
        'ó'=>'o', 
        'ô'=>'o', 
        'õ'=>'o', 
        'ö'=>'o', 
        'è'=>'e', 
        'é'=>'e', 
        'ê'=>'e', 
        'ë'=>'e', 
        'ì'=>'i', 
        'í'=>'i', 
        'î'=>'i', 
        'ï'=>'i', 
        'ù'=>'u', 
        'ú'=>'u', 
        'û'=>'u', 
        'ü'=>'u', 
        'ÿ'=>'y', 
        'ñ'=>'n', 
        'ç'=>'c', 
        'ø'=>'0',
        'œ'=>'o',
    );
    return strtr($str, $replace); 
}


/**
 *  Effectue une comparaison de chaînes de caractères insensible à la casse et aux accents :
 */
function compare_strings($a, $b)
{
    return strcasecmp(strip_accents(mb_strtolower($a)), strip_accents(mb_strtolower($b)));
}

function is_ajax_request(){
    if(!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {
            return true;
        }else{
            return false;
        }
}



/**
 *  Fonction pour rechercher les liens morts et trouver leur nouveau chemin dans Drupal.
 * 
 *  Attention : la fonction n'est pas généraliste, en l'état elle ne sert que pour les textes
 *  "patrimoine" des circuits. On peut peut-être la réutiliser pour d'autres cas avec
 *  quelques modifs...
 */
/*function fix_links()
{
    $output = '';
  
    $results = db_select('field_data_field_texte_patrimoine', 't')
            ->fields('t', array('entity_id', 'field_texte_patrimoine_value'))
            ->execute()
            ->fetchAll();

    foreach ($results as $res)
    {
       $v = $res->field_texte_patrimoine_value;
       $apos = -1;
       $inc = 0;

       while (($apos = @strpos($v, '<a', $apos+1)) !== FALSE)
       {
           $ihref = @strpos($v, 'href=', $apos+1);

           if ($ihref !== FALSE)
           {
              $quote = substr($v, $ihref+5, 1);
              $endhref = strpos($v, $quote, $ihref+6);
              $href = substr($v, $ihref+6, $endhref - $ihref - 6);

              if ($href != '#')
              {
                  if (substr($href, 0, 1) == '/') $href = substr($href, 1);

                  $src = drupal_lookup_path('source', $href);

                  //-- si la source n'est pas trouvée, le lien n'est plus valide !
                  if (!$src)
                  {
                      $search = db_select('url_alias', 't')
                              ->fields('t', array('source', 'alias'))
                              ->condition('alias', '%'.$href.'%', 'LIKE')
                              ->execute()
                              ->fetchAll();

                      $output .= '<li>Chemin introuvable : ' . $href . '<br />';

                      $nbCorres = 0;
                      $source = '';

                      foreach($search as $s)
                      {
                          $source = $s->alias;
                          $nbCorres ++;
                      }

                      if ($nbCorres == 0)
                      {
                          $output .= 'Pas de correspondance ! (nid=' . $res->entity_id . ')';

                          if ($href == 'petites-histoires'){
                              $source = 'patrimoine';
                              $nbCorres = 1;
                          }
                      }

                      if ($nbCorres > 1)
                      {
                          $output .= 'Plusieurs correspondances ? (nb=' . $nbCorres . ')';

                          if ($href == 'au-fil-de-leau/lavoir'){
                              $source = 'patrimoine/' . $href;
                              $nbCorres = 1;
                          }
                      }

                      if ($nbCorres == 1)
                      {
                          $v = substr($v, 0, $ihref + 6) . '/' . $source . substr($v, $endhref);
                          $output .= $v;

                          //-- mise à jour du champ !
                          db_update('field_data_field_texte_patrimoine')
                          ->fields(array(
                              'field_texte_patrimoine_value' => $v,
                          ))
                          ->condition('entity_id', $res->entity_id, '=')
                          ->execute();
                      }

                      $output .= '</li>';
                  }
              }
           }
       }

       $output .= '<hr>';
    }
}*/
?>