<?php

/**
 * Implements hook_preprocess_page().
 */
function md_make_preprocess_page(&$vars, $hook) {
  global $base_url;
  $args = arg();
  $node_type = menu_get_object();
  // Hide title front, type 
  if ($vars['is_front']) {
    $vars['title'] = '';
  }

  if ($args[0] == 'taxonomy' && $args[1] == 'term' && is_numeric($args[2])) {
    $vars['page']['content']['system_main']['nodes']['#prefix'] = '<div class="list_teaser clearfix">';
    $vars['page']['content']['system_main']['nodes']['#suffix'] = '</div>';
  }

  if ($args[0] == 'comment' && $args[1] == 'reply') {
    $node = node_load($args[2]);
    $vars['theme_hook_suggestions'][] = 'page__comment__reply__type__' . $node->type;
  }

  //Hook suggestion
  if (isset($vars['node'])) {
    $vars['theme_hook_suggestions'][] = 'page__node__type__' . $vars['node']->type;
  }
  
  if ($args[0] == 'taxonomy') {
    $vars['theme_hook_suggestions'][] = 'page__taxonomy';
  }

  if ($args[0] == 'search') {
    $vars['theme_hook_suggestions'][] = 'page__search__results';
  }

  if(drupal_match_path(drupal_get_path_alias(), 'contact-full-map') && $node_type->type == 'webform'){
    $vars['theme_hook_suggestions'][] = 'page__contact_us';
  }

  // Publishing Options
  $vars['has_slider'] = FALSE;
  if(isset($vars['node']) && ($vars['node']->type == 'page')){
    if($vars ['node']->not_header_section == 1) $vars['has_slider'] = TRUE;   
    // $vars['theme_hook_suggestions'][] = 'page__node__type__basic_slider';
  }

  // Theme-Settings Header
  $vars['menu_header_style'] = '';
  $vars['drop_down'] = FALSE;
  if (theme_get_setting('header_type') == 'one') {
    $vars['menu_header_style'] = 'logo-left';
  }
  elseif (theme_get_setting('header_type') == 'second') {
    $vars['menu_header_style'] = 'logo-center';
  }

  // Theme-Settings Header Sticky
  $vars['header_sticky'] = 'not_sticky';
  if (theme_get_setting('header_fixed') == TRUE) {
      $vars['header_sticky'] = 'fixed-topnav';
  }

  // Theme-Settings Header Fullwidth
  $vars['header_container'] = '';
  if (theme_get_setting('header_fullwidth') == FALSE) {
      $vars['header_container'] = 'container';
  }

  // Theme-Settings Header Transparent
  $vars['region_header_transparent'] = 'region_not_transparent';
  if (theme_get_setting('header_transparent') == TRUE) {
      $vars['region_header_transparent'] = 'region_transparent';
  }


  // Theme-Settings BLog Single
  $vars['blog_single_full'] = '';
  $vars['blog_single_sidebar'] = '';
  if (theme_get_setting('blog_single_full_sidebar') == 'full') {
    $vars['blog_single_left'] = 'col-md-12';
    $vars['blog_single_right'] = 'display-none';
  }
  elseif (theme_get_setting('blog_single_full_sidebar') == 'right') {
    $vars['blog_single_left'] = 'col-md-8';
    $vars['blog_single_right'] = 'col-md-3 col-md-offset-1 blog-sidebar';
  }
  else {
    $vars['blog_single_left'] = 'col-sm-push-4 col-md-8 col-sm-8 col-md-offset-0 col-sm-offset-0';
    $vars['blog_single_right'] = 'col-md-3 col-sm-pull-8 col-sm-4 col-md-offset-0 blog-sidebar';
  }

  // Theme-Settings BLog list
  $vars['blog_list_left'] = '';
  $vars['blog_list_right'] = '';
  if(theme_get_setting('classic_setting') == 'classic_fullwidth' && theme_get_setting('chosse_blog_list') == 'classic' || theme_get_setting('masonry_setting') == 'masonry_3col' && theme_get_setting('chosse_blog_list') == 'masonry' || theme_get_setting('masonry_setting') == 'masonry_4col' && theme_get_setting('chosse_blog_list') == 'masonry'|| theme_get_setting('grid_setting') == 'grid_3col' && theme_get_setting('chosse_blog_list') == 'grid' || theme_get_setting('grid_setting') == 'grid_4col' && theme_get_setting('chosse_blog_list') == 'grid'){
      $vars['blog_list_left'] = 'col-md-12';
      $vars['blog_list_right'] = 'display-none';
    }elseif(theme_get_setting('classic_setting') == 'classic_sidebar_left' && theme_get_setting('chosse_blog_list') == 'classic'|| theme_get_setting('masonry_setting') == 'masonry_2col_left' && theme_get_setting('chosse_blog_list') == 'masonry' || theme_get_setting('grid_setting') == 'grid_2col_left' && theme_get_setting('chosse_blog_list') == 'grid'){
      $vars['blog_list_left'] = 'col-sm-push-4 col-md-8 col-sm-8 col-md-offset-0 col-sm-offset-0';
      $vars['blog_list_right'] = 'col-md-3 col-sm-pull-8 col-sm-4 col-md-offset-0 blog-sidebar';
    }elseif(theme_get_setting('classic_setting') == 'classic_sidebar_right' && theme_get_setting('chosse_blog_list') == 'classic'|| theme_get_setting('masonry_setting') == 'masonry_2col_right' && theme_get_setting('chosse_blog_list') == 'masonry' || theme_get_setting('grid_setting') == 'grid_2col_right' && theme_get_setting('chosse_blog_list') == 'grid'){
      $vars['blog_list_left'] = 'col-md-8';
      $vars['blog_list_right'] = 'col-md-3 col-md-offset-1 blog-sidebar';
    }

  $vars['blog_list'] = '';
  (theme_get_setting('chosse_blog_list') == 'classic' ) ? $vars['blog_list'] = 'classic' : ((theme_get_setting('chosse_blog_list') == 'masonry') ? $vars['blog_list'] = 'masonry' : $vars['blog_list'] = 'grid');

  // Theme-Settings BLog Taxonomy
  $vars['blog_taxonomy_left'] = '';
  $vars['blog_taxonomy_right'] = '';
  if (theme_get_setting('blog_taxonomy_option') == 'classic') {
    $vars['blog_taxonomy'] = 'classic';
    if(theme_get_setting('classic_setting') == 'classic_fullwidth'){
      $vars['blog_taxonomy_left'] = 'col-md-12';
      $vars['blog_taxonomy_right'] = 'display-none';
    }elseif(theme_get_setting('classic_setting') == 'classic_sidebar_right'){
      $vars['blog_taxonomy_left'] = 'col-md-8';
      $vars['blog_taxonomy_right'] = 'col-md-3 col-md-offset-1 blog-sidebar';
    }elseif(theme_get_setting('classic_setting') == 'classic_sidebar_left'){
      $vars['blog_taxonomy_left'] = 'col-sm-push-4 col-md-8 col-sm-8 col-md-offset-0 col-sm-offset-0';
      $vars['blog_taxonomy_right'] = 'col-md-3 col-sm-pull-8 col-sm-4 col-md-offset-0 blog-sidebar';
    }
  }
  elseif (theme_get_setting('blog_taxonomy_option') == 'masonry') {
    $vars['blog_taxonomy'] = 'masonry';
    if(theme_get_setting('masonry_setting') == 'masonry_2col_left'){
      $vars['blog_taxonomy_left'] = 'col-sm-push-4 col-md-8 col-sm-8 col-md-offset-0 col-sm-offset-0';
      $vars['blog_taxonomy_right'] = 'col-md-3 col-sm-pull-8 col-sm-4 col-md-offset-0 blog-sidebar';
    }elseif(theme_get_setting('masonry_setting') == 'masonry_2col_right'){
      $vars['blog_taxonomy_left'] = 'col-md-8';
      $vars['blog_taxonomy_right'] = 'col-md-3 col-md-offset-1 blog-sidebar';
    }elseif(theme_get_setting('masonry_setting') == 'masonry_3col' || theme_get_setting('masonry_setting') == 'masonry_4col'){
      $vars['blog_taxonomy_left'] = 'col-md-12';
      $vars['blog_taxonomy_right'] = 'display-none';
    }
  }
  elseif (theme_get_setting('blog_taxonomy_option') == 'grid') {
    $vars['blog_taxonomy'] = 'grid';
    if(theme_get_setting('grid_setting') == 'grid_2col_left'){
      $vars['blog_taxonomy_left'] = 'col-sm-push-4 col-md-8 col-sm-8 col-md-offset-0 col-sm-offset-0';
      $vars['blog_taxonomy_right'] = 'col-md-3 col-sm-pull-8 col-sm-4 col-md-offset-0 blog-sidebar';
    }elseif(theme_get_setting('grid_setting') == 'grid_2col_right'){
      $vars['blog_taxonomy_left'] = 'col-md-8';
      $vars['blog_taxonomy_right'] = 'col-md-3 col-md-offset-1 blog-sidebar';
    }elseif(theme_get_setting('grid_setting') == 'grid_3col' || theme_get_setting('grid_setting') == 'grid_4col'){
      $vars['blog_taxonomy_left'] = 'col-md-12';
      $vars['blog_taxonomy_right'] = 'display-none';
    }
  }
	
	// Footer Settings
  $vars['ft_top_class'] = theme_get_setting('footer_top_class') ? theme_get_setting('footer_top_class') : '';

  // Theme-setting Not-found
  $vars['title_notfound'] = theme_get_setting('not_found_title') ? theme_get_setting('not_found_title') : 'Sorry, Page not found !';
  $vars['content_notfound'] = theme_get_setting('not_found_body') ? theme_get_setting('not_found_body') : 'We\'re sorry, but the page </br> you were looking for doesn\'t exist.';

  // Theme-setting Contact Infomation
  $vars['title_page_contact_full'] = theme_get_setting('title_page_contact_full') ? theme_get_setting('title_page_contact_full') : 'CONTACT OUR TEAM';
  $vars['des_title_page_contact_full'] = theme_get_setting('des_title_page_contact_full') ? theme_get_setting('des_title_page_contact_full') : '';
  
  $vars['title_contact_info'] = theme_get_setting('title_des_contact_info') ? theme_get_setting('title_des_contact_info') : 'GET IN TOUCH';
  $vars['content_contact_info'] = theme_get_setting('des_contact_info') ? theme_get_setting('des_contact_info') : 'Quod cum ita sit, paucae domus studiorum seriis cultibus antea celebratae nunc ludibriis ignaviae torpentis exundant, vocali sonu, perflabili tinnitu fidium resultantes. denique pro philosopho cantor et in locum oratoris doctor artium ludicrarum accitur et bybliothecis sepulcrorum ritu in perpetuum clausis organa fabricantur hydraulica, et lyrae ad speciem carpentorum.';

  // Theme-setting Contact Type
  $vars['contact_type'] = '';
  switch (theme_get_setting('select_contact_type')) {
      case 'contact_full_map':
          $vars['contact_type'] = 'fullmap';
          break;
      case 'contact_3col':
          $vars['contact_type'] = '3col';
          break;
      case 'contact_map_bottom':
          $vars['contact_type'] = 'mapbottom';
          break;
      case 'contact_map_site':
          $vars['contact_type'] = 'mapsite';
          break;
  }

  // ICON CALLED
  $call_awesome[] = array(
      '#theme' => 'icon',
      '#bundle' => 'linea_basic_awesome',
      '#icon' => 'icon-user',
  );
  drupal_render($call_awesome);


  // PORTFOLIO BACKGROUND CUSTOM :
    $file_upload = theme_get_setting('portfolio_header_background', null);
    if ($file_upload != 0) {
      $file = file_load($file_upload);
      $vars['portfolio_background_url'] = file_create_url($file->uri);
    }else {
      $vars['portfolio_background_url'] = $base_url . '/' . path_to_theme() . '/images/smoke2.png';
    }

// CONDITION SECTION CLASS MD-MAKE
  if (theme_get_setting('portfolio_style') == TRUE) {
    $vars['portfolio_style'] = 'BOXED';
  }
  else {
    $vars['portfolio_style'] = 'WIDE';
  }
  $vars['make_section_content'] = '';
  $vars['make_section_sheet'] = 'bg-gray-light';
  //  CHECK CONDITION DISPLAY STYLE PORTFOLIO
  $vars['section_sheet_class'] = 'bg-gray-light';
  if ($node = menu_get_object()) {
    if ($node->type == 'portfolio') {
      $vars['node'] = $node;

      // FIELD DISPLAY STYLE
      $display = field_get_items('node', $vars['node'], 'field_display_style');
      $field_data_value = field_view_value('node', $vars['node'], 'field_display_style', $display[0]);
      if (isset($field_data_value)) {
        $vars['display_portfolio'] = render($field_data_value);
      }

      // GET MULTIMEDIA FIELD
      $vars['multi_media'] = field_view_field('node', $vars['node'], 'field_multimedia');

      // GET SUBTITLE FIELD
      $subtitle = field_get_items('node', $vars['node'], 'field_subtitle');
      $field_subtitle = field_view_value('node', $vars['node'], 'field_subtitle', $subtitle[0]);
      $vars['subtitle'] = render($field_subtitle);

      switch ($vars['display_portfolio']) {
        case 'Small slider':
          $vars['section_content_class'] = 'm-t-60 porfolio-small p-t-60 bg-gray-light';
          $vars['section_sheet_class'] = '';
          break;
        case 'Boxed slider':
          $vars['section_content_class'] = 'p-t-60';
          $vars['section_sheet_class'] = 'border-top';
          break;
        case 'Full width slider':
          $vars['section_content_class'] = 'p-t-0 ';
          $vars['section_sheet_class'] = 'bg-gray-light';
          break;
        case 'Fixed Text':
          $vars['section_content_class'] = 'section-portfolio p-t-60 portfolio-single bg-gray-light ';
          $vars['section_sheet_class'] = '';
          break;
        case 'Full Height':
          $vars['section_content_class'] = 'section-portfolio p-t-120 portfolio-single clearfix ';
          $vars['section_sheet_class'] = 'bg-gray-light';
          break;
        case 'Gallery':
          $vars['section_content_class'] = 'section-portfolio portfolio-gallery p-t-60 portfolio-single';
          $vars['section_sheet_class'] = 'border-top';
          break;
        default :
          $vars['section_sheet_class'] = 'bg-gray-light';
      }

//    SLIDER CAROUSEL
      $vars['portfolio_carou'] = '<div class="portfolio-thumbnail"><figure><div class="owl-carousel">'
          . render($vars['multi_media'])
          . '</div></figure></div>';
      // GET URL BACKGROUND FULL HEIGHT STYLE PORTFOLIO
      // FIRST IMAGE MEDIA
      $vars['first_image_path'] = "";
      if($vars['multi_media'][0]['file']['#theme'] == "image_formatter"){
        $first_uri = $vars['multi_media'][0]['file']['#item']['uri'];
        $vars['first_image_path'] = file_create_url($first_uri);
      }
    }
  }
  $path_theme = drupal_get_path('theme', 'md_make');
  $status = drupal_get_http_header("status");
  if($status == '404 Not Found' || $args[0] == 'page-404'){
    drupal_add_css('https://fonts.googleapis.com/css?family=Lato:100,300,400,500,700');
    drupal_add_css(path_to_theme() . '/css/ui.css');
    drupal_add_js("{$path_theme}/js/libs/header/backstretch/backstretch.min.js", array('type' => 'file', 'scope' => 'footer'));
  }

    //Display style;
  if(isset($vars['node']->field_display_style)){
        $display = field_get_items('node', $vars['node'], 'field_display_style');
        $field_data_value = field_view_value('node', $vars['node'], 'field_display_style', $display[0]);
        if (isset($field_data_value)) {
          $vars['display_portfolio'] = render($field_data_value);
        }
  }
  
  // PAGE TITLE STYLE
$vars['header_bg'] = $base_url.'/sites/default/files/fillesportant-canoe.jpg';
  //$vars['header_bg'] = $base_url.'/'.$path_theme.'/images/bg-8.jpg'; 

/* print "<pre>";
  print_r($vars['node']);
  print "</pre>";*/
  $vars['title_des'] = '';
  $style_css_default = '';

  if (isset($vars['node'])) {
    $node_type = $vars['node']->type;
    $type_data = theme_get_setting('type_data');
    
    if (!empty($type_data)){
      $type_data = drupal_json_decode($type_data);
      $type_data = array_chunk($type_data, 5);
      //print "<pre>";
      //  print_r($type_data);
      //print "</pre>";
      foreach ($type_data as $key => $type) {
         if ($node_type == $type[4]['value'] && $type[0]['value']!=NULL && $type[0]['value']!="") {
            $vars['header_bg'] = $type[0]['value'];
         }
         if ($node_type == $type[4]['value'] && !empty($type[3]['value'])) {
                    $style_css_default .= ".section-header-overlay{";
                    $style_css_default .= 'background: ' . $type[3]['value'] . ';';
                    $style_css_default .= "}\n";
         } 
        //print "<h2>".$type[1]['value']."</h2>";
        if ($type[1]['value'] != NULL || $type[1]['value'] != '') {
            //print "<h2>".$node_type."</h2>";
          if ($node_type == $type[4]['value']) {
            if ($type[1]['value'] != '<inherit>') {
              $vars['title'] = t($type[1]['value']);
            }
            print "<h1>".$type[0]['value']."</h1>";
            $vars['title_des'] = t($type[2]['value']);
            $vars['header_bg'] = $type[0]['value'];
            if ($type[1]['value'] == '<none>') {
              $vars['title'] = FALSE;
            }

            if (!empty($type[3]['value'])) {
                    $style_css_default .= ".section-header-overlay{";
                    $style_css_default .= 'background: ' . $type[3]['value'] . ';';
                    $style_css_default .= "}\n";
            }
          }
        }
      }
    }
  }
  
  /*---Custom bg header for nature template*/
  if(isset($vars['node']->adt21_engine_image[und][0][uri])){
      $vars['title_bg'] =$vars['node']->adt21_engine_image[und][0][title];
      $vars['header_bg'] =file_create_url($vars['node']->adt21_engine_image[und][0][uri]);
      if(count($vars['node']->adt21_engine_image[und])>1){
          
            $header_slider.='<div class="owl-carousel carousel-fiche">';
                foreach ($vars['node']->adt21_engine_image[und] as $key => $value) {
                    //print_r((string)$imgObj->fic_o);
                    
                    //print "<!--";
                    //print_r($value);
                   //print "-->";
                    //$imgObj->fic_o = "https://www.cotedor-tourisme.com/fics_monespacetourisme/".(string)$imgObj->fic_o;
                    $titre="";
                    $titre = $value['title'];
                  $header_slider.='<div><a class="mgf-md-popup clearfix open-lightbox " href="'.file_create_url($value['uri']).'?width=1920" title="'.$titre.'" target="_blank"><img src="'.file_create_url($value['uri']).'?width=1920" title="'.$titre.'" alt="'.$titre.'" class="imgFicheADT21"><div class="carousel-fiche-caption">'.$titre.'</div></a></div>';  
                }
            $header_slider.='</div>';
            if(isset($vars['display_portfolio'])){
                if($vars['display_portfolio']=='Gallery') $vars['header_slider']=$header_slider;
            }
            
          //print($vars['header_slider']);
          /*$ar_headers=array();
          foreach ($vars['node']->adt21_engine_image[und] as $key => $value) {
              $ar_headers[]=file_create_url($value['uri']);
          }          
          $vars['arr_headers_bg']=$ar_headers;*/
      }
  }
  if(isset($vars['node']->field_image_cat_nature[und][0][uri])){
         $vars['header_bg'] =file_create_url($vars['node']->field_image_cat_nature[und][0][uri]);
  }
  if(isset($vars['node']->field_imagefichenature[und][0][uri])){
         $vars['header_bg'] =file_create_url($vars['node']->field_imagefichenature[und][0][uri]);
  }
  if(isset($vars['node']->field_image_categorie_abcdair[und][0][uri])){
         $vars['header_bg'] =file_create_url($vars['node']->field_image_categorie_abcdair[und][0][uri]);
  }
  if(isset($vars['node']->field_images_fiche_abcdair[und][0][uri])){
         $vars['header_bg'] =file_create_url($vars['node']->field_images_fiche_abcdair[und][0][uri]);
  }

  $vars['fullwidth_view']=false;
  if(function_exists('views_get_page_view') && views_get_page_view()){
      //print_r(views_get_page_view()->name);
      if(views_get_page_view()->name == 'listes_de_circuits') $vars['fullwidth_view']=true;
      
      if(function_exists('url_conv')){
          $file_bg_view_path = "sites/default/files/background/".url_conv(drupal_get_path_alias()).".jpg";
      //print "Typeview + ". url_conv(drupal_get_path_alias()) . " - " . variable_get('file_public_path', conf_path() . '/files');
            if(file_exists($file_bg_view_path)){
               $vars['header_bg'] = "/sites/default/files/background/".url_conv(drupal_get_path_alias()).".jpg";

            }
      }
  }
   /* print "<pre>";
    
    print_r($vars['node']->field_adt_node_xml_data[und][0]['value']);
    
    print "</pre>";*/
  if(isset($vars['node']->field_adt_node_xml_data[und][0]['value'])){
    $data = $vars['node']->field_adt_node_xml_data[und][0]['value'];
    //print_r($data);
    $xml = simplexml_load_string($data);
    $obj = $xml->obj;
    /*print "<pre>";
    
    print_r($obj);
    
    print "</pre>";*/
    //dpm(print_r($obj, true));
    $img = $obj->xpath('obj_common/photo/ass_obj_photo[doctype="photo" and vignette=1]/fic_o');
    //print_r($img);
    if (!$img || empty($img)) $img = $obj->xpath('obj_common/photo/ass_obj_photo[doctype="photo" and type_descriptif="TECHN"]/fic_o');
   // type_descriptif
    if (!$img || empty($img)) $img = $obj->xpath('obj_common/photo/ass_obj_photo[doctype="photo"]/fic_o');
   // print "nombre de photos : ".count($img);
   
        /*--Création du diaporama d'images*/
  /*  $diapo = '<div class="owl-carousel carousel-fiche">
<div><a class="mgf-md-popup clearfix open-lightbox " href="http://cdt21.media.tourinsoft.eu/upload/3106-SU-0002-pdj.jpg?width=1920" title="salle petit déjeuner - Hôtel des Ducs © elevy" target="_blank"><img src="http://cdt21.media.tourinsoft.eu/upload/3106-SU-0002-pdj.jpg?width=1920" title="salle petit déjeuner - Hôtel des Ducs © elevy" alt="salle petit déjeuner - Hôtel des Ducs © elevy" class="imgFicheADT21"><div class="carousel-fiche-caption">salle petit déjeuner - Hôtel des Ducs © elevy</div></a></div>
<div><a class="mgf-md-popup clearfix open-lightbox " href="http://cdt21.media.tourinsoft.eu/upload/12626-DSC-0742.JPG?width=1920" title="chambre supérieure - HÔTEL DES DUCS©E. LEVY" target="_blank"><img src="http://cdt21.media.tourinsoft.eu/upload/12626-DSC-0742.JPG?width=1920" title="chambre supérieure - HÔTEL DES DUCS©E. LEVY" alt="chambre supérieure - HÔTEL DES DUCS©E. LEVY" class="imgFicheADT21"><div class="carousel-fiche-caption">chambre supérieure - HÔTEL DES DUCS©E. LEVY</div></a></div>
<div><a class="mgf-md-popup clearfix open-lightbox " href="http://cdt21.media.tourinsoft.eu/upload/12625-410-10.JPG?width=1920" title="salle de bain - HÔTEL DES DUCS©E. LEVY" target="_blank"><img src="http://cdt21.media.tourinsoft.eu/upload/12625-410-10.JPG?width=1920" title="salle de bain - HÔTEL DES DUCS©E. LEVY" alt="salle de bain - HÔTEL DES DUCS©E. LEVY" class="imgFicheADT21"><div class="carousel-fiche-caption">salle de bain - HÔTEL DES DUCS©E. LEVY</div></a></div>
<div><a class="mgf-md-popup clearfix open-lightbox " href="http://cdt21.media.tourinsoft.eu/upload/13657-ch-406-.jpg?width=1920" title="chambre - HÔTEL DES DUCS©E. LEVY" target="_blank"><img src="http://cdt21.media.tourinsoft.eu/upload/13657-ch-406-.jpg?width=1920" title="chambre - HÔTEL DES DUCS©E. LEVY" alt="chambre - HÔTEL DES DUCS©E. LEVY" class="imgFicheADT21"><div class="carousel-fiche-caption">chambre - HÔTEL DES DUCS©E. LEVY</div></a></div>
<div><a class="mgf-md-popup clearfix open-lightbox " href="http://cdt21.media.tourinsoft.eu/upload/14182-accueil-Copier-.jpg?width=1920" title="Accueil - HÔTEL DES DUCS©E. LEVY" target="_blank"><img src="http://cdt21.media.tourinsoft.eu/upload/14182-accueil-Copier-.jpg?width=1920" title="Accueil - HÔTEL DES DUCS©E. LEVY" alt="Accueil - HÔTEL DES DUCS©E. LEVY" class="imgFicheADT21"><div class="carousel-fiche-caption">Accueil - HÔTEL DES DUCS©E. LEVY</div></a></div>
<div><a class="mgf-md-popup clearfix open-lightbox " href="http://cdt21.media.tourinsoft.eu/upload/12954-data-h7m0agPZxxPiDpJZ08QSBRIqIAHY9BgxXXxm2pKXi-X4yIO-angZbK4yXqAKlu13UkoKIpvguUyu3B9LQNc5X7lwcsdANL1-KzfDWCc.png?width=1920" title="PLAN - HÔTEL DES DUCS©E. LEVY" target="_blank"><img src="http://cdt21.media.tourinsoft.eu/upload/12954-data-h7m0agPZxxPiDpJZ08QSBRIqIAHY9BgxXXxm2pKXi-X4yIO-angZbK4yXqAKlu13UkoKIpvguUyu3B9LQNc5X7lwcsdANL1-KzfDWCc.png?width=1920" title="PLAN - HÔTEL DES DUCS©E. LEVY" alt="PLAN - HÔTEL DES DUCS©E. LEVY" class="imgFicheADT21"><div class="carousel-fiche-caption">PLAN - HÔTEL DES DUCS©E. LEVY</div></a></div>
<div><a class="mgf-md-popup clearfix open-lightbox " href="http://cdt21.media.tourinsoft.eu/upload/14177-place-liberation-.JPG?width=1920" title="Palais des Ducs - HÔTEL DES DUCS©E. LEVY" target="_blank"><img src="http://cdt21.media.tourinsoft.eu/upload/14177-place-liberation-.JPG?width=1920" title="Palais des Ducs - HÔTEL DES DUCS©E. LEVY" alt="Palais des Ducs - HÔTEL DES DUCS©E. LEVY" class="imgFicheADT21"><div class="carousel-fiche-caption">Palais des Ducs - HÔTEL DES DUCS©E. LEVY</div></a></div>
<div><a class="mgf-md-popup clearfix open-lightbox " href="http://cdt21.media.tourinsoft.eu/upload/14183-facade-hotel-800x260-.jpg?width=1920" title="Façade - HÔTEL DES DUCS©E. LEVY" target="_blank"><img src="http://cdt21.media.tourinsoft.eu/upload/14183-facade-hotel-800x260-.jpg?width=1920" title="Façade - HÔTEL DES DUCS©E. LEVY" alt="Façade - HÔTEL DES DUCS©E. LEVY" class="imgFicheADT21"><div class="carousel-fiche-caption">Façade - HÔTEL DES DUCS©E. LEVY</div></a></div>
<div><a class="mgf-md-popup clearfix open-lightbox " href="http://cdt21.media.tourinsoft.eu/upload/14184-P1020234-600x800-.jpg?width=1920" title="Accueil - HÔTEL DES DUCS©E. LEVY" target="_blank"><img src="http://cdt21.media.tourinsoft.eu/upload/14184-P1020234-600x800-.jpg?width=1920" title="Accueil - HÔTEL DES DUCS©E. LEVY" alt="Accueil - HÔTEL DES DUCS©E. LEVY" class="imgFicheADT21"><div class="carousel-fiche-caption">Accueil - HÔTEL DES DUCS©E. LEVY</div></a></div>
<div><a class="mgf-md-popup clearfix open-lightbox " href="http://cdt21.media.tourinsoft.eu/upload/14185-salon-Copier-.jpg?width=1920" title="Salon - HÔTEL DES DUCS©E. LEVY" target="_blank"><img src="http://cdt21.media.tourinsoft.eu/upload/14185-salon-Copier-.jpg?width=1920" title="Salon - HÔTEL DES DUCS©E. LEVY" alt="Salon - HÔTEL DES DUCS©E. LEVY" class="imgFicheADT21"><div class="carousel-fiche-caption">Salon - HÔTEL DES DUCS©E. LEVY</div></a></div>
<div><a class="mgf-md-popup clearfix open-lightbox " href="http://cdt21.media.tourinsoft.eu/upload/14186-pain-Copier-.jpg?width=1920" title="Petit déjeuner - HÔTEL DES DUCS©E. LEVY" target="_blank"><img src="http://cdt21.media.tourinsoft.eu/upload/14186-pain-Copier-.jpg?width=1920" title="Petit déjeuner - HÔTEL DES DUCS©E. LEVY" alt="Petit déjeuner - HÔTEL DES DUCS©E. LEVY" class="imgFicheADT21"><div class="carousel-fiche-caption">Petit déjeuner - HÔTEL DES DUCS©E. LEVY</div></a></div>
<div><a class="mgf-md-popup clearfix open-lightbox " href="http://cdt21.media.tourinsoft.eu/upload/14187-pdj-Copier-.jpg?width=1920" title="Petit déjeuner - HÔTEL DES DUCS©E LEVY" target="_blank"><img src="http://cdt21.media.tourinsoft.eu/upload/14187-pdj-Copier-.jpg?width=1920" title="Petit déjeuner - HÔTEL DES DUCS©E LEVY" alt="Petit déjeuner - HÔTEL DES DUCS©E LEVY" class="imgFicheADT21"><div class="carousel-fiche-caption">Petit déjeuner - HÔTEL DES DUCS©E LEVY</div></a></div>
<div><a class="mgf-md-popup clearfix open-lightbox " href="http://cdt21.media.tourinsoft.eu/upload/14188-ch-402-Copier-.jpg?width=1920" title="Chambre supérieure - HÔTEL DES DUCS©E LEVY" target="_blank"><img src="http://cdt21.media.tourinsoft.eu/upload/14188-ch-402-Copier-.jpg?width=1920" title="Chambre supérieure - HÔTEL DES DUCS©E LEVY" alt="Chambre supérieure - HÔTEL DES DUCS©E LEVY" class="imgFicheADT21"><div class="carousel-fiche-caption">Chambre supérieure - HÔTEL DES DUCS©E LEVY</div></a></div>
<div><a class="mgf-md-popup clearfix open-lightbox " href="http://cdt21.media.tourinsoft.eu/upload/14189-ch-403-Copier-.jpg?width=1920" title="Chambre standard - HÔTEL DES DUCS©E. LEVY" target="_blank"><img src="http://cdt21.media.tourinsoft.eu/upload/14189-ch-403-Copier-.jpg?width=1920" title="Chambre standard - HÔTEL DES DUCS©E. LEVY" alt="Chambre standard - HÔTEL DES DUCS©E. LEVY" class="imgFicheADT21"><div class="carousel-fiche-caption">Chambre standard - HÔTEL DES DUCS©E. LEVY</div></a></div>
<div><a class="mgf-md-popup clearfix open-lightbox " href="http://cdt21.media.tourinsoft.eu/upload/14191-ch-408-2-Copier-.jpg?width=1920" title="Chambre supérieure - HÔTEL DES DUCS©E LEVY" target="_blank"><img src="http://cdt21.media.tourinsoft.eu/upload/14191-ch-408-2-Copier-.jpg?width=1920" title="Chambre supérieure - HÔTEL DES DUCS©E LEVY" alt="Chambre supérieure - HÔTEL DES DUCS©E LEVY" class="imgFicheADT21"><div class="carousel-fiche-caption">Chambre supérieure - HÔTEL DES DUCS©E LEVY</div></a></div>
<div><a class="mgf-md-popup clearfix open-lightbox " href="http://cdt21.media.tourinsoft.eu/upload/14192-ch-408-Copier-.jpg?width=1920" title="Chambre supérieure - HÔTEL DES DUCS©E LEVY" target="_blank"><img src="http://cdt21.media.tourinsoft.eu/upload/14192-ch-408-Copier-.jpg?width=1920" title="Chambre supérieure - HÔTEL DES DUCS©E LEVY" alt="Chambre supérieure - HÔTEL DES DUCS©E LEVY" class="imgFicheADT21"><div class="carousel-fiche-caption">Chambre supérieure - HÔTEL DES DUCS©E LEVY</div></a></div>
<div><a class="mgf-md-popup clearfix open-lightbox " href="http://cdt21.media.tourinsoft.eu/upload/14194-palais-ducal-800x600-.jpg?width=1920" title="Palais Ducal - HÔTEL DES DUCS©E LEVY" target="_blank"><img src="http://cdt21.media.tourinsoft.eu/upload/14194-palais-ducal-800x600-.jpg?width=1920" title="Palais Ducal - HÔTEL DES DUCS©E LEVY" alt="Palais Ducal - HÔTEL DES DUCS©E LEVY" class="imgFicheADT21"><div class="carousel-fiche-caption">Palais Ducal - HÔTEL DES DUCS©E LEVY</div></a></div>
<div><a class="mgf-md-popup clearfix open-lightbox " href="http://cdt21.media.tourinsoft.eu/upload/14195-rue-verrerie-800x600-.jpg?width=1920" title="Rue Verrerie - HÔTEL DES DUCS©E. LEVY" target="_blank"><img src="http://cdt21.media.tourinsoft.eu/upload/14195-rue-verrerie-800x600-.jpg?width=1920" title="Rue Verrerie - HÔTEL DES DUCS©E. LEVY" alt="Rue Verrerie - HÔTEL DES DUCS©E. LEVY" class="imgFicheADT21"><div class="carousel-fiche-caption">Rue Verrerie - HÔTEL DES DUCS©E. LEVY</div></a></div>
<div><a class="mgf-md-popup clearfix open-lightbox " href="http://cdt21.media.tourinsoft.eu/upload/14196-vignes-Copier-.jpg?width=1920" title="Vignes - HÔTEL DES DUCS©E. LEVY" target="_blank"><img src="http://cdt21.media.tourinsoft.eu/upload/14196-vignes-Copier-.jpg?width=1920" title="Vignes - HÔTEL DES DUCS©E. LEVY" alt="Vignes - HÔTEL DES DUCS©E. LEVY" class="imgFicheADT21"><div class="carousel-fiche-caption">Vignes - HÔTEL DES DUCS©E. LEVY</div></a></div>
<div><a class="mgf-md-popup clearfix open-lightbox " href="http://cdt21.media.tourinsoft.eu/upload/14200-1106-Hotel-des-ducs-reportages-porte.jpg?width=1920" title="Façade - HÔTEL DES DUCS©E. LEVY" target="_blank"><img src="http://cdt21.media.tourinsoft.eu/upload/14200-1106-Hotel-des-ducs-reportages-porte.jpg?width=1920" title="Façade - HÔTEL DES DUCS©E. LEVY" alt="Façade - HÔTEL DES DUCS©E. LEVY" class="imgFicheADT21"><div class="carousel-fiche-caption">Façade - HÔTEL DES DUCS©E. LEVY</div></a></div>
<div><a class="mgf-md-popup clearfix open-lightbox " href="http://cdt21.media.tourinsoft.eu/upload/14201-P1010859.JPG?width=1920" title="Façade - HÔTEL DES DUCS©E. LEVY" target="_blank"><img src="http://cdt21.media.tourinsoft.eu/upload/14201-P1010859.JPG?width=1920" title="Façade - HÔTEL DES DUCS©E. LEVY" alt="Façade - HÔTEL DES DUCS©E. LEVY" class="imgFicheADT21"><div class="carousel-fiche-caption">Façade - HÔTEL DES DUCS©E. LEVY</div></a></div>
</div>
';*/  
    
    
if (!$img_with_cop || empty($img_with_cop)) $img_with_cop = $obj->xpath('obj_common/photo/ass_obj_photo[doctype="photo" and type_descriptif="TECHN"]');
//print "<pre>";
//print_r($img_with_cop);
//print "</pre>";
if ($img && !empty($img))
    {
        $imgbg = (string) $img[0][0];
        //$output .= '<div class="liste_activites_item_img">';
       $imgbg =  variable_get('adt_pictures_path').$imgbg;
        //$output .= '</div>';
       $vars['header_bg']=$imgbg;
    }
    if(count($img_with_cop)>0){
        
        $header_slider.='<div class="owl-carousel carousel-fiche">';
        foreach ($img_with_cop as $imgObj) {
            //print_r((string)$imgObj->fic_o);
            $titre = (string)$imgObj->titre ." -".(string)$imgObj->copyright;
            $imgObj->fic_o = "https://www.cotedor-tourisme.com/fics_monespacetourisme/".(string)$imgObj->fic_o;
          $header_slider.='<div><a class="mgf-md-popup clearfix open-lightbox " href="'.(string)$imgObj->fic_o.'?width=1920" title="'.$titre.'" target="_blank"><img src="'.$imgObj->fic_o.'?width=1920" title="'.$titre.'" alt="'.$titre.'" class="imgFicheADT21"><div class="carousel-fiche-caption">'.$titre.'</div></a></div>';  
        }
        $header_slider.='</div>';
        $vars['header_slider']=$header_slider;
    }
    //print_r($img);
    //print_r($header_slider);

  }
  
  
  
  
  
  
  
	
	drupal_add_css($style_css_default, array('type' => 'inline'));
	

}

/**
 * @param $vars
 * Implement hook_process_page().
 */
function md_make_process_page(&$vars) {
  global $base_url;
  $themepath = drupal_get_path("theme", "md_make");



  // Background Page 404 setting
  $vars['background_title'] = '';
  if (module_exists('media')) {
    $file_upload = theme_get_setting('background_title_image');
      if ($file_upload != 0) {
        $file = file_load($file_upload);
        $vars['background_title'] = file_create_url($file->uri);
      }else {
        $vars['background_title'] = $base_url . '/' . path_to_theme() . '/images/smoke2.png';
      }
    
  }

  // Logo Page 404 setting
  if (theme_get_setting('default_logo_page404') == 0) {
    if (module_exists('media')) {
      $file_upload = theme_get_setting('logo_page404_image');
      if ($file_upload != 0) {
        $file = file_load($file_upload);
        $vars['logo_page404'] = file_create_url($file->uri);
      }
      else {
        $vars['logo_page404'] = $base_url . '/' . $themepath . '/logo.png';
      }
    }
  }
  else {
        $vars['logo_page404'] = $base_url . '/' . $themepath . '/logo.png';
      }

  // Preprocess Page 404
  $vars['background_page404'] = '';
  if (module_exists('media')) {
    $file_upload = theme_get_setting('background_page404_image');
      if ($file_upload != 0) {
        $file = file_load($file_upload);
        $vars['background_page404'] = file_create_url($file->uri);
      }else {
        $vars['background_page404'] = $base_url . '/' . path_to_theme() . '/images/sea.jpg';
      }
  }

  // PAGE TITLE STYLE
  $style_css = '';

  $current_path = current_path();
  $title_data = theme_get_setting('title_data');

  if (!empty($title_data)){
    $title_data = drupal_json_decode($title_data);
    $title_data = array_chunk($title_data, 7);
    foreach ($title_data as $key_title => $title_detail) {
      if ($title_detail[1]['value'] != '' && $title_detail[1]['value'] == $current_path) {
        $vars['title'] = t($title_detail[2]['value']);
        $vars['header_bg'] = $title_detail[0]['value'];
        $vars['title_des'] = t($title_detail[3]['value']);
        if ($title_detail[2]['value'] == '<none>') {
          $vars['title'] = FALSE;
        }

				if (!empty($title_detail[4]['value'])) {
					$style_css .= ".bg_setting p, .bg_setting a, .bg_setting .breadcrumbs > i{";
					$style_css .= 'color: ' . $title_detail[4]['value'] . ';';
					$style_css .= "}\n";
				}
				if (!empty($title_detail[5]['value'])) {
					$style_css .= ".bg_setting h1, .bg_setting .breadcrumbs a:hover, .breadcrumbs span{";
					$style_css .= 'color: ' . $title_detail[5]['value'] . ';';
					$style_css .= "}\n";
				}
				if (!empty($title_detail[6]['value'])) {
					$style_css .= ".section-header-overlay{";
					$style_css .= 'background: ' . $title_detail[6]['value'] . ';';
					$style_css .= "}\n";
				}
      }
    }
  }
	drupal_add_css($style_css, array('type' => 'inline'));

}

function md_make_preprocess(&$vars) {

  // VARS FOR VIEWS PORTFOLIO
  $vars['portfolio_footer'] = '0';
  if (theme_get_setting('portfolio_footer') == 1) {
    $vars['portfolio_footer'] = '1';
  }
  else {
    $vars['portfolio_footer'] = '0';
  };
}



function md_make_preprocess_maintenance_page(&$vars) {
  global $base_url;

  drupal_add_css('https://fonts.googleapis.com/css?family=Lato:100,300,400,500,700', 'external');

  drupal_add_js(path_to_theme() . '/js/libs/bootstrap.min.js');
  drupal_add_js(path_to_theme() . '/js/libs/jquery.countdown.min.js');
  drupal_add_js(path_to_theme() . '/js/coming_soon.js');
  drupal_add_js('https://maps.googleapis.com/maps/api/js?v=3.exp');
  drupal_add_js('https://google-maps-utility-library-v3.googlecode.com/svn-history/r391/trunk/markerwithlabel/src/markerwithlabel.js', 'external');

  drupal_add_css('sites/default/files/icon/fontello/linea_basic_awesome/css/linea-basic-awesome.css');
  drupal_add_css(path_to_theme() . '/css/maintenance_mode/style.css');
  drupal_add_css(path_to_theme() . '/css/maintenance_mode/ui.css');
  drupal_add_css(path_to_theme() . '/css/maintenance_mode/maintenance-mode.css');


  // Logo  
  if (theme_get_setting('maintenance_logo')){
    $fid_logo_maintenance = theme_get_setting('maintenance_logo',null);
    $file = file_load($fid_logo_maintenance);
    if ($file) {
      $vars['logo'] = file_create_url($file->uri);
    }
  }


  //loading
  $vars['preload'] = '';
  if (theme_get_setting('preload') == TRUE) {
    $vars['preload'] = '<div class="loader-overlay">
                <div class="spinner">
                        <div class="bounce1"></div>
                        <div class="bounce2"></div>
                        <div class="bounce3"></div>
                </div>
        </div>';
  }


  // Comming
  $vars['title'] = 'Under Construction';
  $vars['construction_description'] = 'We will be back in:';
  $vars['construction_time'] = "2020/02/20 20:02:20";
  if (theme_get_setting('maintenance_title')) {
    $vars['title'] = theme_get_setting('maintenance_title');
  }
  if (theme_get_setting('maintenance_time')) {
    $vars['construction_time'] = theme_get_setting('maintenance_time');
  }

  // Content Tab
  $tabcontent_data = theme_get_setting('tabcontent_data');

  $menu_content = '';
  $tab_content = '';
	if (!empty($tabcontent_data)){
		$tabcontent_data = drupal_json_decode($tabcontent_data);
		$tabcontent_data = array_chunk($tabcontent_data, 3);
	
		$menu_content = '<nav class="main-nav"><ul>';
		foreach ($tabcontent_data as $key_content => $content_detail) {
			if ($content_detail[0]['value'] != '') {
				$list_active = ($key_content == 0) ? "active" : "";
				$menu_content .= '<li><a href="#tab_cotent_' . $key_content . '" class="' . $list_active . '">' . t($content_detail[0]['value']) . '</a></li>';

				$section_show = ($key_content == 0) ? "show" : "hide";
				$tab_content .='<section class="content ' . $section_show . '" id="tab_cotent_' . $key_content . '">
											<h1>' . t($content_detail[0]['value']) . '</h1>
											<h5>' . t($content_detail[1]['value']) . '</h5>
											<div class="maintenance_description">' . t($content_detail[2]['value']) . '</div>
							</section>';
			}
		}
		$menu_content .= '</ul></nav>';
	}
  $vars['list_menutab'] = $menu_content;
  $vars['content_tab'] = $tab_content;
}
