<?php

/**
 * Implements theme_pager().
 */
function md_make_pager_first($vars) {
  $text = $vars['text'];
  $element = $vars['element'];
  $parameters = $vars['parameters'];
  global $pager_page_array;
  $output = '';

  if ($pager_page_array[$element] > 0) {
    $output = theme('pager_link', array('text' => t('1'), 'page_new' => pager_load_array(0, $element, $pager_page_array), 'element' => $element, 'parameters' => $parameters));
  }

  return $output;
}

function md_make_pager_previous($vars) {
  $text = $vars['text'];
  $element = $vars['element'];
  $interval = $vars['interval'];
  $parameters = $vars['parameters'];
  global $pager_page_array;
  $output = '';

  // If we are anywhere but the first page
  if ($pager_page_array[$element] > 0) {
    $page_new = pager_load_array($pager_page_array[$element] - $interval, $element, $pager_page_array);
    $output = theme('pager_link', array('text' => $text, 'page_new' => $page_new, 'element' => $element, 'parameters' => $parameters));
  }

  return $output;
}

function md_make_pager_next($vars) {
  $text = $vars['text'];
  $element = $vars['element'];
  $interval = $vars['interval'];
  $parameters = $vars['parameters'];
  global $pager_page_array, $pager_total;
  $output = '';

  // If we are anywhere but the last page
  if ($pager_page_array[$element] < ($pager_total[$element] - 1)) {
    $page_new = pager_load_array($pager_page_array[$element] + $interval, $element, $pager_page_array);
    $output = theme('pager_link', array('text' => $text, 'page_new' => $page_new, 'element' => $element, 'parameters' => $parameters));
  }

  return $output;
}

function md_make_pager_last($vars) {
  $text = $vars['text'];
  $element = $vars['element'];
  $parameters = $vars['parameters'];
  global $pager_page_array, $pager_total;
  $output = '';

  if ($pager_page_array[$element] < ($pager_total[$element] - 1)) {
    $output = theme('pager_link', array('text' => $pager_total[$element], 'page_new' => pager_load_array($pager_total[$element] - 1, $element, $pager_page_array), 'element' => $element, 'parameters' => $parameters));
  }

  return $output;
}

function md_make_pager($vars) {
  $tags = $vars['tags'];
  $element = $vars['element'];
  $parameters = $vars['parameters'];
  $quantity = $vars['quantity'];
  global $pager_page_array, $pager_total;

  // Calculate various markers within this pager piece:
  // Middle is used to "center" pages around the current page.
  $pager_middle = ceil($quantity / 2);
  // current is the page we are currently paged to
  $pager_current = $pager_page_array[$element] + 1;
  // first is the first page listed by this pager piece (re quantity)
  $pager_first = $pager_current - $pager_middle + 1;
  // last is the last page listed by this pager piece (re quantity)
  $pager_last = $pager_current + $quantity - $pager_middle;
  // max is the maximum page number
  $pager_max = $pager_total[$element];
  // End of marker calculations.
  // Prepare for generation loop.
  $i = $pager_first;
  if ($pager_last > $pager_max) {
    // Adjust "center" if at end of query.
    $i = $i + ($pager_max - $pager_last);
    $pager_last = $pager_max;
  }
  if ($i <= 0) {
    // Adjust "center" if at start of query.
    $pager_last = $pager_last + (1 - $i);
    $i = 1;
  }
  // End of generation loop preparation.

  $li_first = theme('pager_first', array('text' => (isset($tags[0]) ? $tags[0] : t('�')), 'element' => $element, 'parameters' => $parameters));
  $li_previous = theme('pager_previous', array('text' => (isset($tags[1]) ? $tags[1] : t('�')), 'element' => $element, 'interval' => 1, 'parameters' => $parameters));
  $li_next = theme('pager_next', array('text' => (isset($tags[3]) ? $tags[3] : t('�')), 'element' => $element, 'interval' => 1, 'parameters' => $parameters));
  $li_last = theme('pager_last', array('text' => (isset($tags[4]) ? $tags[4] : t('�')), 'element' => $element, 'parameters' => $parameters));


  if ($pager_total[$element] > 1) {
    if ($li_previous) {
      $items[] = array(
        'class' => array('prev'),
        'data' => $li_previous,
      );
    }

    if ($li_first && $pager_first > 1 && $quantity < $pager_max) {
      $items[] = array(
        'class' => array('first'),
        'data' => $li_first,
      );
    }

    // When there is more than one page, create the pager list.
    if ($i != $pager_max) {
      if ($i > 1) {
        $items[] = array(
          'class' => array('pager-ellipsis disabled'),
          'data' => '<a>...</a>',
        );
      }
      // Now generate the actual pager piece.
      for (; $i <= $pager_last && $i <= $pager_max; $i++) {
        if ($i < $pager_current) {
          $items[] = array(
            'class' => array('pager-item'),
            'data' => theme('pager_previous', array('text' => $i, 'element' => $element, 'interval' => ($pager_current - $i), 'parameters' => $parameters)),
          );
        }
        if ($i == $pager_current) {
          $items[] = array(
            'class' => array('active'),
            'data' => '<a href="#">' . $i . '</a>',
          );
        }
        if ($i > $pager_current) {
          $items[] = array(
            'class' => array('pager-item'),
            'data' => theme('pager_next', array('text' => $i, 'element' => $element, 'interval' => ($i - $pager_current), 'parameters' => $parameters)),
          );
        }
      }
      if ($i < $pager_max) {
        $items[] = array(
          'class' => array('pager-ellipsis disabled'),
          'data' => '<a>...</a>',
        );
      }
    }
    // End generation.
    if ($li_last && $pager_last < $pager_max) {
      $items[] = array(
        'class' => array('last'),
        'data' => $li_last,
      );
    }
    if ($li_next) {
      $items[] = array(
        'class' => array('next'),
        'data' => $li_next,
      );
    }
    $output = '<div class="pagination"><ul>';
    foreach ($items as $item) {
      $output .= '<li class="' . $item['class'][0] . '">' . $item['data'] . "</li>\n";
    }
    $output .= '</ul></div>';

    return $output;
  }
}

/**
 * Implements theme_textarea().
 */
function md_make_textarea($vars) {
  $element = $vars['element'];
  //$element['#attributes']['placeholder'] = $element['#title'];
  element_set_attributes($element, array('id', 'name', 'cols', 'rows'));
  _form_set_class($element, array('form-control'));

  // Add resizable behavior.
  if (!empty($element['#resizable'])) {
    drupal_add_library('system', 'drupal.textarea');
    $wrapper_attributes['class'][] = 'resizable';
    $output = '<div' . drupal_attributes($wrapper_attributes) . '>';
    $output .= '<textarea' . drupal_attributes($element['#attributes']) . '>' . check_plain($element['#value']) . '</textarea>';
    $output .= '</div>';
    return $output;
  }
  else {
    $output = '<textarea' . drupal_attributes($element['#attributes']) . '>' . check_plain($element['#value']) . '</textarea>';
    return $output;
  }
}

/**
 * Implements theme_textfield().
 */
function md_make_textfield($vars) {
  $element = $vars['element'];
  $element['#attributes']['type'] = 'text';
  /* if (isset($element['#title'])){
    $element['#attributes']['placeholder'] = $element['#title'];
    } */
  element_set_attributes($element, array('id', 'name', 'value', 'size', 'maxlength'));
  _form_set_class($element, array('form-control'));

  $extra = '';
  if ($element['#autocomplete_path'] && drupal_valid_path($element['#autocomplete_path'])) {
    drupal_add_library('system', 'drupal.autocomplete');
    $element['#attributes']['class'][] = 'form-autocomplete';

    $attributes = array();
    $attributes['type'] = 'hidden';
    $attributes['id'] = $element['#attributes']['id'] . '-autocomplete';
    $attributes['value'] = url($element['#autocomplete_path'], array('absolute' => TRUE));
    $attributes['disabled'] = 'disabled';
    $attributes['class'][] = 'autocomplete';
    $extra = '<input' . drupal_attributes($attributes) . ' />';
  }
  $output = '<input' . drupal_attributes($element['#attributes']) . ' />';
  return $output . $extra;
}

function md_make_menu_local_tasks(&$vars) {
  $output = '';

  if (!empty($vars ['primary'])) {
    $vars ['primary']['#prefix'] = '<h2 class="element-invisible">' . t('Primary tabs') . '</h2>';
    $vars ['primary']['#prefix'] .= '<ul class="nav nav-tabs nav-tabs-primary tabs-light">';
    $vars ['primary']['#suffix'] = '</ul>';
    $output .= drupal_render($vars ['primary']);
  }
  if (!empty($vars ['secondary'])) {
    $vars ['secondary']['#prefix'] = '<h2 class="element-invisible">' . t('Secondary tabs') . '</h2>';
    $vars ['secondary']['#prefix'] .= '<ul class="tabs-content secondary">';
    $vars ['secondary']['#suffix'] = '</ul>';
    $output .= drupal_render($vars ['secondary']);
  }

  return $output;
}

/**************************************
*  Messenger 
***************************************/
function md_make_status_messages($variables) {
  $display = $variables ['display'];
  $output = '';

  $status_heading = array(
    'status' => t('Status message'),
    'error' => t('Error message'),
    'warning' => t('Warning message'),
  );
  foreach (drupal_get_messages($display) as $type => $messages) {
    $output .= '<div class="container messages-content"><div class="row">';
    if($type=='status'){
          $output .= "<div class=\"alert alert-success\">\n";
          if (!empty($status_heading [$type])) {
            $output .= '<h2 class="element-invisible">' . $status_heading [$type] . "</h2>\n";
          }
            if (count($messages) > 1) {
              $output .= " <ul class=\"list-unstyled\">\n";
              foreach ($messages as $message) {
                $output .= '  <li> ' . $message . "</li>\n";
              }
              $output .= " </ul>\n";
            }
            else {
              $output .= reset($messages);
            }
          $output .= "</div>\n";  
    }
    elseif($type=="error"){
          $output .= "<div class=\"alert alert-danger\">\n";
          if (!empty($status_heading [$type])) {
            $output .= '<h2 class="element-invisible">' . $status_heading [$type] . "</h2>\n";
          }
            if (count($messages) > 1) {
              $output .= " <ul class=\"list-unstyled\">\n";
              foreach ($messages as $message) {
                $output .= '  <li> ' . $message . "</li>\n";
              }
              $output .= " </ul>\n";
            }
            else {
              $output .= reset($messages);
            }
          $output .= "</div>\n";  
    }
    elseif($type=="warning"){
          $output .= "<div class=\"alert alert-warning\">\n";
          if (!empty($status_heading [$type])) {
            $output .= '<h2 class="element-invisible">' . $status_heading [$type] . "</h2>\n";
          }
            if (count($messages) > 1) {
              $output .= " <ul class=\"list-unstyled\">\n";
              foreach ($messages as $message) {
                $output .= ' <li> ' . $message . "</li>\n";
              }
              $output .= " </ul>\n";
            }
            else {
              $output .= reset($messages);
            }
          $output .= "</div>\n";  
    }
    $output .= "</div></div>\n";
  }
  return $output;
}

/**
 * MENU
 */
//Custom One Page
function md_make_links__page_one_menu($variables) {
    $html = "";

    $i = 0;

    foreach ($variables['links'] as $link) {
      
      $i++;
      if($i==1){
        $html .= "<li class='current'>".l($link['title'], $link['href'], $link)."</li>";
      }
      else{
        $html .= "<li>".l($link['title'], $link['href'], $link)."</li>"; 
      }
    }
    $html .= "";
    return $html;
}
/**
 *  WebForm
 */
function md_make_preprocess_webform_form(&$vars) {
  $info = theme_get_setting('address_info');
  $info = explode('||', $info);
  array_pop($info);
  foreach ($info as $key => $value) {
    $info[$key] = $key != 0 ? substr($value, 1, -1) : substr($value, 0, -1);
  }
  $vars['info'] = array_chunk($info, 4);
}

/**
 *  Implement hook_form_alter()
 */
function md_make_form_alter(&$form, &$form_state, $form_id) {
  if (($form_id == 'user_login') || ($form_id == 'user_register_form') || ($form_id == 'user_pass')) {
    $form['pass']['#attributes'] = array('class' => array('form-control'));
    $form['actions']['submit']['#attributes'] = array('class' => array('btn', 'btn-default'));
  }
  elseif (stristr($form_id, "webform_client_form")) {
    $form['#attributes']['class'] = 'contact-form support-form';
    //$form['actions']['submit']['#value'] = t('Send Message');  
    $form['actions']['submit']['#attributes'] = array('class' => array('btn', 'button-line', 'button-white', 'btn-rounded', 'hover-effect', 'm-t-30'));
  }
  else {
    switch ($form_id) {
      case 'comment_node_blog_form':
        $form['actions']['submit']['#attributes']['class'] = array(
          'btn', 'btn-dark', 'btn-rounded', 'hover-effect', 'm-t-20'
        );
        $form['actions']['submit']['#value'] = t('Send message');
        //$form['author']['homepage']['#title'] = t('Website');
        unset($form['author']['mail']['#description']);
        unset($form['actions']['preview']);
        $form['author']['name']['#attributes']['class'] = array('form-control', 'form-white');
        $form['author']['name']['#attributes']['placeholder'] = t('Name');
        $form['author']['mail']['#attributes']['class'] = array('form-control', 'form-white');
        $form['author']['mail']['#attributes']['placeholder'] = t('Email');
        $form['comment_body']['und'][0]['#attributes']['class'] = array('form-control', 'form-white');
        $form['comment_body']['und'][0]['#title'] = t('Message');
        unset($form['subject']['#title']);
        $form['subject']['#attributes']['class'] = array('form-control', 'form-white', 'm-b-20');
        $form['subject']['#attributes']['placeholder'] = t('Subject');
        break;
      case 'search_form':
        $form['advanced']['submit']['#attributes'] = array('class' => array('btn', 'btn-dark', 'btn-rounded', 'hover-effect', 'm-t-20'));
        $form['search_block_form']['#attributes']['placeholder'] = t('Search an article...');
        break;
      case 'form_menu_search':
        $form['terms']['#attributes']['placeholder']="Rechercher";
        break;
      case 'search_block_form':
        $form['search_block_form']['#maxlength'] = '225';
        break;
      // SUBCRIBER FORM NEWLETTER
      case 'newsletter_subscribe_form':
        $form['email']['#default_value'] = 'Enter Your Email';
        $form['email']['#attributes']['placeHolder'] = t('Enter Your Email');
        if (!isset($form['logged-in'])) {
          $form['email']['#prefix'] = '<div class="append-icon">';
          $form['email']['#suffix'] = '<i class="line-icon-envelope-letter"></i></div>';
          $form['newsletter-submit']['#attributes']['class'][] = 'element-invisible';
        }
        break;

      //CONTACT FORM FOOTER
      case 'contact_site_form':
        $form['#prefix'] = '<div class="footer-contact">';
        $form['#suffix'] = '</div>';
        $form['copy']['#access'] = FALSE;

        $form['name']['#title_display'] = 'invisible';
        $form['name']['#attributes']['placeholder'] = t('Your name');
        $form['name']['#attributes']['class'][] = 'form-control placeholder';
        $form['name']['#prefix'] = '<div class="row"><div class="col-md-6"><div class="append-icon">';
        $form['name']['#suffix'] = '<i class="line-icon-user"></i></div></div>';

        $form['mail']['#title_display'] = 'invisible';
        $form['mail']['#attributes']['class'][] = 'form-control placeholder';
        $form['mail']['#attributes']['placeholder'] = t('Your email');
        $form['message']['#prefix'] = '<div class="contact-content">';
        $form['message']['#suffix'] = '</div>';

        $form['mail']['#prefix'] = '<div class="col-md-6"><div class="append-icon">';
        $form['mail']['#suffix'] = '<i class="line-icon-envelope-letter"></i></div></div></div>';

        $form['message']['#title_display'] = 'invisible';
        $form['message']['#attributes']['class'][] = 'textarea-field form-control m-t-20';
        $form['subject']['#required'] = FALSE;
        $form['subject']['#access'] = FALSE;
        break;

    }
  }
}

/**
 * Implement hook_theme()
 * @return array
 */
function md_make_theme() {
  $themes = array();
  $path = drupal_get_path('theme', 'md_make') . '/templates';
  $themes['comment_form__node_blog'] = array(
    'render element' => 'form',
    'template' => 'comment-form--node-blog',
    'path' => $path . '/comment',
  );
  $themes['comment_form__node_shop_product'] = array(
    'render element' => 'form',
    'template' => 'comment-form--node-shop-product',
    'path' => $path . '/comment',
  );
  $themes['search_api_ranges_block_slider_view_form'] = array(
    'render element' => 'form',
    'template' => 'facet-slider-shop-product',
    'path' => $path . '/form',
  );
  $themes['simplenews_block_form'] = array(
    'render element' => 'form',
    'template' => 'simplenews-block-form',
    'path' => $path . '/simplenews',
  );
  return $themes;
}

/**
 * Simplenew Module Style
 */
function md_make_preprocess_simplenews_block_form(&$vars) {
  $form = $vars['form'];
  $form['mail']['#title_display'] = 'invisible';
  $form['submit']['#attributes']['class'][] = 'btn btn-default';
  $vars['form'] = $form;
}

/**
 * Bread crumb
 */
function md_make_breadcrumb($variables) {
  
  $breadcrumb = $variables['breadcrumb'];
  /*---FIN-SPEC ACTIVITES--*/ 
  if (!empty($breadcrumb)) {
      $crumbs ="";
      /*$crumbs .="is activité ?";*/
      $node = menu_get_object();
      /*if ($node) $crumbs .=$node->type;*/
      if ($node && hasADTClonePrefix($node->type))
        {
            $activite = getActiviteByCloneType($node->type);
            
            /* $crumbs .="is activité";*/
            
            $paths = explode('|', $activite->parent_path);
            $titles = explode('|', $activite->parent_title);
            $i = 0;
            
            $parentPath = '';
            
            foreach($paths as $path)
            {            
                $parentPath .= '/' . $path;
                $breadcrumb[$i] = '<a href="' . $parentPath . '">' . $titles[$i++] . '</a>' . $breadcrumbSeparator;
                //$i++;
            }
            
        }
  /*---FIN-SPEC ACTIVITES--*/ 
      
      
    $crumbs .= '<div class="breadcrumbs clearfix">';
    $breadcrumb[0] = '<a class="br_home" href="' . url('<front>', array('absolute' => TRUE)) . '"><i class="icon fontello icon-home-1"></i></a>';
    foreach ($breadcrumb as $value) {
      $crumbs .= $value.'<i class="icon fontello icon-angle-right"></i>';
    }
    $crumbs .= '<span>' . drupal_get_title() . '</span>';

    $crumbs .='</div>';
    return $crumbs;
  }
  else {
    return NULL;
  }
}

/**
 * Implement hook_preprocess_comment()
 */
function md_make_preprocess_comment(&$vars) {
  $comment = $vars['elements']['#comment'];

  $vars['custom_hour'] = format_date($comment->created, 'custom', 'h:i A');
  $vars['custom_date'] = format_date($comment->created, 'custom', 'j F o');

  $uri = entity_uri('comment', $comment);
  $uri['options'] += array('attributes' => array('class' => 'permalink', 'rel' => 'bookmark'));
  $vars['submitted'] = t('!datetime', array('!username' => $vars['author'], '!datetime' => date('F j, o \a\t h:i a', $comment->created)));
}

/* * +
 * theme_button()
 */

function md_make_button($vars) {

  $element = $vars['element'];
  $element['#attributes']['type'] = 'submit';
  element_set_attributes($element, array('id', 'name', 'value'));

  if (!isset($element['#attributes']['class']) || !in_array("btn", $element['#attributes']['class'])) {
    $element['#attributes']['class'][] = 'btn btn-default form-' . $element['#button_type'];
  }
  if (!empty($element['#attributes']['disabled'])) {
    $element['#attributes']['class'][] = 'form-button-disabled';
  }
  return '<input' . drupal_attributes($element['#attributes']) . ' />';
}

/**
 * Overwire theme_username()
 */
function md_make_username($vars) {
  if (isset($vars ['link_path'])) {
    $output = l($vars ['name'] . $vars ['extra'], $vars ['link_path'], $vars ['link_options']);
  }
  else {
    $output = '<span>' . $vars ['name'] . $vars ['extra'] . '</span>';
  }
  return $output;
}

function md_make_preprocess_views_view_fields(&$vars) {
  $vars['blog_4col'] = '';
  if (theme_get_setting('masonry_setting') == 'masonry_4col' && theme_get_setting('chosse_blog_list') == 'masonry' || theme_get_setting('grid_setting') == 'grid_4col' && theme_get_setting('chosse_blog_list') == 'grid') {
    $vars['blog_4col'] = 'col-4';
  }

  // Theme-Settings BLog Single
  $vars['top_text'] = '';
  $vars['text_position'] = '';
  if (theme_get_setting('blog_single_full_sidebar') == 'full') {
    $vars['top_text'] = '';
    $vars['text_position'] = 'text-center';
  }
  else {
    $vars['top_text'] = 'top-text';
    $vars['text_position'] = 'text-left';
  }

  // Theme-Settings BLog taxonomy
  $vars['blog_taxonomy_grid_2col'] = '';
  $vars['blog_taxonomy_grid_3col'] = '';
  $vars['blog_taxonomy_grid_4col'] = '';
  if (theme_get_setting('blog_taxonomy_option') == 'grid') {
    if (theme_get_setting('grid_setting') == 'grid_2col_left' || theme_get_setting('grid_setting') == 'grid_2col_right') {
      $vars['blog_taxonomy_grid_2col'] = 'col-md-6';
      $vars['blog_taxonomy_grid_3col'] = '';
      $vars['blog_taxonomy_grid_4col'] = '';
    }
    elseif (theme_get_setting('grid_setting') == 'grid_3col') {
      $vars['blog_taxonomy_grid_2col'] = '';
      $vars['blog_taxonomy_grid_3col'] = 'col-md-4';
      $vars['blog_taxonomy_grid_4col'] = '';
    }
    elseif (theme_get_setting('grid_setting') == 'grid_4col') {
      $vars['blog_taxonomy_grid_2col'] = '';
      $vars['blog_taxonomy_grid_3col'] = '';
      $vars['blog_taxonomy_grid_4col'] = 'col-md-3';
    }
  }
}

function md_make_preprocess_views_view_unformatted(&$vars) {
  $vars['blog_list'] = '';
  (theme_get_setting('chosse_blog_list') == 'classic' ) ? $vars['blog_list'] = 'classic' : ((theme_get_setting('chosse_blog_list') == 'masonry') ? $vars['blog_list'] = 'masonry' : $vars['blog_list'] = 'grid');
  if (theme_get_setting('masonry_setting') == 'masonry_2col_left' || theme_get_setting('masonry_setting') == 'masonry_2col_right') {
    $vars['masonry_2col'] = 'col-md-6 col-sm-6 col-xs-12';
    $vars['masonry_3col'] = '';
    $vars['masonry_4col'] = '';
  }
  elseif (theme_get_setting('masonry_setting') == 'masonry_3col') {
    $vars['masonry_2col'] = '';
    $vars['masonry_3col'] = 'col-md-4 col-sm-6 col-xs-12';
    $vars['masonry_4col'] = '';
  }
  else {
    $vars['masonry_2col'] = '';
    $vars['masonry_3col'] = '';
    $vars['masonry_4col'] = 'col-md-3 col-sm-6 col-xs-12';
  }
  if (theme_get_setting('grid_setting') == 'grid_2col_left' || theme_get_setting('grid_setting') == 'grid_2col_right') {
    $vars['grid_2col'] = 'col-md-6';
    $vars['grid_3col'] = '';
    $vars['grid_4col'] = '';
  }
  elseif (theme_get_setting('grid_setting') == 'grid_3col') {
    $vars['grid_2col'] = '';
    $vars['grid_3col'] = 'col-md-4';
    $vars['grid_4col'] = '';
  }
  else {
    $vars['grid_2col'] = '';
    $vars['grid_3col'] = '';
    $vars['grid_4col'] = 'col-md-3';
  }

  // Theme-Settings BLog taxonomy
  $vars['blog_taxonomy_masonry_2col'] = '';
  $vars['blog_taxonomy_masonry_3col'] = '';
  $vars['blog_taxonomy_masonry_4col'] = '';
  if (theme_get_setting('blog_taxonomy_option') == 'masonry') {
    if (theme_get_setting('masonry_setting') == 'masonry_2col_left' || theme_get_setting('masonry_setting') == 'masonry_2col_right') {
      $vars['blog_taxonomy_masonry_2col'] = 'col-md-6 col-sm-6 col-xs-12';
      $vars['blog_taxonomy_masonry_3col'] = '';
      $vars['blog_taxonomy_masonry_4col'] = '';
    }
    elseif (theme_get_setting('masonry_setting') == 'masonry_3col') {
      $vars['blog_taxonomy_masonry_2col'] = '';
      $vars['blog_taxonomy_masonry_3col'] = 'col-md-4 col-sm-6 col-xs-12';
      $vars['blog_taxonomy_masonry_4col'] = '';
    }
    elseif (theme_get_setting('masonry_setting') == 'masonry_4col') {
      $vars['blog_taxonomy_masonry_2col'] = '';
      $vars['blog_taxonomy_masonry_3col'] = '';
      $vars['blog_taxonomy_masonry_4col'] = 'col-md-3 col-sm-6 col-xs-12';
    }
  }
}

function md_make_preprocess_views_view_field(&$vars) {
  $vars['blog_list'] = '';
  (theme_get_setting('chosse_blog_list') == 'classic' ) ? $vars['blog_list'] = 'classic' : ((theme_get_setting('chosse_blog_list') == 'masonry') ? $vars['blog_list'] = 'masonry' : $vars['blog_list'] = 'grid');
}

function md_make_preprocess_search_result(&$vars) {
  if(isset($vars['result']['node']->nid)){
      $node = node_load($vars['result']['node']->nid);
  }
  $vars['row_search_result'] = '';
  $vars['left_col_search_result'] = '';
  $vars['right_col_search_result'] = '';
  $field_media = field_get_items('node', $node, 'field_media');
  if($field_media != ''){
    $vars['output'] = field_view_field('node', $node, 'field_media');
    $vars['row_search_result'] = 'row';
    $vars['left_col_search_result'] = 'col-md-3';
    $vars['right_col_search_result'] = 'col-md-9';
  }
}