<?php

/**
 * @file
 * Theme settings .
 */
function md_make_theme_settings_design(&$form, &$form_state) {
  global $base_url;
  $theme_default = variable_get('theme_default');

  $form['md_make_settings']['design'] = array(
    '#type' => 'fieldset',
    '#weight' => -4,
    '#prefix' => '<div id="md-design" class="md-tabcontent clearfix">',
    '#suffix' => '</div><!-- / #md-design -->',
  );

  $form['md_make_settings']['design']['design_htmllist'] = array(
    '#markup' => '<div id="md-content-sidebar" class="md-content-sidebar">
                        <ul class="clearfix">                            
                            <li><a href="#ds-preloader"><i class="fa-refresh icon fa"></i>Preloader</a></li>
                            <li><a href="#ds-header"><i class="fa-list-ul icon fa"></i>Header</a></li>
                            <li><a href="#ds-footer"><i class="fa-list-ul icon fa"></i>Footer</a></li>
                            <li><a href="#ds-contact"><i class="fa-list-ul icon fa"></i>Contact</a></li>
														<li><a href="#ds-maintenance"><i class="fa-list-ul icon fa"></i>Under Maintenance</a></li>
                            <li><a href="#ds-blog"><i class="fa-list-ul icon fa"></i>Blog</a></li>
                            <li><a href="#ds-portfolio"><i class="fa-list-ul icon fa"></i>Portforlio</a></li>
                            <li><a href="#ds-not-found"><i class="fa-list-ul icon fa"></i>404</a></li>
                        </ul>
                    </div><!-- /.md-content-sidebar -->
                    <div class="md-content-main">',
    '#weight' => -15,
  );
  $form['md_make_settings']['design']['design_htmllistclose'] = array(
    '#markup' => '</div><!-- /.md-listleft -->',
    '#weight' => 15,
  );

  //////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////// Preloader //////////////////////////////
  //////////////////////////////////////////////////////////////////////////////
  $form['md_make_settings']['design']['ds_preloader'] = array(
    '#type' => 'fieldset',
    '#weight' => 1,
    '#prefix' => '<div id="ds-preloader"><div class="md-tabcontent-row">',
    '#suffix' => '    </div></div><!-- / #ds-general -->',
  );
  $form['md_make_settings']['design']['ds_preloader']['preload'] = array(
    '#type' => 'checkbox',
    '#field_suffix' => '<label class="label-checkbox" for="edit-preload' . '">' . t('Enable Preload') . '</label>',
    '#attributes' => array(
      'class' => array('input-checkbox')
    ),
    '#prefix' => '<div class="form-group">',
    '#suffix' => '</div>',
    '#default_value' => theme_get_setting('preload'),
  );
  /////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////// header //////////////////////////////////
  /////////////////////////////////////////////////////////////////////////////
  $form['md_make_settings']['design']['ds_header'] = array(
    '#type' => 'fieldset',
    '#weight' => 1,
    '#prefix' => '<div id="ds-header"><div class="md-tabcontent-row">',
    '#suffix' => '</div></div><!-- / #ds-general -->',
  );

  $form['md_make_settings']['design']['ds_header']['header_setting'] = array(
    '#prefix' => '<h3 class="md-tabcontent-title">Setting header</h3><div class="form-group" style="margin-bottom: 0">',
    '#suffix' => '</div>',
  );

  /* Header fixed */
  $form['md_make_settings']['design']['ds_header']['header_setting']['header_fixed'] = array(
    '#type' => 'checkbox',
    '#field_suffix' => '<label class="label-checkbox" for="edit-header-fixed' . '">' . t('Header Sticky') . '</label>',
    '#attributes' => array(
      'class' => array('input-checkbox')
    ),
    '#prefix' => '<div class="form-item">',
    '#suffix' => '</div>',
    '#default_value' => theme_get_setting('header_fixed'),
  );

   /* Header FullWidth*/
  $form['md_make_settings']['design']['ds_header']['header_setting']['header_fullwidth'] = array(
    '#type' => 'checkbox',
    '#field_suffix' => '<label class="label-checkbox" for="edit-header-fullwidth' . '">' . t('Header FullWidth') . '</label>',
    '#attributes' => array(
      'class' => array('input-checkbox')
    ),
    '#prefix' => '<div class="form-item">',
    '#suffix' => '</div>',
    '#default_value' => theme_get_setting('header_fullwidth'),
  );

  /* Header Transparent */
  $form['md_make_settings']['design']['ds_header']['header_setting']['header_transparent'] = array(
    '#type' => 'checkbox',
    '#field_suffix' => '<label class="label-checkbox" for="edit-header-transparent' . '">' . t('Header Transparent') . '</label>',
    '#attributes' => array(
      'class' => array('input-checkbox')
    ),
    '#prefix' => '<div class="form-item">',
    '#suffix' => '</div>',
    '#default_value' => theme_get_setting('header_transparent'),
  );


  /* select header type */
  $form['md_make_settings']['design']['ds_header']['header_setting']['header_type'] = array(
    '#type' => 'select',
    '#title' => t('Choose header type'),
    '#default_value' => theme_get_setting('header_type'),
    '#options' => array(
      'one' => t('Header One'),
      'second' => t('Header Second'),
    ),
    '#attributes' => array(
      'class' => array('select')
    ),
    '#field_prefix' => '<div class="md-selection medium">',
    '#field_suffix' => '</div>'
  );


  /* Header Color */
  $form['md_make_settings']['design']['ds_header']['header_setting']['header_info_backgroundcolor'] = array(
      '#type' => 'textfield',
      '#title' => t('Info Detail Background Color'),
      '#default_value' => theme_get_setting('header_info_backgroundcolor'),
      '#attributes' => array(
        'class' => array(
          'form-colorpicker',
        ),
      ),
      '#prefix' => '<div class="form-group">',
      '#field_prefix' => '<div class="form-group">',
      '#field_suffix' => '</div>',
    );
  $form['md_make_settings']['design']['ds_header']['header_setting']['header_info_color'] = array(
      '#type' => 'textfield',
      '#title' => t('Info Detail Color'),
      '#default_value' => theme_get_setting('header_info_color'),
      '#attributes' => array(
        'class' => array(
          'form-colorpicker',
        ),
      ),
      '#prefix' => '<div class="form-group">',
      '#field_prefix' => '<div class="form-group">',
      '#field_suffix' => '</div>',
    );
  $form['md_make_settings']['design']['ds_header']['header_setting']['header_menu_backgroundcolor'] = array(
      '#type' => 'textfield',
      '#title' => t('Menu Logo Background Color'),
      '#default_value' => theme_get_setting('header_menu_backgroundcolor'),
      '#attributes' => array(
        'class' => array(
          'form-colorpicker',
        ),
      ),
      '#prefix' => '<div class="form-group">',
      '#field_prefix' => '<div class="form-group">',
      '#field_suffix' => '</div>',
    );
  $form['md_make_settings']['design']['ds_header']['header_setting']['header_menu_color_shadow'] = array(
      '#type' => 'textfield',
      '#title' => t('Menu Logo Shadow'),
      '#default_value' => theme_get_setting('header_menu_color_shadow'),
      '#attributes' => array(
        'class' => array(
          'form-colorpicker',
        ),
      ),
      '#prefix' => '<div class="form-group">',
      '#field_prefix' => '<div class="form-group">',
      '#field_suffix' => '</div>',
    );

  /* Menu */
  $form['md_make_settings']['design']['ds_header']['header_setting']['header_border_text'] = array(
      '#type' => 'textfield',
      '#title' => t('Menu Sub Border Top Color'),
      '#default_value' => theme_get_setting('header_border_text'),
      '#attributes' => array(
        'class' => array(
          'form-colorpicker',
        ),
      ),
      '#prefix' => '<div class="form-group">',
      '#field_prefix' => '<div class="form-group">',
      '#field_suffix' => '</div>',
    );
  $form['md_make_settings']['design']['ds_header']['header_setting']['header_list_border_color'] = array(
      '#type' => 'textfield',
      '#title' => t('Menu Sub List Border Color'),
      '#default_value' => theme_get_setting('header_list_border_color'),
      '#attributes' => array(
        'class' => array(
          'form-colorpicker',
        ),
      ),
      '#prefix' => '<div class="form-group">',
      '#field_prefix' => '<div class="form-group">',
      '#field_suffix' => '</div>',
    );
  $form['md_make_settings']['design']['ds_header']['header_setting']['header_menu_color'] = array(
      '#type' => 'textfield',
      '#title' => t('Menu Lever One Color'),
      '#default_value' => theme_get_setting('header_menu_color'),
      '#attributes' => array(
        'class' => array(
          'form-colorpicker',
        ),
      ),
      '#prefix' => '<div class="form-group">',
      '#field_prefix' => '<div class="form-group">',
      '#field_suffix' => '</div>',
    );
  $form['md_make_settings']['design']['ds_header']['header_setting']['header_menu_color_hover'] = array(
      '#type' => 'textfield',
      '#title' => t('Menu Color Hover'),
      '#default_value' => theme_get_setting('header_menu_color_hover'),
      '#attributes' => array(
        'class' => array(
          'form-colorpicker',
        ),
      ),
      '#prefix' => '<div class="form-group">',
      '#field_prefix' => '<div class="form-group">',
      '#field_suffix' => '</div>',
    );
  $form['md_make_settings']['design']['ds_header']['header_setting']['header_text_color'] = array(
      '#type' => 'textfield',
      '#title' => t('Menu Sub Color'),
      '#default_value' => theme_get_setting('header_text_color'),
      '#attributes' => array(
        'class' => array(
          'form-colorpicker',
        ),
      ),
      '#prefix' => '<div class="form-group">',
      '#field_prefix' => '<div class="form-group">',
      '#field_suffix' => '</div>',
    );

  /* select region display */
  $form['md_make_settings']['design']['ds_header']['header_setting']['header_info'] = array(
    '#type' => 'radios',
    '#title' => t('Display Region Info'),
    '#options' => array(
        "yes" => "Yes", 
        "no" => "No"
      ),
    '#default_value' => theme_get_setting('header_info'),
  );

  $form['md_make_settings']['design']['ds_header']['header_setting']['header_detail'] = array(
    '#type' => 'radios',
    '#title' => t('Display Region Detail'),
    '#options' => array(
        "yes" => "Yes", 
        "no" => "No"
      ),
    '#default_value' => theme_get_setting('header_detail'),
  );
  $form['md_make_settings']['design']['ds_header']['header_setting']['header_region_detail'] = array(
                    '#type' => 'fieldset',
                    '#states' => array(
                      'visible' => array(
                        ':input[name="header_detail"]' => array('value' => t('yes')),
                      ),
                    ),
                  );
  $form['md_make_settings']['design']['ds_header']['header_setting']['header_region_detail']['region_detail_width'] = array(
        '#type' => 'select',
        '#title' => t('Type Region settings'),
        '#options' => array(
          'half_width' => t('Type Half Width'),
          'full_width' => t('Type Full Width'),
        ),
        '#default_value' => theme_get_setting('region_detail_width'),
    );
  /////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////// Footer ////////////////////////////////
  /////////////////////////////////////////////////////////////////////////////
  $form['md_make_settings']['design']['ds_footer'] = array(
    '#type' => 'fieldset',
    '#weight' => 1,
    '#prefix' => '<div id="ds-footer"><div class="md-tabcontent-row">',
    '#suffix' => '</div></div><!-- / #ds-general -->',
  );
  $form['md_make_settings']['design']['ds_footer']['footer_setting']['footer_top_backgroundcolor'] = array(
      '#type' => 'textfield',
      '#title' => t('Footer Top Background'),
      '#default_value' => theme_get_setting('footer_top_backgroundcolor'),
      '#attributes' => array(
        'class' => array(
          'form-colorpicker',
        ),
      ),
      '#prefix' => '<div class="form-group">',
      '#field_prefix' => '<div class="form-group">',
      '#field_suffix' => '</div>',
    );
  $form['md_make_settings']['design']['ds_footer']['footer_setting']['footer_top_color'] = array(
      '#type' => 'textfield',
      '#title' => t('Footer Top Color'),
      '#default_value' => theme_get_setting('footer_top_color'),
      '#attributes' => array(
        'class' => array(
          'form-colorpicker',
        ),
      ),
      '#prefix' => '<div class="form-group">',
      '#field_prefix' => '<div class="form-group">',
      '#field_suffix' => '</div>',
    );
  $form['md_make_settings']['design']['ds_footer']['footer_setting']['footer_bottom_backgroundcolor'] = array(
      '#type' => 'textfield',
      '#title' => t('Footer Second Background'),
      '#default_value' => theme_get_setting('footer_bottom_backgroundcolor'),
      '#attributes' => array(
        'class' => array(
          'form-colorpicker',
        ),
      ),
      '#prefix' => '<div class="form-group">',
      '#field_prefix' => '<div class="form-group">',
      '#field_suffix' => '</div>',
    );
  $form['md_make_settings']['design']['ds_footer']['footer_setting']['footer_bottom_color'] = array(
      '#type' => 'textfield',
      '#title' => t('Footer Second Color'),
      '#default_value' => theme_get_setting('footer_bottom_color'),
      '#attributes' => array(
        'class' => array(
          'form-colorpicker',
        ),
      ),
      '#prefix' => '<div class="form-group">',
      '#field_prefix' => '<div class="form-group">',
      '#field_suffix' => '</div>',
    );
  //////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////// LAYOUT PORTFOLIO ///////////////////////
  //////////////////////////////////////////////////////////////////////////////

  // SINGLE PORTFOLIO SETTING
	$form['md_make_settings']['design']['ds_portfolio']['portfolio_layout'] = array(
    '#type' => 'fieldset',
    '#weight' => 1,
    '#prefix' => '<div id="ds-portfolio"><div class="md-tabcontent-row">',
    '#suffix' => '    </div></div><!-- / #ds-general -->',
  );
  $form['md_make_settings']['design']['ds_portfolio']['portfolio_layout']['portfolio_single_content'] = array(
    '#type' => 'fieldset',
    '#prefix' => '<h3 class="md-tabcontent-title">Setting Portfolio Single</h3><div class="form-group" style="margin-bottom: 0">',
    '#suffix' => '</div><!-- /.md-tabcontent-row -->'
  );
  $form['md_make_settings']['design']['ds_portfolio']['portfolio_layout']['portfolio_single_content']['portfolio_header_background'] = array(
      '#type' => 'hidden',
      '#prefix' => '<div class="wrap-form-media"><h3>Background header for Porfolio Single Boxed</h3><div class="media-preview"></div>',
      '#suffix' => '<div class="media-control"><a href="#" class="media-change md-button">Change</a><a href="#" class="media-delete md-button gray">Delete</a></div></div>',
      '#attributes' => array(
        'class' => array('input-fid')
      ),
      '#default_value' => theme_get_setting('portfolio_header_background'),
  );


  /////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////// Blog //////////////////////////////////
  /////////////////////////////////////////////////////////////////////////////
  $form['md_make_settings']['design']['ds_blog'] = array(
    '#type' => 'fieldset',
    '#weight' => 1,
    '#prefix' => '<div id="ds-blog"><div class="md-tabcontent-row">',
    '#suffix' => '</div></div><!-- / #ds-general -->',
  );

  $form['md_make_settings']['design']['ds_blog']['blog_setting'] = array(
    '#prefix' => '<h3 class="md-tabcontent-title">Blog Type</h3><div class="form-group" style="margin-bottom: 0">',
  );

 

  // Blog Settings Single type
  $form['md_make_settings']['design']['ds_blog']['blog_setting']['blog_single_full_sidebar'] = array(
    '#type' => 'select',
    '#title' => t('Choose blog single type'),
    '#default_value' => theme_get_setting('blog_single_full_sidebar'),
    '#options' => array(
      'full' => t('Fullwidth'),
      'left' => t('Sidebar Left'),
      'right' => t('Sidebar Right'),
    ),
    '#attributes' => array(
      'class' => array('select')
    ),
    '#field_prefix' => '<div class="md-selection medium">',
    '#field_suffix' => '</div>'
  );

  // Blog Taxonomy
  $form['md_make_settings']['design']['ds_blog']['blog_setting']['blog_taxonomy_option'] = array(
    '#type' => 'select',
    '#title' => t('Choose Blog Taxonomy Type'),
    '#default_value' => theme_get_setting('blog_taxonomy_option'),
    '#options' => array(
      'classic' => t('Classic'),
      'masonry' => t('Masonry'),
      'grid' => t('Grid'),
    ),
    '#attributes' => array(
      'class' => array('select')
    ),
    '#field_prefix' => '<div class="md-selection medium">',
    '#field_suffix' => '</div>'
  );

  // Blog Settings List type
  $form['md_make_settings']['design']['ds_blog']['blog_setting']['blog_list_option']['chosse_blog_list'] = array(
    '#type' => 'select',
    '#title' => t('Choose blog list type'),
    '#default_value' => theme_get_setting('chosse_blog_list'),
    '#options' => array(
      'classic' => t('Classic'),
      'masonry' => t('Masonry'),
      'grid' => t('Grid'),
    ),
    '#attributes' => array(
      'class' => array('select')
    ),
    '#field_prefix' => '<div class="md-selection medium">',
    '#field_suffix' => '</div>'
  );

  // Classic
  $form['md_make_settings']['design']['ds_blog']['blog_setting']['blog_list_option']['chosse_classic_option'] = array(
    '#type' => 'fieldset',
    '#title' => t('Option'),
    '#collapsible' => TRUE,
    '#collapsed' => FALSE,
    '#states' => array(
      'visible' => array(
        ':input[name="chosse_blog_list"]' => array('value' => 'classic'),
      ),
    ),
  );

  $form['md_make_settings']['design']['ds_blog']['blog_setting']['blog_list_option']['chosse_classic_option']['classic_setting'] = array(
    '#type' => 'radios',
    '#title' => t('Choose Blog Classic Option'),
    '#default_value' => theme_get_setting('classic_setting'),
    '#options' => array(
      'classic_sidebar_left' => t('Classic With Sidebar Left'),
      'classic_sidebar_right' => t('Classic With Sidebar Right'),
      'classic_fullwidth' => t('Classic Fullwidth'),
    ),
    '#attributes' => array(
      'class' => array('radios')
    ),
    '#field_prefix' => '<div class="md-radio">',
    '#field_suffix' => '</div>'
  );

  //Masonry
  $form['md_make_settings']['design']['ds_blog']['blog_setting']['blog_list_option']['chosse_masonry_option'] = array(
    '#type' => 'fieldset',
    '#title' => t('Option'),
    '#collapsible' => TRUE,
    '#collapsed' => FALSE,
    '#states' => array(
      'visible' => array(
        ':input[name="chosse_blog_list"]' => array('value' => 'masonry'),
      ),
    ),
  );

  $form['md_make_settings']['design']['ds_blog']['blog_setting']['blog_list_option']['chosse_masonry_option']['masonry_setting'] = array(
    '#type' => 'radios',
    '#title' => t('Choose Blog Masonry Option'),
    '#default_value' => theme_get_setting('masonry_setting'),
    '#options' => array(
      'masonry_2col_left' => t('Masonry 2 Columns With Sidebar Left'),
      'masonry_2col_right' => t('Masonry 2 Columns With Sidebar Right'),
      'masonry_3col' => t('Masonry 3 Columns'),
      'masonry_4col' => t('Masonry 4 Columns'),
    ),
    '#attributes' => array(
      'class' => array('radios')
    ),
    '#field_prefix' => '<div class="md-radio">',
    '#field_suffix' => '</div>'
  );

  // Grid
  $form['md_make_settings']['design']['ds_blog']['blog_setting']['blog_list_option']['chosse_grid_option'] = array(
    '#type' => 'fieldset',
    '#title' => t('Option'),
    '#collapsible' => TRUE,
    '#collapsed' => FALSE,
    '#states' => array(
      'visible' => array(
        ':input[name="chosse_blog_list"]' => array('value' => 'grid'),
      ),
    ),
  );

  $form['md_make_settings']['design']['ds_blog']['blog_setting']['blog_list_option']['chosse_grid_option']['grid_setting'] = array(
    '#type' => 'radios',
    '#title' => t('Choose Blog Grid Option'),
    '#default_value' => theme_get_setting('grid_setting'),
    '#options' => array(
      'grid_2col_left' => t('Grid 2 Columns With Sidebar Left'),
      'grid_2col_right' => t('Grid 2 Columns With Sidebar Right'),
      'grid_3col' => t('Grid 3 Columns'),
      'grid_4col' => t('Grid 4 Columns'),
    ),
    '#attributes' => array(
      'class' => array('radios')
    ),
    '#field_prefix' => '<div class="md-radio">',
    '#field_suffix' => '</div>'
  );


  // Background Title setting
  $form['md_make_settings']['design']['ds_blog']['blog_setting']['background_image'] = array(
    '#type' => 'fieldset',
    '#weight' => 3,
    '#prefix' => '<h3 class="md-tabcontent-title">Background Title Blog Image</h3>',
    '#collapsible' => TRUE
  );

  $form['md_make_settings']['design']['ds_blog']['blog_setting']['background_image']['background_title_image'] = array(
    '#type' => 'hidden',
    '#prefix' => '<div class="wrap-form-media"><h3>Background Title Blog Image</h3><div class="media-preview"></div>',
    '#suffix' => '<div class="media-control"><a href="#" class="media-change md-button">Change</a><a href="#" class="media-delete md-button gray">Delete</a></div></div>',
    '#attributes' => array(
      'class' => array('input-fid')
    ),
    '#default_value' => theme_get_setting('background_title_image'),
  );


  /////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////// Custom Address ////////////////////////
  /////////////////////////////////////////////////////////////////////////////
  $form['md_make_settings']['design']['ds_contact'] = array(
    '#type' => 'fieldset',
    '#weight' => 1,
    '#prefix' => '<div id="ds-contact"><div class="md-tabcontent-row">',
    '#suffix' => '    </div></div><!-- / #ds-general -->',
  );

  // Contact Infomation Text
  $form['md_make_settings']['design']['ds_contact']['contact_info'] = array(
    '#type' => 'fieldset',
    '#weight' => 3,
    '#prefix' => '<h3 class="md-tabcontent-title">Contact Infomation</h3>',
    '#collapsible' => TRUE
  );

  // Title Page Contact
  $form['md_make_settings']['design']['ds_contact']['contact_info']['title_page_contact_full'] = array(
    '#type' => 'textfield',
    '#title' => t('Title page contact fullmap'),
    '#resizable' => FALSE,
    '#rows' => 2,
    '#default_value' => theme_get_setting('title_page_contact_full'),
    '#attributes' => array(
      'class' => array('input-border')
    )
  );

  $form['md_make_settings']['design']['ds_contact']['contact_info']['des_title_page_contact_full'] = array(
    '#type' => 'textarea',
    '#title' => t('Description title page contact fullmap'),
    '#resizable' => FALSE,
    '#rows' => 5,
    '#default_value' => theme_get_setting('des_title_page_contact_full'),
    '#description' => t('The following text will be added in title page Contact.'),
    '#attributes' => array(
      'class' => array('input-border'),

    )
  );

  $form['md_make_settings']['design']['ds_contact']['contact_info']['title_des_contact_info'] = array(
    '#type' => 'textfield',
    '#title' => t('Title description contact fullmap'),
    '#resizable' => FALSE,
    '#rows' => 2,
    '#default_value' => theme_get_setting('title_des_contact_info'),
    '#attributes' => array(
      'class' => array('input-border')
    )
  );
  $form['md_make_settings']['design']['ds_contact']['contact_info']['des_contact_info'] = array(
    '#type' => 'textarea',
    '#title' => t('Content description contact fullmap'),
    '#resizable' => FALSE,
    '#rows' => 5,
    '#default_value' => theme_get_setting('des_contact_info'),
    '#description' => t('The following text will be added in page Contact.'),
    '#attributes' => array(
      'class' => array('input-border')
    )
  );





	//////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////// Page Maintenance //////////////////////
  //////////////////////////////////////////////////////////////////////////////
  $form['md_make_settings']['design']['ds_maintenance'] = array(
    '#type' => 'fieldset',
    '#weight' => 1,
    '#prefix' => '<div id="ds-maintenance"><div class="md-tabcontent-row">',
    '#suffix' => '    </div></div><!-- / #ds-general -->',
  );
  $form['md_make_settings']['design']['ds_maintenance']['maintenance_logo'] = array(
    '#type' => 'hidden',
    '#prefix' => '<div class="wrap-form-media"><h3>Maintenance Logo</h3><div class="media-preview"></div>',
    '#suffix' => '<div class="media-control"><a href="#" class="media-change md-button">Change</a><a href="#" class="media-delete md-button gray">Delete</a></div></div>',
    '#attributes' => array(
      'class' => array('input-fid')
    ),
    '#default_value' => theme_get_setting('maintenance_logo'),
  );
  $form['md_make_settings']['design']['ds_maintenance']['maintenance_title'] = array(
    '#type' => 'textfield',
    '#title' => t('Title'),
    '#default_value' => theme_get_setting('maintenance_title'),
    '#attributes' => array(
      'class' => array('input-border big')
    ),
    '#prefix' => '<div class="form-group">',
    '#suffix' => '</div>',
  );
  $form['md_make_settings']['design']['ds_maintenance']['maintenance_map_location'] = array(
    '#type' => 'textfield',
    '#title' => t('Map Location'),
    '#default_value' => theme_get_setting('maintenance_map_location'),
    '#attributes' => array(
      'class' => array('input-border big')
    ),
    '#prefix' => '<div class="form-group">',
    '#suffix' => '</div>',
  );
  $form['md_make_settings']['design']['ds_maintenance']['maintenance_time'] = array(
    '#type' => 'textfield',
    '#title' => t('Comming Soon'),
    '#default_value' => theme_get_setting('maintenance_time'),
    '#description'  => t('example: 2020/02/20 20:02:40'),
    '#attributes' => array(
      'class' => array('input-border big')
    ),
    '#prefix' => '<div class="form-group">',
    '#suffix' => '</div>',
  );
	
	/* List Content Maintenance Mode */
	 $form['md_make_settings']['design']['ds_maintenance']['pages_content'] = array(
    '#type' => 'fieldset',
    '#weight' => 1,
    '#prefix' => '<div id="maintenance-content">',
    '#suffix' => '</div><!-- / #ds-general -->',
  );
	
	$title_template = '<h3>Content Title: @title</h3>';
  $title_template .= '<div><div class="content"><span>Title: </span> <input type="text" name="title" value="@title"></div>';
  $title_template .= '<div class="content"><span>Subtitle : </span> <input type="text" name="subtitle" value="@subtitle"></div>';
  $title_template .= '<div class="content"><span>Description : </span> <textarea class="input-border form-textarea" name="description" cols="60" rows="5">@description</textarea></div></div>';

  if (!theme_get_setting('tabcontent_data')) {
    $title_markup = format_string($title_template, array('@title' => '', '@title' => '', '@subtitle' => '', '@description' => ''));
  }
  else {
    $title_markup = '';
    $tabcontent_data = drupal_json_decode(theme_get_setting('tabcontent_data'));
    $tabcontent_data = array_chunk($tabcontent_data, 3);
    foreach ($tabcontent_data as $key => $data) {
        $title_markup .= format_string($title_template, array(
          '@title' => $data[0]['value'],
          '@title' => $data[0]['value'],
          '@subtitle' => $data[1]['value'],
          '@description' => $data[2]['value']
          )
        );
    }
  }
  $button_control = '<div class="control"><a class="add-content" href="#">'. t('Add Content Tab') .'</a></div>';
  $form['md_make_settings']['design']['ds_maintenance']['pages_content']['wrap'] = array(
    '#type' => 'markup',
    '#markup' => $button_control .'<div id="url-accordion" class="wrap-accordion">' . $title_markup . '</div>',
    '#prefix' => '<div class="form-group">',
    '#suffix' => '</div>',
  );
  $form['md_make_settings']['design']['ds_maintenance']['pages_content']['tabcontent_data'] = array(
    '#type' => 'hidden',
    '#attributes' => array(
      'class' => array('content-data'),
    ),
    '#default_value' => theme_get_setting('tabcontent_data') ? theme_get_setting('tabcontent_data') : ''
  ) ;
	
	
	
  //////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////// Page 404 //////////////////////////////
  //////////////////////////////////////////////////////////////////////////////
  $form['md_make_settings']['design']['ds_notfound'] = array(
    '#type' => 'fieldset',
    '#weight' => 1,
    '#prefix' => '<div id="ds-not-found"><div class="md-tabcontent-row">',
    '#suffix' => '    </div></div><!-- / #ds-general -->',
  );
  $form['md_make_settings']['design']['ds_notfound']['text_page404'] = array(
    '#type' => 'fieldset',
    '#weight' => 1,
    '#prefix' => '<h3 class="md-tabcontent-title">Text Page 404 </h3>',
    '#collapsible' => TRUE
  );
  $form['md_make_settings']['design']['ds_notfound']['text_page404']['not_found_title'] = array(
    '#type' => 'textfield',
    '#title' => t('Title'),
    '#default_value' => theme_get_setting('not_found_title'),
    '#attributes' => array(
      'class' => array('input-border big')
    ),
    '#prefix' => '<div class="form-group">',
    '#suffix' => '</div>',
  );
  $form['md_make_settings']['design']['ds_notfound']['text_page404']['not_found_body'] = array(
    '#type' => 'textarea',
    '#title' => t('Content'),
    '#resizable' => FALSE,
    '#rows' => 5,
    '#default_value' => theme_get_setting('not_found_body'),
    '#description' => t('The following text will be added in page 404.'),
    '#attributes' => array(
      'class' => array('input-border')
    )
  );

  // Background Page 404 setting
  $form['md_make_settings']['design']['ds_notfound']['background_page404'] = array(
    '#type' => 'fieldset',
    '#weight' => 3,
    '#prefix' => '<h3 class="md-tabcontent-title">Background Page 404 Image</h3>',
    '#collapsible' => TRUE
  );

  $form['md_make_settings']['design']['ds_notfound']['background_page404']['background_page404_image'] = array(
    '#type' => 'hidden',
    '#prefix' => '<div class="wrap-form-media"><h3>Background Page 404 Image</h3><div class="media-preview"></div>',
    '#suffix' => '<div class="media-control"><a href="#" class="media-change md-button">Change</a><a href="#" class="media-delete md-button gray">Delete</a></div></div>',
    '#attributes' => array(
      'class' => array('input-fid')
    ),
    '#default_value' => theme_get_setting('background_page404_image'),
  );


  // Logo Page 404 setting
  $form['md_make_settings']['design']['ds_notfound']['logo_page404'] = array(
    '#type' => 'fieldset',
    '#weight' => 3,
    '#prefix' => '<h3 class="md-tabcontent-title">Logo Page 404 Image</h3>',
    '#collapsible' => TRUE
  );

  $form['md_make_settings']['design']['ds_notfound']['logo_page404']['default_logo_page404'] = array(
    '#type' => 'checkbox',
    '#field_suffix' => '<label class="label-checkbox" for="edit-default-logo-page404' . '">Use the default logo</label>',
    '#attributes' => array(
      'class' => array('input-checkbox')
    ),
    '#prefix' => '<div class="form-elements">',
    '#suffix' => '</div>',
    '#default_value' => theme_get_setting('default_logo_page404'),
    '#tree' => FALSE,
    '#description' => t('Check here if you want the theme to use the logo supplied with it.')
  );
  $form['md_make_settings']['design']['ds_notfound']['logo_page404']['settings_page404'] = array(
    '#type' => 'container',
    '#states' => array(
      // Hide the logo settings when using the default logo.
      'invisible' => array(
        'input[name="default_logo_page404"]' => array('checked' => TRUE),
      ),
    ),
  );

  $form['md_make_settings']['design']['ds_notfound']['logo_page404']['settings_page404']['logo_page404_image'] = array(
    '#type' => 'hidden',
    '#prefix' => '<div class="wrap-form-media"><h3>Logo Page 404 Image</h3><div class="media-preview"></div>',
    '#suffix' => '<div class="media-control"><a href="#" class="media-change md-button">Change</a><a href="#" class="media-delete md-button gray">Delete</a></div></div>',
    '#attributes' => array(
      'class' => array('input-fid')
    ),
    '#default_value' => theme_get_setting('logo_page404_image'),
  );

}
