(function ($) {
    var MaintenanceContent;

    MaintenanceContent = function (select, context) {
        var $select = $(select, context),
            self = this;
        this.init = function() {
            self.initAcordion();
            self.updateData();
            self.changeData();
            self.addcontent();
        }

        this.initAcordion = function() {
            $select.find('.wrap-accordion').accordion();
        }

        this.updateData = function() {
            var dataJson = $select.find('.content-data').val(),
                dataArray = $.parseJSON(dataJson);
                if (dataArray != undefined && dataArray != null) {
                    $select.find('.wrap-accordion').find(':input').each(function(index, value){
                        if (dataArray[index]['value'] != undefined){
                            $(this).val(dataArray[index]['value']);
                        }
                    });
                }
        }
        this.changeData = function() {
            $select.find('.wrap-accordion').delegate(':input', 'change', function() {
                var dataArray = $select.find('.wrap-accordion').find(':input').serializeArray(),
                    dataJson = JSON.stringify(dataArray);
                $select.find('.content-data').val(dataJson);
            });
        }

        this.addcontent = function() {
            var template = '<h3>Content title: </h3>';
                template += '<div><div class="content"><span>Title: </span> <input type="text" name="title" value=""></div>';
                template += '<div class="content"><span>Subtitle : </span> <input type="text" name="subtitle" value=""></div>';
                template += '<div class="content"><span>Description : </span> <textarea class="input-border form-textarea" name="description" cols="60" rows="5"></textarea></div></div>';

            $select.find('.add-content').click(function(event){
                event.preventDefault();
                $select.find('.wrap-accordion').append(template);
                $select.find('.wrap-accordion').accordion( "refresh" );
            });
        }
    }

    Drupal.behaviors.MaintenanceContent = {
        attach: function (context, settings) {
            var Tabcontent = new MaintenanceContent('#maintenance-content', context);
                Tabcontent.init();
        }
    };
})(jQuery);