<?php

/**
* @file
* Default theme implementation to display a single Drupal page.
*
* The doctype, html, head and body tags are not in this template. Instead they
* can be found in the html.tpl.php template in this directory.
*
* Available variables:
*
* General utility variables:
* - $base_path: The base URL path of the Drupal installation. At the very
*   least, this will always default to /.
* - $directory: The directory the template is located in, e.g. modules/system
*   or themes/bartik.
* - $is_front: TRUE if the current page is the front page.
* - $logged_in: TRUE if the user is registered and signed in.
* - $is_admin: TRUE if the user has permission to access administration pages.
*
* Site identity:
* - $front_page: The URL of the front page. Use this instead of $base_path,
*   when linking to the front page. This includes the language domain or
*   prefix.
* - $logo: The path to the logo image, as defined in theme configuration.
* - $site_name: The name of the site, empty when display has been disabled
*   in theme settings.
* - $site_slogan: The slogan of the site, empty when display has been disabled
*   in theme settings.
*
* Navigation:
* - $main_menu (array): An array containing the Main menu links for the
*   site, if they have been configured.
* - $secondary_menu (array): An array containing the Secondary menu links for
*   the site, if they have been configured.
* - $breadcrumb: The breadcrumb trail for the current page.
*
* Page content (in order of occurrence in the default page.tpl.php):
* - $title_prefix (array): An array containing additional output populated by
*   modules, intended to be displayed in front of the main title tag that
*   appears in the template.
* - $title: The page title, for use in the actual HTML content.
* - $title_suffix (array): An array containing additional output populated by
*   modules, intended to be displayed after the main title tag that appears in
*   the template.
* - $messages: HTML for status and error messages. Should be displayed
*   prominently.
* - $tabs (array): Tabs linking to any sub-pages beneath the current page
*   (e.g., the view and edit tabs when displaying a node).
* - $action_links (array): Actions local to the page, such as 'Add menu' on the
*   menu administration interface.
* - $feed_icons: A string of all feed icons for the current page.
* - $node: The node object, if there is an automatically-loaded node
*   associated with the page, and the node ID is the second argument
*   in the page's path (e.g. node/12345 and node/12345/revisions, but not
*   comment/reply/12345).
*
* Regions:
* - $page['help']: Dynamic help text, mostly for admin pages.
* - $page['highlighted']: Items for the highlighted content region.
* - $page['content']: The main content of the current page.
* - $page['sidebar_first']: Items for the first sidebar.
* - $page['sidebar_second']: Items for the second sidebar.
* - $page['header']: Items for the header region.
* - $page['footer']: Items for the footer region.
*
* @see template_preprocess()
* @see template_preprocess_page()
* @see template_process()
* @see html.tpl.php
*
* @ingroup themeable
*/
?>

<div id="page-wrapper">

  
  <div class="topnav fixed-topnav <?php print $menu_header_style ?>">
        <?php if ($site_name || $site_slogan): ?>
          <div id="name-and-slogan">
              <?php if ($site_name): ?>
                <?php if ($title): ?>
                  <div id="site-name"><strong>
                          <a href="<?php print $front_page; ?>" title="<?php print t('Home'); ?>" rel="home"><span><?php print $site_name; ?></span></a>
                      </strong></div>
                <?php else: /* Use h1 when the content title is empty */ ?>
                  <h1 id="site-name">
                      <a href="<?php print $front_page; ?>" title="<?php print t('Home'); ?>" rel="home"><span><?php print $site_name; ?></span></a>
                  </h1>
                <?php endif; ?>
              <?php endif; ?>

              <?php if ($site_slogan): ?>
                <div id="site-slogan"><?php print $site_slogan; ?></div>
              <?php endif; ?>
          </div> <!-- /#name-and-slogan -->
        <?php endif; ?>

        <?php if (theme_get_setting('region_detail_width') == 'half_width'): ?>
          <div class="section header-info">
        <?php else: ?>
          <div class="section header-info header-info-toggle">
        <?php endif; ?>
            <div class="nav-hold clearfix <?php print $header_container ?>">
              <?php if ($page['header_first']): ?>
                <?php if (theme_get_setting('header_info') == 'yes'): ?>
                  <?php if (theme_get_setting('region_detail_width') == 'half_width'): ?>
                    <address class="contact-info pull-left">
                        <?php print render($page['header_first']); ?>
                    </address>
                  <?php else: ?>
                    <address class="contact-info">
                        <?php print render($page['header_first']); ?>
                    </address>
                  <?php endif; ?>
                <?php endif; ?>
              <?php endif; ?>
              <?php if ($page['header_second']): ?>
                <?php if (theme_get_setting('header_detail') == 'yes'): ?>
                  <?php if (theme_get_setting('region_detail_width') == 'half_width'): ?>
                    <div class="region_detail pull-right">
                        <?php print render($page['header_second']); ?>
                    </div>
                  <?php else: ?>
                    <div class="header_index">
                        <?php print render($page['header_second']); ?>
                    </div>
                  <?php endif; ?>
                <?php endif; ?>
              <?php endif; ?>
            </div>
          </div>
        <div class="section section_header">
            <div id="topbar-hold" class="nav-hold <?php print $header_container ?>">
                <nav class="navbar">
                    <?php if ($logo): ?>
                      <div class="navbar-header">
                          <a href="<?php print $front_page; ?>" title="<?php print t('Home'); ?>" rel="home" id="logo">
                              <img src="<?php print $logo; ?>" alt="<?php print t('Home'); ?>" />
                          </a>
                      </div>
                    <?php endif; ?>
                    <?php print render($page['header']); ?>
                </nav>
            </div>
        </div>
    </div>

  <div id="main-wrapper" class="main_section_normal clearfix">
    <div class="md-body">
      <div class="container">
          <div id="content">
            <?php print $messages; ?>
            <?php if ($page['highlighted']): ?><div id="highlighted"><?php print render($page['highlighted']); ?></div><?php endif; ?>
            <a id="main-content"></a>
            <?php print render($title_prefix); ?>
            <?php print render($title_suffix); ?>
            <?php if ($tabs): ?><div class="tabs"><?php print render($tabs); ?></div><?php endif; ?>
            <?php print render($page['help']); ?>
            <?php if ($action_links): ?><ul class="action-links"><?php print render($action_links); ?></ul><?php endif; ?>
            <?php print render($page['content']); ?>
            <?php print $feed_icons; ?>
        </div>
      </div>  
    </div>
  </div>
  <?php print render($page['sheet_bottom']); ?>
	
  <?php if ($page['footer']): ?>
    <footer>
			<div class='section-footer footer-wrap'>
					<div class="container footer">
							<div class="row">
									<?php print render($page['footer']); ?>
							</div>
					</div>
			</div>
    </footer>
		<?php endif; ?>
	<?php if ($page['copyright']): ?>
		<div class='copyright-footer'>
			<?php print render($page['copyright']); ?>
		</div>
	<?php endif; ?>

</div>
