<?php

/**
 * @file
 * Default theme implementation to display a single Drupal page while offline.
 *
 * All the available variables are mirrored in html.tpl.php and page.tpl.php.
 * Some may be blank but they are provided for consistency.
 *
 * @see template_preprocess()
 * @see template_preprocess_maintenance_page()
 *
 * @ingroup themeable
 */
global $base_url;
$path_theme = drupal_get_path('theme', 'md_make');
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="<?php print $language->language ?>" lang="<?php print $language->language ?>" dir="<?php print $language->dir ?>">

<head>
  <title><?php print $title; ?></title>	
  <?php print $head; ?>
  <?php print $styles; ?>
  <?php print $scripts; ?>
</head>
<body class="coming-soon coming-map <?php print $classes; ?>">
	
			<?php print $preload; ?>
			<?php if (!empty($messages)): print $messages; endif; ?>
	
			<div class="map-container">
					<div id="map" data-location="<?php print theme_get_setting('maintenance_map_location');?>"></div>
			</div>
			
			<div class="coming-container">
				<!-- BEGIN LOGIN BOX -->
				<!-- Social Links -->
				<div class="padding-top-200">
				</div>
				<nav class="social-nav clearfix">
					<?php
							$block_view = module_invoke('bean', 'block_view', 'bean-list-social');
							print render($block_view['content']);
					?>
				</nav>
				<!-- Site Logo -->
				<?php if ($logo): ?>
				<div id="logo">
						<a href="<?php print $base_path; ?>" title="<?php print t('Home'); ?>" rel="home">
						<img src="<?php print $logo; ?>" alt="<?php print t('Home'); ?>" />
					</a>
				</div>
				<?php endif; ?>
				
				<?php if (!empty($site_name) || !empty($site_slogan)): ?>
					<div id="name-and-slogan">
						<?php if (!empty($site_name)): ?>
						<h1 id="site-name">
							<a href="<?php print $base_path ?>" title="<?php print t('Home'); ?>" rel="home"><span><?php print $site_name; ?></span></a>
						</h1>
						<?php endif; ?>

						<?php if (!empty($site_slogan)): ?>
						<div id="site-slogan"><?php print $site_slogan; ?></div>
						<?php endif; ?>
					</div> <!-- /name-and-slogan -->
				<?php endif; ?>
				<!-- Main Navigation -->
				<?php print $list_menutab ?>
				
				<!-- Content Info -->
				<div class="content-maintenance text-center">
					<?php print $content; ?>
				</div>
				<!-- Content Tab -->
				<div class="row content_tab clearboth">
						<div class="col-half">
								<?php print $content_tab ?>
						</div>
						<div class="col-half">
								<div id="countdown" data-time="<?php print $construction_time; ?>"></div>
						</div>
				</div>
			</div>
	

</body>
</html>