<?php

/**
 * @file
 * Default theme implementation to display a node.
 *
 * Available variables:
 * - $title: the (sanitized) title of the node.
 * - $content: An array of node items. Use render($content) to print them all,
 *   or print a subset such as render($content['field_example']). Use
 *   hide($content['field_example']) to temporarily suppress the printing of a
 *   given element.
 * - $user_picture: The node author's picture from user-picture.tpl.php.
 * - $date: Formatted creation date. Preprocess functions can reformat it by
 *   calling format_date() with the desired parameters on the $created variable.
 * - $name: Themed username of node author output from theme_username().
 * - $node_url: Direct URL of the current node.
 * - $display_submitted: Whether submission information should be displayed.
 * - $submitted: Submission information created from $name and $date during
 *   template_preprocess_node().
 * - $classes: String of classes that can be used to style contextually through
 *   CSS. It can be manipulated through the variable $classes_array from
 *   preprocess functions. The default values can be one or more of the
 *   following:
 *   - node: The current template type; for example, "theming hook".
 *   - node-[type]: The current node type. For example, if the node is a
 *     "Blog entry" it would result in "node-blog". Note that the machine
 *     name will often be in a short form of the human readable label.
 *   - node-teaser: Nodes in teaser form.
 *   - node-preview: Nodes in preview mode.
 *   The following are controlled through the node publishing options.
 *   - node-promoted: Nodes promoted to the front page.
 *   - node-sticky: Nodes ordered above other non-sticky nodes in teaser
 *     listings.
 *   - node-unpublished: Unpublished nodes visible only to administrators.
 * - $title_prefix (array): An array containing additional output populated by
 *   modules, intended to be displayed in front of the main title tag that
 *   appears in the template.
 * - $title_suffix (array): An array containing additional output populated by
 *   modules, intended to be displayed after the main title tag that appears in
 *   the template.
 *
 * Other variables:
 * - $node: Full node object. Contains data that may not be safe.
 * - $type: Node type; for example, story, page, blog, etc.
 * - $comment_count: Number of comments attached to the node.
 * - $uid: User ID of the node author.
 * - $created: Time the node was published formatted in Unix timestamp.
 * - $classes_array: Array of html class attribute values. It is flattened
 *   into a string within the variable $classes.
 * - $zebra: Outputs either "even" or "odd". Useful for zebra striping in
 *   teaser listings.
 * - $id: Position of the node. Increments each time it's output.
 *
 * Node status variables:
 * - $view_mode: View mode; for example, "full", "teaser".
 * - $teaser: Flag for the teaser state (shortcut for $view_mode == 'teaser').
 * - $page: Flag for the full page state.
 * - $promote: Flag for front page promotion state.
 * - $sticky: Flags for sticky post setting.
 * - $status: Flag for published status.
 * - $comment: State of comment settings for the node.
 * - $readmore: Flags true if the teaser content of the node cannot hold the
 *   main body content.
 * - $is_front: Flags true when presented in the front page.
 * - $logged_in: Flags true when the current user is a logged-in member.
 * - $is_admin: Flags true when the current user is an administrator.
 *
 * Field variables: for each field instance attached to the node a corresponding
 * variable is defined; for example, $node->body becomes $body. When needing to
 * access a field's raw values, developers/themers are strongly encouraged to
 * use these variables. Otherwise they will have to explicitly specify the
 * desired field language; for example, $node->body['en'], thus overriding any
 * language negotiation rule that was previously applied.
 *
 * @see template_preprocess()
 * @see template_preprocess_node()
 * @see template_process()
 *
 * @ingroup themeable
 */
 $text_five = 0;
 if (isset($content['field_rate_five']['#items'][0]['average'])){
	$text_five = $content['field_rate_five']['#items'][0]['average']; 
 } 
 $number_five = (int)$text_five * 0.05;
?>


<?php if ($view_mode == 'teaser'): ?>
	<div id="node-<?php print $node->nid; ?>" class="node-<?php print $node->nid; ?> <?php print $classes; ?> clearfix"<?php print $attributes; ?>>
	
			<div class="product-image-wrapper">
				<div class="single-product text-center">
					<div class="product-img">
						<a href="<?php print $node_url; ?>">
							<img src="<?php print file_create_url($content['product:field_images']['#items'][0]['uri'])?>" alt="<?php print render($content['product:field_images']['#items'][0]['alt']); ?>" /> 
							<?php if (isset($content['product:field_images']['#items'][1]['uri'])): ?>
								<div class="product-img-hover">
									<img src="<?php print file_create_url($content['product:field_images']['#items'][1]['uri'])?>" alt="<?php print render($content['product:field_images']['#items'][1]['alt']); ?>" /> 
								</div>
							<?php endif; ?>
						</a>
						<div class="product-overlay">
							<div class="overlay-content">  
								<div class="row">
									<div class="col-md-6 product-quickview" data-mfp-src="<?php print file_create_url($content['product:field_images']['#items'][0]['uri'])?>" data-title="<?php print $title; ?>" data-price="<?php print render($content['product:commerce_price'][0]['#markup']); ?>" data-description="<?php print render($content['body']['#items'][0]['summary']); ?>" data-rating="<?php print $number_five ?>" data-node-teaser="node-<?php print $node->nid; ?>"> 
										<i class="icon icon-eye"></i>
										<p>Quickview</p>
									</div>
									<div class="col-md-6 shop_teaser_wishlist">
										<?php if(user_is_logged_in()) : ?>
											<?php if (isset($content['flag_wishlist']['#markup'])): ?>
												<?php print render($content['flag_wishlist']['#markup']); ?>
											<?php endif; ?>
										<?php else : ?>
											<a href="<?php print base_path().'user'; ?>" class="btn-wishlist"><i class="icon icon-heart-empty"></i> <?php print t("Add to WishList") ?></a>
										<?php endif; ?>
									</div>
								</div> 
							</div>
						</div>
					</div>
					<p><a href="<?php print $node_url; ?>"><?php print $title; ?></a></p>
					<div class="product-detail">
						<div class="pull-left">
							<p class="price"><?php print render($content['product:commerce_price'][0]['#markup']); ?></p>
						</div>
						<?php if (isset($content['field_product_store'])): ?>
							<div class="pull-right product_teaser_cart">
								<?php unset($content['field_product_store'][0]['attributes']['field_size']); ?>
								<?php unset($content['field_product_store'][0]['attributes']['field_color']); ?>
								<?php print render($content['field_product_store']); ?>
							</div>
						<?php endif; ?> 
					</div>
				</div>
			</div>
			
	</div>

<?php else: ?>
	<div id="node-<?php print $node->nid; ?>" class="<?php print $classes; ?> node-full-shop-product clearfix"<?php print $attributes; ?>>
		<aside id="aside" class="sidebar-product">
      <div class="sidebar-inner">
				<div class="categories"><?php print theme('breadcrumb', array('breadcrumb'=>drupal_get_breadcrumb()));?></div>
					
				<?php print render($title_prefix); ?>
				<?php if ($title): ?><h2 class="item-name"><?php print $title; ?></h2><?php endif; ?>
				<?php print render($title_suffix); ?>
				
        <small class="item-number"><?php print t("Article") ?> <?php print render($node->nid); ?></small>
				<div class="item-price">
					<span class="current-price"><?php print render($content['product:commerce_price']); ?></span>
					<?php if (isset($content['product:field_old_price'][0]['#markup'])): ?>
						<span class="normal-price"><?php print render($content['product:field_old_price']); ?></span>
					<?php endif; ?>
				</div>
				
				<?php if (isset($content['field_product_store'][0]['quantity'])): ?>
					<div class="shop_node_cart">
						<?php print render($content['field_product_store']); ?>
					</div>
				<?php endif; ?>
				
				<div class="shop_node_wishlist">
					<?php if(user_is_logged_in()) : ?>
              <?php if (isset($content['flag_wishlist']['#markup'])): ?>
                <?php print render($content['flag_wishlist']['#markup']); ?>
              <?php endif; ?>
            <?php else : ?>
              <a href="<?php print base_path().'user'; ?>" class="btn btn-white btn-animated"><i class="icon icon-heart-empty"></i> <?php print t("Add to WishList") ?></a>
            <?php endif; ?>
				</div>
				
				<div class="item-delivery"><?php print render($content['field_delivery_time']['#title']) ?> <?php print render($content['field_delivery_time'][0]['#markup']) ?></div>
				
			</div>
		</aside>
		
		
		<div class="item-page clearfix">		
				<div class="item-image">
					<a href="#" class="toggle-aside"><i class="icon fontello icon-menu"></i></a>
					
					<?php if (isset($content['product:field_images'])): ?>
							<?php print render($content['product:field_images']); ?>
					<?php endif; ?>
					
				</div>
		
			
        <div class="item-info clearfix">
          <div class="category-tab shop-details-tab">
						<?php if (isset($content['comments'])): ?>
							<div class="col-sm-12 text-center">
								<ul class="nav nav-tabs clearfix">
									<li class="active"><a href="#details" data-toggle="tab"><?php print t("Details") ?></a></li>
									<li><a href="#info-care" data-toggle="tab"><?php print t("Info &amp; Care") ?></a></li>
									<li><a href="#reviews" data-toggle="tab"><?php print t("Reviews") ?> (<?php print $comment_count ?>)</a></li>
								</ul>
							</div>
							<div class="tab-content">
								<div class="tab-pane fade active in" id="details" >
									<?php print render($content['body'][0]['#markup']); ?>
								</div>
								<div class="tab-pane fade" id="info-care" >
									<?php print render($content['body']['#items'][0]['summary']); ?>
								</div>
								<div class="tab-pane fade clearfix" id="reviews" >
									<div class="col-sm-12">
										<?php print render($content['comments']); ?>
									</div>
								</div>
							</div>
						<?php else: ?>
							<div class="col-sm-12 text-center">
								<ul class="nav nav-tabs clearfix">
									<li class="active"><a href="#details" data-toggle="tab"><?php print t("Details") ?></a></li>
									<li><a href="#info-care" data-toggle="tab"><?php print t("Info &amp; Care") ?></a></li>
								</ul>
							</div>
							<div class="tab-content">
								<div class="tab-pane fade active in" id="details" >
									<?php print render($content['body'][0]['#markup']); ?>
								</div>
								<div class="tab-pane fade" id="info-care" >
									<?php print render($content['body']['#items'][0]['summary']); ?>
								</div>
							</div>
						<?php endif; ?>	

					</div>
				</div>
		
		</div>
	</div>
<?php endif; ?>