<?php

/**
 * @file
 * Template to display a view as a table.
 *
 * - $title : The title of this group of rows.  May be empty.
 * - $header: An array of header labels keyed by field id.
 * - $header_classes: An array of header classes keyed by field id.
 * - $fields: An array of CSS IDs to use for each field id.
 * - $classes: A class or classes to apply to the table, based on settings.
 * - $row_classes: An array of classes to apply to each row, indexed by row
 *   number. This matches the index in $rows.
 * - $rows: An array of row items. Each row is an array of content.
 *   $rows are keyed by row number, fields within rows are keyed by field ID.
 * - $field_classes: An array of classes to apply to each field, indexed by
 *   field id, then row number. This matches the index in $rows.
 * @ingroup views_templates
 */
/*drupal_add_css(path_to_theme() . '/css/liste_circuits.css');*/
drupal_add_js(path_to_theme() . '/js/nature/liste_circuits.js');

$nodeType = NULL;

//-- recherche le type de contenu associé à la vue
if (property_exists($view, 'filter') && key_exists('type', $view->filter))
{
    foreach($view->filter['type']->value as $val)
    {
        $nodeType = $val;
        $nodeType = substr($nodeType, 10); //-- supprime le préfixe adt (clone_adt_), pour une raison "esthétique"
        break;
    }
}

//Controle de tri
if ($nodeType!='escalade'){
    ?>

    <select name="sortactiv" id="sortactiv" class="sort-control" >
          <option value="">Trier par</option>
          <option  value="longueur">Longueur - -> +</option>
          <option  value="duree">Durée - -> +</option>                     
    </select>


    <?php
}

//-- créé le lien vers la carte
if ($nodeType != NULL)
{    
    print '<div id="zone_bt_carte"><a href="/carte/'. $nodeType .'" id="btn_carte_generale" class="btn btn-default">Afficher la carte</a></div>';
}
?>

<?php 
$classListeRslts=" container";
$classEltRslt="col-xs-12 col-sm-6 col-lg-4";
//if(isset($_GET['aff_carte'])) { 
    $classListeRslts=" col-sm-7"; 
    $classEltRslt="col-xs-12 col-sm-12 col-md-12 col-lg-6";
//}


?>




<div class="row liste_circuits<?php print $classListeRslts;?>" <?php if ($classes) { print 'class="'. $classes . '" '; } ?><?php print $attributes; ?>>
    <?php
    //print_r($rows);
    ?>
    <?php foreach ($rows as $row_count => $row): ?>
    <?php
        $data = $view->result[$row_count]->field_field_adt_node_xml_data[0]['raw']['value'];
    //print_r($data);
    $xml = simplexml_load_string($data);
    $obj = $xml->obj;
    //attr id
    $idfiche = $obj->xpath('id');
    $idfiche = (string)$idfiche[0][0];
    //attr longueur
    $longueur=0;
    if(isset($view->result[$row_count]->field_field_km[0]['raw']['value'])) $longueur =$view->result[$row_count]->field_field_km[0]['raw']['value'];
    //attr duree
    //$duree=0;
    $duree = $obj->xpath('//duree_max');
    if(isset($duree[0])) $duree = $duree[0];
    if (!$duree || empty($duree))$duree=0;
    //print_r($duree);
    //attr niveau
    $niveau=0;
    if(isset($view->result[$row_count]->field_field_niveau[0]['raw']['value'])) $niveau =$view->result[$row_count]->field_field_niveau[0]['raw']['value'];
 
    ?>
    
    <div class="<?php print $classEltRslt;?> elt-activ" data-longueur="<?php print $longueur;?>" data-duree="<?php print $duree;?>" data-niveau="<?php print $niveau;?>" data-object-id="<?php print $idfiche;?>">
    <?php 
    //-- ajoute le lien vers le noeud
//$title = $row->node_title;
    $type_node = $view->result[$row_count]->_field_data[nid][entity]->type;
    $link = drupal_get_path_alias('node/' . $view->result[$row_count]->nid);
    print '<a href="/'.$link.'">';

   /*print "<pre>";
    
    print_r($view->result[$row_count]);
    
    print "</pre>";*/
    //dpm(print_r($obj, true));
    $img = $obj->xpath('obj_common/photo/ass_obj_photo[doctype="photo" and vignette=1]/fic_z');

    //print_r($idfiche);
   // print_r($img);
    if (!$img || empty($img)) $img = $obj->xpath('obj_common/photo/ass_obj_photo[doctype="photo" and type_descriptif="TECHN"]/fic_z');
   // type_descriptif
    if (!$img || empty($img)) $img = $obj->xpath('obj_common/photo/ass_obj_photo[doctype="photo"]/fic_z');
    //print_r($img);
    if ($img && !empty($img))
    {
        $img = (string) $img[0][0];
        //$output .= '<div class="liste_activites_item_img">';
       $img =  variable_get('adt_pictures_path').$img;
        //$output .= '</div>';
    }
    ?>
        <div class="activite" style="min-height:300px;/*box-shadow: 2px 2px 1px 1px #cfcfcf;*/background: url('<?php print $img;?>');background-size: cover;"  data-object-id="<?php print $idfiche;?>" data-object-type="<?php print $type_node;?>" >   
            <div class="activ_snippet">
                <?php
                print($row);
                ?> 
            </div>
        </div>
    <?php
    print('</a>');
    ?> 
    </div>
    <?php endforeach; ?>

  
</div>
<?php

//if(isset($_GET['aff_carte'])){
    
    print '<div class="col-carte-view col-xs-12 col-sm-5 ">'
    . '<div class="carte-col-container">';
    $classListeRslts=" col-sm-9";
    
    
      drupal_add_css(drupal_get_path('module', 'mapmodule') . '/css/mapmodule.css');
        drupal_add_library('system', 'ui.draggable');
        drupal_add_js(drupal_get_path('module', 'mapmodule') . '/js/geoXML3custombubble.js');
        drupal_add_js('https://www.gstatic.com/charts/loader.js', 'external');
        drupal_add_js('https://maps.googleapis.com/maps/api/js?key='. variable_get('gmapKey') .'&sensor=false&region=FR', 'external');
        
        drupal_add_js(drupal_get_path('module', 'mapmodule') . '/js/gmap.js');
             
        
        print '<div id="map_canvas" style="width:100%;height: 650px;position: wrap;overflow: hidden;" onload="initCarte()"></div>';
       // print '<div id="elevation_chart" style="width: 70%;height: 200px;position: absolute;bottom: 30px;left: 5%;z-index: 99;background-color: white;display: block;"></div>';
          
    print '</div>'
        . '</div>';
//}
?>
