<?php
    drupal_add_css(path_to_theme() . '/css/liste_etapes.css');
    
    require_once('sites/all/libraries/utils.php');
    
    if (key_exists('und', $node->field_adt_node_xml_data))
        $rawXML = $node->field_adt_node_xml_data['und'][0]['value'];
    else
        $rawXML = $node->field_adt_node_xml_data[0]['value'];
    
    $xml = new SimpleXMLElement($rawXML);
    $xml = $xml->obj;
    //dpm(print_r($xml, true));
    //dpm($node);
    
    //-- recherche les étapes du parcours
    $etapes = $xml->obj_common->obj_lien->ass_obj_lien;
    
    $output = '';
    
    $output .= '<div id="descriptif_circuit">';
    //$output .= nl2br2(nl2br((string)$xml->descriptif_fr));
    $output .= nl2br2(nl2br((string)$xml->obj_common->siteaff_desc->ass_obj_siteaff_desc->descriptif_spec));
    $output .= '</div>';
    
    $output .= '<div id="etapes" class="row liste_circuits" >';
    
    foreach($etapes as $etape)
    {
        //-- extrait l'id de l'étape
        $idEtape = (string) $etape->id_lien;
        
        //-- recherche le noeud correspondant dans drupal
        $search = db_select('field_data_' . variable_get('FIELD_ADT_NODE_ID'), 't')
                ->fields('t', array('entity_id'))
                ->condition(variable_get('FIELD_ADT_NODE_ID') . '_value', $idEtape, '=')
                ->execute()
                ->fetchObject();
        
        //-- si on a trouvé un noeud correspondant
        if ($search)
        {
            //-- extrait le nid du noeud
            $nidEtape = $search->entity_id;
            
            //-- charge le noeud
            $noeudEtape = node_load($nidEtape);
            
            //-- construit l'url vers le noeud
            $href = base_path() . drupal_lookup_path('alias', "node/" . $nidEtape);
            
            $xmlEtape = new SimpleXMLElement($noeudEtape->field_adt_node_xml_data['und'][0]['value']);
            $xmlEtape = $xmlEtape->obj;
            
            //-- affiche le titre du noeud
            $output .= '<div class="activite li_etape col-xs-12 col-sm-12 col-lg-12" style="margin:5px;/*box-shadow: 2px 2px 1px 1px #cfcfcf;*/background: url(\''.getThumbImage($xmlEtape).'\');background-size: cover;"  ><a class="lien_etape" href="'. $href .'">';
           // $output .= '<div class="image_etape">' . getThumbImage($xmlEtape) . '</div>';
            $output .= '<div class="activ_snippet"><div class="descriptif_etapes">';
            $output .= '<div class="titre_etape"><h4>'. $noeudEtape->title .'</h4></div>';
            $output .= '<div class="infos_etape">' . getInfosTechniques($xmlEtape) . '</div><br/>';
            $output .= '<div class="texte_etape">' . getTexteEtape($node, $xmlEtape) . '</div>';
            $output .= '</div></a></div></div>';
        }
    }
    
    $output .= '</div>';
    
    echo $output;
    
    
     
    /********************************************************************************/
    /********************************************************************************/
    /********************************************************************************/
    
    /**
     *  Fonctions pour extraire les données du XML ou des champs du noeud :
     */
    
    function getTexteEtape($node, $xml)
    { 
        $output = extraitTexte($node, $xml, 'field_texte_technique', 'TECHN');
        
        $output = html_entity_decode($output);  //-- garde les balises html
        $output = limitWords($output, 25);      //-- limite le nombre de mots
        $output = preg_replace('/<br \/>/iU', '', $output);    //-- supprime les sauts de ligne
        
        //-- ajoute un espace si il n'y a pas de texte pour que le div soit pris en compte
        if ($output == '') $output = '&nbsp;';
        
        return $output;
    }
    
    function extraitTexte($node, $xml, $fieldName, $typeDescriptif)
    {        
        $output = '';
        
        //-- on va chercher soit dans un champ du noeud, soit dans le xml :
        if (isset($node->{$fieldName}))
        {
            //-- on prend la valeur 'safe' si elle existe (préserve le formatage HTML)
            if (isset($node->{$fieldName}['und'][0]['safe_value']))
                $output = $node->{$fieldName}['und'][0]['safe_value'];
            else if (!empty($node->{$fieldName}))
               $output = nl2br2($node->{$fieldName}['und'][0]['value']);
            else
                return FALSE;
        }
        else if (property_exists($xml->obj_common, 'siteaff_desc'))
        {
            //-- si le champ n'existe pas, on va chercher manuellement dans le XML
            $data = $xml->xpath('obj_common/siteaff_desc/ass_obj_siteaff_desc[type_descriptif="'.$typeDescriptif.'"]/descriptif_spec');
            
            //-- retourne FALSE si la valeur n'existe pas => l'onglet ne sera pas créé
            if (!$data) return FALSE;
            
            $output = nl2br2($data[0][0]);
        }
        else
        {
            //-- retourne FALSE si le champ n'existe pas => l'onglet ne sera pas créé
            return FALSE;
        }
        
        $output = html_entity_decode($output);
        
        //-- ajoute un espace si il n'y a pas de texte pour que le div soit pris en compte
        if ($output == '') $output = '&nbsp;';
        
        return $output;
    }
    
    
    function getThumbImage($xml)
    {
       /* if (property_exists($xml->obj_common, 'photo') && property_exists($xml->obj_common->photo, 'ass_obj_photo'))
        {
            $xmlPhotos = $xml->obj_common->photo->ass_obj_photo;
            $numPhotos = count($xmlPhotos);
            
            if ($numPhotos > 0)
            {
                foreach($xmlPhotos as $xmlPhoto)
                {                    
                    if ($xmlPhoto->docsstype == 'Technique')
                    {
                        $href = $xmlPhoto->fic_o;
                        $ext = substr($href, strrpos($href, '.') + 1);
                        
                        if ($ext != 'pdf')                        
                            return '<img src="' . variable_get('adt_pictures_path') . $xmlPhoto->fic_z . '" title="' . $xmlPhoto->titre . '"/>';
                    }
                }
            }
        }*/
        
              $img = $xml->xpath('obj_common/photo/ass_obj_photo[doctype="photo" and vignette=1]/fic_o');
               print_r($img);
               if (!$img || empty($img)) $img = $xml->xpath('obj_common/photo/ass_obj_photo[doctype="photo" and type_descriptif="TECHN"]/fic_o');
              // type_descriptif
               if (!$img || empty($img)) $img = $xml->xpath('obj_common/photo/ass_obj_photo[doctype="photo"]/fic_o');
               //print_r($img);
               if ($img && !empty($img))
               {
                   $img = (string) $img[0][0];
                   //$output .= '<div class="liste_activites_item_img">';
                   $img =  variable_get('adt_pictures_path').$img;
                   //return '<img src="' . variable_get('adt_pictures_path') . $img . '" title=""/>';
                   return $img;

               }
    }
    
    function getInfosTechniques($xml)
    {
        $output = '';
        
        if (property_exists($xml, 'localite'))
        {
            $output .= '<span>Départ : <span class="info_tech_value">'. $xml->localite .'</span></span>';
        }
        
        //-- infos spécifiques aux randos :
        if (property_exists($xml->obj_common, 'obj_rap_spec'))
        {      
            //-- type de circuit
           /* if (property_exists($xml->obj_common->obj_rap_spec, 'itinérant'))
            {
                if ($xml->obj_common->obj_rap_spec->itinérant == 'itinérant')
                {
                    $output .= '<p><span class="info_tech_value">Circuit itinérant</span></p>';
                }
                else
                {
                    $output .= '<p><span class="info_tech_value">Circuit non itinérant</span></p>';
                }
            }*/
            
            //-- niveau
            /*if (property_exists($xml->obj_common->obj_rap_spec, 'niveau'))// && $xml->obj_common->obj_rap_spec->niveau != '')
            {
                $output .= '<p>Niveau de difficulté : <span class="info_tech_value">'. $xml->obj_common->obj_rap_spec->niveau .'</span></p>';
            }*/
            //-- duree
            if (property_exists($xml->obj_common->obj_rap_spec, 'duree') && $xml->obj_common->obj_rap_spec->duree != '')
            {
                $output .= '<span>Durée : <span class="info_tech_value">'. $xml->obj_common->obj_rap_spec->duree .'</span></span>';
            }
            //-- longueur
            if (property_exists($xml->obj_common->obj_rap_spec, 'longueur') && $xml->obj_common->obj_rap_spec->longueur != '')
            {
                $output .= '<span>Longueur : <span class="info_tech_value">'. $xml->obj_common->obj_rap_spec->longueur .' km</span></span>';
            }
            //-- lieu de départ
            /*if (property_exists($xml->obj_common->obj_rap_spec, 'lieu_precis_depart'))// && $xml->obj_common->obj_rap_spec->lieu_precis_depart != '')
            {
                $output .= '<p>Lieu de départ : <span class="info_tech_value">'. $xml->obj_common->obj_rap_spec->lieu_precis_depart .'</span></p>';
            }*/
        }
        
        return $output;
    }
?>
