<?php
/**
 * @file
 * Default theme implementation for field collection items.
 *
 * Available variables:
 * - $content: An array of comment items. Use render($content) to print them all, or
 *   print a subset such as render($content['field_example']). Use
 *   hide($content['field_example']) to temporarily suppress the printing of a
 *   given element.
 * - $title: The (sanitized) field collection item label.
 * - $url: Direct url of the current entity if specified.
 * - $page: Flag for the full page state.
 * - $classes: String of classes that can be used to style contextually through
 *   CSS. It can be manipulated through the variable $classes_array from
 *   preprocess functions. By default the following classes are available, where
 *   the parts enclosed by {} are replaced by the appropriate values:
 *   - entity-field-collection-item
 *   - field-collection-item-{field_name}
 *
 * Other variables:
 * - $classes_array: Array of html class attribute values. It is flattened
 *   into a string within the variable $classes.
 *
 * @see template_preprocess()
 * @see template_preprocess_entity()
 * @see template_process()
 */

	$bundle = explode("|", $content['field_social']['#items'][0]['icon']);
	$icon = array(
	  '#theme' => 'icon',
	  '#bundle' => $bundle[0],
	  '#icon' => $bundle[1],
	);
	
?>
<button type="button" class="btn btn-xs btn-icon btn-rounded btn-white" href="<?php print render($content['field_social']['#items'][0]['link'])?>" data-rel="tooltip" data-toggle="tooltip" data-placement="bottom" data-original-title="<?php print render($content['field_tooltip'][0]['#markup'])?>"><?php print render($icon); ?></button>
