<?php

/**
 * @file
 * Default theme implementation to display a block.
 *
 * Available variables:
 * - $block->subject: Block title.
 * - $content: Block content.
 * - $block->module: Module that generated the block.
 * - $block->delta: An ID for the block, unique within each module.
 * - $block->region: The block region embedding the current block.
 * - $classes: String of classes that can be used to style contextually through
 *   CSS. It can be manipulated through the variable $classes_array from
 *   preprocess functions. The default values can be one or more of the
 *   following:
 *   - block: The current template type, i.e., "theming hook".
 *   - block-[module]: The module generating the block. For example, the user
 *     module is responsible for handling the default user navigation block. In
 *     that case the class would be 'block-user'.
 * - $title_prefix (array): An array containing additional output populated by
 *   modules, intended to be displayed in front of the main title tag that
 *   appears in the template.
 * - $title_suffix (array): An array containing additional output populated by
 *   modules, intended to be displayed after the main title tag that appears in
 *   the template.
 *
 * Helper variables:
 * - $classes_array: Array of html class attribute values. It is flattened
 *   into a string within the variable $classes.
 * - $block_zebra: Outputs 'odd' and 'even' dependent on each block region.
 * - $zebra: Same output as $block_zebra but independent of any block region.
 * - $block_id: Counter dependent on each block region.
 * - $id: Same output as $block_id but independent of any block region.
 * - $is_front: Flags true when presented in the front page.
 * - $logged_in: Flags true when the current user is a logged-in member.
 * - $is_admin: Flags true when the current user is an administrator.
 * - $block_html_id: A valid HTML ID and guaranteed unique.
 *
 * @see template_preprocess()
 * @see template_preprocess_block()
 * @see template_process()
 *
 * @ingroup themeable
 */
?>
<?php if ($block->module == 'md_megamenu'): ?>
  <?php print $content ?>

	

<?php elseif(isset($select_block_type) && $select_block_type == 4):?>
	<div id="<?php print $block_html_id; ?>" class="col-md-3 <?php print $classes; ?>"<?php print $attributes; ?>>
	  <?php print render($title_prefix); ?>
	  <?php print render($title_suffix); ?>
		  	<?php if ($block->subject): ?>
					<h4><?php print $block->subject ?></h4>
				<?php endif;?>
          <?php print $content ?>
	</div>

<?php elseif(isset($select_block_type) && $select_block_type == 3):?>
	<div id="<?php print $block_html_id; ?>" class="col-md-5 <?php print $classes; ?>"<?php print $attributes; ?>>
	  <div class="inline-form">
		  <?php print render($title_prefix); ?>
		  <?php print render($title_suffix); ?>
	    <?php print $content; ?>
	  </div>
	</div>

<?php elseif(isset($select_block_type) && $select_block_type == 2):?>
	<div id="<?php print $block_html_id; ?>" class="container <?php print $classes; ?>"<?php print $attributes; ?>>
	  <?php print render($title_prefix); ?>
	  <?php print render($title_suffix); ?>
	  <div class="top-text fade-text">
		  	<?php if ($block->subject): ?>
					<h1 class="header-title text-left"><?php print $block->subject ?></h1>
				<?php endif;?>
          <p class="header-message"><?php print $content ?></p>
    </div>
	</div>
<?php elseif(isset($select_block_type) && $select_block_type == 1):?>
	<div id="<?php print $block_html_id; ?>" class="widget <?php print $classes; ?>"<?php print $attributes; ?>>
	  <?php print render($title_prefix); ?>
	  <?php print render($title_suffix); ?>
		<?php if ($block->subject): ?>
			<h4 class="widget-title"><?php print $block->subject ?></h4>
		<?php endif;?>
	  
	  <?php print $content ?>
	</div>
<?php else:?>
	<div id="<?php print $block_html_id; ?>" class="<?php print $classes; ?>"<?php print $attributes; ?>>
	  <?php print render($title_prefix); ?>
		<?php if ($block->subject): ?>
			<h2<?php print $title_attributes; ?>><?php print $block->subject ?></h2>
		<?php endif;?>
	  <?php print render($title_suffix); ?>

	  <?php print $content ?>

	</div>

	
<?php endif;?>