<?php
/**
 * @file
 * Default theme implementation for beans.
 *
 * Available variables:
 * - $content: An array of comment items. Use render($content) to print them all, or
 *   print a subset such as render($content['field_example']). Use
 *   hide($content['field_example']) to temporarily suppress the printing of a
 *   given element.
 * - $title: The (sanitized) entity label.
 * - $url: Direct url of the current entity if specified.
 * - $page: Flag for the full page state.
 * - $classes: String of classes that can be used to style contextually through
 *   CSS. It can be manipulated through the variable $classes_array from
 *   preprocess functions. By default the following classes are available, where
 *   the parts enclosed by {} are replaced by the appropriate values:
 *   - entity-{ENTITY_TYPE}
 *   - {ENTITY_TYPE}-{BUNDLE}
 *
 * Other variables:
 * - $classes_array: Array of html class attribute values. It is flattened
 *   into a string within the variable $classes.
 *
 * @see template_preprocess()
 * @see template_preprocess_entity()
 * @see template_process()
 */
global $base_url;
$display_style = $content['field_social_style'][0]['#markup'];
$class_icon = '';
if ($display_style == 'Square') {
  $class_icon = 'social-square';
}
$icon_obj = $content['field_social_icon']['#items'];
$count = count($icon_obj);
$link_icon = '#';
$delay = 300;
?>
<div class="<?php print $classes; ?> clearfix"<?php print $attributes; ?>>
    <div class="content"<?php print $content_attributes; ?>>
        <?php if (isset($content['field_logo_social'])) : ?>
          <h4 class="footer-title">
              <!-- Footer Title -->
              <a class="site-name" href="<?php print $base_url; ?>">
                  <img src="<?php print file_create_url($content['field_logo_social']['#items'][0]['uri']);?>" alt="logo" class="animated" data-animation="fadeInUp" data-animation-delay="200">
              </a>
          </h4>
        <?php endif; ?>
        <div class="social-icons <?php print $class_icon; ?>">
            <ul class="text-left">
                <?php for ($i = 0; $i < $count; $i++): ?>
                  <?php
                  if (isset($icon_obj[$i]['link'])): $link_icon = $icon_obj[$i]['link'];
                  endif;
                  ?>
                  <li>
                      <a href="<?php print $link_icon; ?>" target="_blank" class="animated" data-animation="fadeIn" data-animation-delay="<?php print $delay; ?>">
                          <?php
                          $bundle = explode("|", $content['field_social_icon']['#items'][$i]['icon']);
                          $icon = array(
                            '#theme' => 'icon',
                            '#bundle' => $bundle[0],
                            '#icon' => $bundle[1],
                          );
                          print render($icon);
                          $delay = $delay + 200;
                          ?>
                      </a>
                  </li>
                <?php endfor; ?>
            </ul>
        </div>
    </div>
</div>



