<?php
/**
 * @file
 * Default theme implementation for beans.
 *
 * Available variables:
 * - $content: An array of comment items. Use render($content) to print them all, or
 *   print a subset such as render($content['field_example']). Use
 *   hide($content['field_example']) to temporarily suppress the printing of a
 *   given element.
 * - $title: The (sanitized) entity label.
 * - $url: Direct url of the current entity if specified.
 * - $page: Flag for the full page state.
 * - $classes: String of classes that can be used to style contextually through
 *   CSS. It can be manipulated through the variable $classes_array from
 *   preprocess functions. By default the following classes are available, where
 *   the parts enclosed by {} are replaced by the appropriate values:
 *   - entity-{ENTITY_TYPE}
 *   - {ENTITY_TYPE}-{BUNDLE}
 *
 * Other variables:
 * - $classes_array: Array of html class attribute values. It is flattened
 *   into a string within the variable $classes.
 *
 * @see template_preprocess()
 * @see template_preprocess_entity()
 * @see template_process()
 */
$welcome_text = '';
if (isset($content['field_welcome_text'])) {
  $welcome_text = render($content['field_welcome_text']);
}

$message = '';
if (isset($content['field_intro_message'])) {
  $message = render($content['field_intro_message']);
}
$style = $content['field_header_style'][0]['#markup'];

$background_img_url = '';
if (isset($content['field_background_image'])) {
  $background_img_url = file_create_url($content['field_background_image'][0]['file']['#item']['uri']);
}
if (isset($content['field_background_image'])) {
  $background_img_url = file_create_url($content['field_background_image'][0]['file']['#item']['uri']);
}

$video_bg_url = '';
if (isset($content['field_header_video']) && ($style == 'Video background' || $style == 'Video Background with Play Button' )) {
  $video_bg_url = file_create_url($content['field_header_video'][0]['file']['#uri']);
}
?>
<?php if ($style == 'Default'): ?>
  <!-- Begin Default -->
 <header class="center header-md parallax" data-img="<?php print $background_img_url; ?>">
      <div class="section-overlay"></div>
      <div class="container">
        <div class="top-text f-left">
          <h1 class="header-title text-left"><?php print $welcome_text; ?></h1>
          <p class="header-message text-left"><?php print $message; ?></p>
        </div>
      </div>
    </header>
  <!-- End Header Default -->
  
<?php elseif ($style == 'Animation background'): ?>
  <!-- Begin Animation Background Full Height -->
  <header class="height-full" data-img="<?php print $background_img_url; ?>" id="large-header">
      <canvas id="demo-canvas"></canvas>
      <div class="container top-element">
          <div class="row top-text fade-text">
              <h1 class="well-come"><?php print $welcome_text; ?></h1>
              <div class="col-md-8 col-md-offset-2">
                  <div class="intro-message"><?php print $message; ?></div>
                  <?php print(render($content['field_button'])); ?>
              </div>
          </div>
      </div>
      <div class="scroll-down next-section"><span></span></div>
  </header>
  <!-- End Header Video Full Height -->

<?php elseif ($style == 'Parallax') : ?>

  <!-- Begin Header Parallax Image -->
  <header class=" header-lg center parallax" data-img="<?php print $background_img_url; ?>">
      <div class="section-overlay overlay-9"></div>
      <div class="container top-element">
          <div class="row fade-text">
              <h1 class="well-come"><?php print $welcome_text; ?></h1>
              <div class="col-md-8 col-md-offset-2">
                  <div class="intro-message"><?php print $message; ?></div>
                  <?php print(render($content['field_button'])); ?>
              </div>
          </div>
      </div>
  </header>
  <!-- End Header Parallax Image  -->

<?php elseif ($style == 'Text Rotator') : ?>
  <!-- Text Rotator -->
  <header class="height-full center parallax" data-img="<?php print $background_img_url; ?>">
      <div class="section-overlay overlay-9"></div>
      <div class="container top-element">
          <div class="row top-text fade-text">
              <div class="intro-message m-t-0 uppercase m-b-100"><?php print $message; ?> </div>
              <h1 class="well-come rotate-text f-60 m-b-100" data-speed="2500"><?php print $welcome_text; ?></h1>
              <div class="col-md-8 col-md-offset-2 m-t-10">
                  <?php print(render($content['field_button'])); ?>
              </div>
          </div>
      </div>
      <div class="scroll-down next-section" id="go-down"><span></span></div>
  </header>
  <!-- End Text Rotator -->
<?php elseif ($style == 'Video background') : ?>

  <!-- Begin Header Video Full Height -->
  <header class="height-full center" data-img="<?php print $background_img_url; ?>">
      <div class="video-player mb_YTPlayer" data-property="{videoURL:'<?php print $video_bg_url; ?>', containment:'.height-full', startAt:0, mute:false, autoPlay:true, loop:true, opacity:1, showControls:false, showYTLogo:false, vol:25}"></div>
      <div class="container top-element">
          <div class="row top-text fade-text">
              <h1 class="well-come"><?php print $welcome_text; ?></h1>
              <div class="col-md-8 col-md-offset-2">
                  <div class="intro-message"><?php print $message; ?></div>
                  <?php print(render($content['field_button'])); ?>
              </div>
          </div>
      </div>
      <div class="scroll-down next-section"><span></span></div>
  </header>
  <!-- End Header Video Full Height -->

<?php elseif ($style == 'Parallax Full Height') : ?>
  <header class="height-full center parallax" data-img="<?php print $background_img_url; ?>">
      <div class="section-overlay"></div>
      <div class="container top-element">
        <div class="row top-text fade-text">
          <h1 class="well-come"><?php print $welcome_text; ?></h1>
          <div class="col-md-8 col-md-offset-2">
            <div class="intro-message"><?php print $message; ?></div>
            <?php print(render($content['field_button'])); ?>
          </div>
        </div>
      </div>
      <div class="scroll-down next-section"><span></span></div>
    </header>
    <!-- End Header Parallax Image Full Height -->

  <?php elseif ($style == 'Video Background with Play Button') : ?>
  <!-- Begin Header Video Full Height -->
  <header class="height-full center" data-img="<?php print $background_img_url; ?>">
      <div class="video-player mb_YTPlayer" data-property="{videoURL:'<?php print $video_bg_url; ?>', containment:'.height-full', startAt:0, mute:false, autoPlay:false, loop:true, opacity:1, showControls:false, showYTLogo:false, vol:25}"></div>
      <div class="container top-element">
          <div class="row top-text fade-text">
              <h1 class="well-come"><?php print $welcome_text; ?></h1>
              <div class="col-md-8 col-md-offset-2">
                  <div class="video-control">
                      <div id="play-video" class="icon-control-play"></div>
                  </div>
                  <div class="intro-message"><?php print $message; ?></div>
                  <?php print(render($content['field_button'])); ?>
              </div>
          </div>
      </div>
      <div class="scroll-down next-section"><span></span></div>
  </header>
  <!-- End Header Video Full Height -->
  
<?php else : ?>

<?php endif; ?>
<div class="<?php print $classes; ?> clearfix"<?php print $attributes; ?>>

    <div class="content"<?php print $content_attributes; ?>>
        <?php
        //print render($content);
        ?>
    </div>
</div>