<?php

/**
 * @file
 * This file is empty by default because the base theme chain (Alpha & Omega) provides
 * all the basic functionality. However, in case you wish to customize the output that Drupal
 * generates through Alpha & Omega this file is a good place to do so.
 * 
 * Alpha comes with a neat solution for keeping this file as clean as possible while the code
 * for your subtheme grows. Please read the README.txt in the /preprocess and /process subfolders
 * for more information on this topic.
 * */
 
 //Definition des constantes
global $base_url;
define('BASEURL', $base_url);
define('THEMEURL', base_path().drupal_get_path('theme', 'md_make') . '/');
define('IMAGESURL', THEMEURL . 'images/nature/');

include_once './' . drupal_get_path('theme', 'md_make') . '/theme_setting/front/html.preprocess.inc';
include_once './' . drupal_get_path('theme', 'md_make') . '/theme_setting/front/page.preprocess.inc';
include_once './' . drupal_get_path('theme', 'md_make') . '/theme_setting/front/function.theme.inc';
include_once './' . drupal_get_path('theme', 'md_make') . '/theme_setting/front/node.preprocess.inc';

/* * ************************************************************************************************
 * JQUERY
 * Add/ Remove JS
 * *********************************************************************************************** */

function md_make_js_alter(&$js) {
  unset($js[drupal_get_path('module', 'views_infinite_scroll') . '/js/jquery.autopager-1.0.0.js']);
  unset($js[drupal_get_path('module', 'views_infinite_scroll') . '/js/views_infinite_scroll.js']);
}

// add js, css to view

function md_make_preprocess_views_view(&$vars) {
  $view = $vars['view'];

  $vars['blog_list'] = '';
  (theme_get_setting('chosse_blog_list') == 'classic' ) ? $vars['blog_list'] = 'classic' : ((theme_get_setting('chosse_blog_list') == 'masonry') ? $vars['blog_list'] = 'masonry' : $vars['blog_list'] = 'grid');

  drupal_add_js(drupal_get_path('module', 'adt21_engine')."/js/readmore.min.js"); 

  // CHECK PORTFOLIO COLUMN
  $vars['num_col'] = '';
  switch ($view->current_display) {
    case 'portfolio_2_col' :
      $vars['num_col'] = '2';
      break;
    case 'portfolio_3_col' :
      $vars['num_col'] = '3';
      break;
    case 'portfolio_4_col' :
      $vars['num_col'] = '4';
      break;
    case 'portfolio_5_col' :
      $vars['num_col'] = '5';
      break;
    default :
      $vars['num_col'] = '3';
  }

  $view = $vars['view'];
  if ($view->query->pager->plugin_name == 'infinite_scroll' && $view->total_rows > 0 && $view->total_rows > $view->query->limit) {
    drupal_add_js(path_to_theme() . '/js/libs/view_load/jquery.autopager-1.0.0.js');
    drupal_add_js(path_to_theme() . '/js/libs/view_load/imagesloaded.min.js');
    drupal_add_js(path_to_theme() . "/js/libs/view_load/views_infinite_scroll.js", array('type' => 'file', 'scope' => 'footer'));
  }

  /*   * ************************************************************************************************
   * THEME GET SETTING PORFOLIO
   * *********************************************************************************************** */
  $vars['portfolio_space'] = 'no-space';
  if (theme_get_setting('portfolio_space') == 0) {
    $vars['portfolio_space'] = 'no-space';
  }
  else {
    $vars['portfolio_space'] = '';
  }
  if (theme_get_setting('portfolio_style') == TRUE) {
    $vars['portfolio_num'] = theme_get_setting('portfolio_boxed_col');
  }
  else {
    $vars['portfolio_num'] = theme_get_setting('portfolio_wide_col');
  }

  if (theme_get_setting('portfolio_style') == TRUE) {
    $vars['portfolio_style'] = 'BOXED';
  }
  else {
    $vars['portfolio_style'] = 'WIDE';
  }
}

/* * ************************************************************************************************
 * Preprocess Views list
 * *********************************************************************************************** */

function md_make_preprocess_views_view_list(&$vars) {
  $view = $vars['view'];
  if ($view->name == 'portfolio' || $view->name == 'portfolio_space') {
    $vars['grid_select'] = variable_get($view->name . '-' . $view->current_display . '_select_layout');
  }
}

/* * ************************************************************************************************
 * Preprocess FIELD
 * *********************************************************************************************** */

function md_make_preprocess_field(&$vars) {
  if ($node = menu_get_object()) {
    $vars['node'] = $node;
    if ($node->type == 'portfolio') {
      $display_get = field_get_items('node', $node, 'field_display_style');
      $vars['display_style'] = field_view_value('node', $node, 'field_display_style', $display_get[0]);
    }
  }
}

/* * ************************************************************************************************
 * THEME FIELD
 * *********************************************************************************************** */

function md_make_field($vars) {
  $output = '';

  // PORTFOLIO FIELD
  if ($vars['element']['#field_name'] == 'field_objective' || $vars['element']['#field_name'] == 'field_date' || $vars['element']['#field_name'] == 'field_client') {
    // Render the label, if it's not hidden.
    if (!$vars ['label_hidden']) {
      $output .= '<h4 class="section-title">' . $vars ['label'] . '&nbsp;</h4>';
    }
    // Render the items.
    foreach ($vars ['items'] as $delta => $item) {
      $classes = 'field-item ' . ($delta % 2 ? 'odd' : 'even');
      $output .= '<div class="' . $classes . '"' . $vars ['item_attributes'][$delta] . '>' . drupal_render($item) . '</div>';
    }
    // Render the top-level DIV.
    $output = '<div class="' . $vars ['classes'] . '"' . $vars ['attributes'] . '>' . $output . '</div>';
    return $output;
  }

  // THEME BODY FIELD ON NODE.TPL.PHP ( DIFFERENT CLASS LABEL )
  elseif ($vars['element']['#field_name'] == 'body') {
    // Render the label, if it's not hidden.
    if (!$vars ['label_hidden']) {
      if (isset($vars['display_style']['#markup'])) {
        if ($vars['display_style']['#markup'] == 'Fixed Text') {
          $output .= '<h4 class="section-title m-t-0 p-t-0">' . $vars ['label'] . '&nbsp;</h4>';
        }
        elseif ($vars['display_style']['#markup'] == 'Small slider') {
          $output .= '<h4 class = "section-title">' . $vars ['label'] . '&nbsp;</h4>';
        }
        else {
          $output .= '<h3 class="section-title">' . $vars ['label'] . '&nbsp;</h3>';
        }
      }
    }

    // Render the items.
    foreach ($vars ['items'] as $delta => $item) {
      $classes = 'field-item ' . ($delta % 2 ? 'odd' : 'even');
      $output .= '<div class="' . $classes . '"' . $vars ['item_attributes'][$delta] . '>' . drupal_render($item) . '</div>';
    }
    // Render the top-level DIV.
    $output = '<div class="' . $vars ['classes'] . '"' . $vars ['attributes'] . '>' . $output . '</div>';
    return $output;
  }
  else {
    // DEFAUTL FIELD
    // Render the label, if it's not hidden.
    if (!$vars ['label_hidden']) {
      $output .= '<div class="field-label"' . $vars ['title_attributes'] . '>' . $vars ['label'] . ':&nbsp;</div>';
    }

    // Render the items.
    $output .= '<div class="field-items"' . $vars ['content_attributes'] . '>';
    foreach ($vars ['items'] as $delta => $item) {
      $classes = 'field-item ' . ($delta % 2 ? 'odd' : 'even');
      $output .= '<div class="' . $classes . '"' . $vars ['item_attributes'][$delta] . '>' . drupal_render($item) . '</div>';
    }
    $output .= '</div>';

    // Render the top-level DIV.
    $output = '<div class="' . $vars ['classes'] . '"' . $vars ['attributes'] . '>' . $output . '</div>';

    return $output;
  }
}

//function md_make_form_alter(&$form, &$form_state, $form_id){
//
//}

/* * ************************************************************************************************
 * CSS
 * Add/ Remove Css
 * *********************************************************************************************** */
function md_make_css_alter(&$css) {
  unset($css[drupal_get_path('module', 'fontello') . '/css/fontello.fix.css']);
}

// function md_make_css_alter(&$css) {
//   if ($GLOBALS['theme'] == 'md_make') {
//     $exclude = array(
//       'misc/vertical-tabs.css' => FALSE,
//       'modules/aggregator/aggregator.css' => FALSE,
//       'modules/block/block.css' => FALSE,
//       'modules/book/book.css' => FALSE,
//       'modules/comment/comment.css' => FALSE,
//       'modules/dblog/dblog.css' => FALSE,
//       'modules/file/file.css' => FALSE,
//       'modules/filter/filter.css' => FALSE,
//       'modules/forum/forum.css' => FALSE,
//       'modules/help/help.css' => FALSE,
//       'modules/menu/menu.css' => FALSE,
//       'modules/node/node.css' => FALSE,
//       'modules/openid/openid.css' => FALSE,
//       'modules/poll/poll.css' => FALSE,
//       'modules/profile/profile.css' => FALSE,
//       'modules/search/search.css' => FALSE,
//       'modules/statistics/statistics.css' => FALSE,
//       'modules/syslog/syslog.css' => FALSE,
//       'modules/system/admin.css' => FALSE,
//       'modules/system/maintenance.css' => FALSE,
//       'modules/system/system.css' => FALSE,
//       'modules/system/system.admin.css' => FALSE,
//       //'modules/system/system.base.css' => FALSE,
//       'modules/system/system.maintenance.css' => FALSE,
//       'modules/system/system.menus.css' => FALSE,
//       'modules/system/system.messages.css' => FALSE,
//       'modules/system/system.theme.css' => FALSE,
//       'modules/taxonomy/taxonomy.css' => FALSE,
//       'modules/tracker/tracker.css' => FALSE,
//       'modules/update/update.css' => FALSE,
//       'modules/user/user.css' => FALSE,
//     );
//     $css = array_diff_key($css, $exclude);
//   }
// }
/* * ************************************************************************************************
 * BEAN
 * Add/ Remove JS
 * *********************************************************************************************** */
function md_make_preprocess_entity(&$vars) {
  if ($vars['entity_type'] == 'bean') {
    if ($vars['bean']->type == 'header_block') {
      drupal_add_css(path_to_theme() . '/css/libs/header/text-rotator/simpletextrotator.min.css');
      drupal_add_js(path_to_theme() . '/js/libs/header/backstretch/backstretch.min.js');
      drupal_add_js(path_to_theme() . '/js/libs/header/bxslider/jquery.bxslider.min.js');
      drupal_add_js(path_to_theme() . '/js/libs/header/text-rotator/jquery.simple-text-rotator.min.js');
      drupal_add_js(path_to_theme() . '/js/libs/header/drawing-svg/classie.js');
      drupal_add_js(path_to_theme() . '/js/libs/header/drawing-svg/svganimations.js');
      drupal_add_js(path_to_theme() . '/js/libs/header/animated-background/demo-2.js', array('type' => 'file', 'scope' => 'footer'));
      drupal_add_js(path_to_theme() . '/js/libs/header/video/jquery.mb.YTPlayer.min.js');
    }
  }
}
