jQuery(function()
{
    redimImages();
});

/*
 *  Homothétie & recadrage des images :
 */
function redimImages()
{
    var cadres = jQuery('.liste_activites_item_img');
    var images = cadres.children('img');
    var ratioImg;
    
    //-- calcule les dimensions du cadre
    var ratioCadre = cadres.width() / cadres.height();
    
    images
    //-- lance deux fois la redim pour gérer les images en cache (pas d'evt load)
    .each(function(){ appliqueRedim(this, cadres, ratioCadre); })
    .load(function(){ appliqueRedim(this, cadres, ratioCadre); });
}

function appliqueRedim(img, cadres, ratioCadre)
{
    var img = jQuery(img);
    var w = img.width();
    var h = img.height();
    
    if (w == 0 || h == 0) return;

    //-- calcule les dimensions de l'image
    ratioImage = w / h;
    
    //-- applique le bon style à l'image
    if (ratioImage > ratioCadre){
        img.css('height', '100%');
        img.css('left', (cadres.width() - img.width()) / 2 + 'px');
    }
    else {
        img.css('width', '100%');
        img.css('top', (cadres.height() - img.height()) / 2 + 'px');
    }
    
    img.show();
}
