jQuery(function()
{
    activeCarte();
});

//-- variables pour la carte
var mapInited = false;
var map;
var idFiche;
var numActiveLayers;
var numLayersReady;


/*
 *  Gestion de la carte interactive :
 */
function activeCarte()
{
    if (!mapInited)
    {
        initCarteFiche();
        
        jQuery('#slider_distance').slider(
        {
            range: "min",
            value: 10,
            min: 1,
            max: 100,
            slide: function( event, ui )
            {
                jQuery('#map_distance').text(ui.value + 'km');
            }
        });
        
        jQuery('#map_distance').text( jQuery('#slider_distance').slider('value') + 'km' );
        
        jQuery('#btn_update_map').click(function()
        {
            majCarte();
        });
    }
}

function initCarteFiche()
{
    var positionOrigine = new google.maps.LatLng(47.1794809355125, 4.5640154570312585);
    
    var mapOptions =
    {
        center: positionOrigine,
        zoom: 11,
        mapTypeId: google.maps.MapTypeId.TERRAIN,
        mapTypeControl: true,
        zoomControl: true,
        panControl: true,
        scaleControl: false,
        streetViewControl: true,
        overviewMapControl: false,

        navigationControlOptions: {
            position: google.maps.ControlPosition.TOP_LEFT
        }
    }
    
    map = new google.maps.Map(document.getElementById('map_canvas_fiche'), mapOptions);
    //console.log(location.protocol +"//"+ location.host+'/sites/all/modules/adt21_carte/parse.php?id=' + idFiche + '&support=NATURE');
    //var kmlLayer = new google.maps.KmlLayer('http://flux.cotedor-tourisme.com/kml/itineraire.php?id=' + idFiche);
    var kmlLayer = new google.maps.KmlLayer(location.protocol +"//"+ location.host+'/sites/all/modules/adt21_carte/parse.php?id=' + idFiche + '&support=NATURE');
    kmlLayer.setMap(map);
    
    mapInited = true;
}

var layers = [];

function majCarte()
{
    var distance = jQuery('#slider_distance').slider('value');
    
    numActiveLayers = jQuery('#map_select_type input[type="checkbox"]:checked').length;
    numLayersReady = 0;
    
    if (numActiveLayers > 0){
        jQuery('#btn_update_map').hide();
        jQuery('#txt_chargement').show();
    }
    
    jQuery('#map_select_type input[type="checkbox"]').each(function()
    {
        var checked = jQuery(this).attr('checked');
        var typeObj = this.name;
        var layerExists = typeof layers[typeObj] != 'undefined';
        
        //-- si la case n'est pas cochée et que le calque existe
        if (layerExists)
        {
            //-- masque puis détruit le calque
            layers[typeObj].hideDocument();
            delete layers[typeObj];
        }
        
        if (checked)
        {
            //-- construction de la requête
            var params = '{"crit":[{"concept":"dist","champvaleur":"' + idFiche + '","valeur":"' + idFiche + '","operateur":"=","foncteur":"AND"},{"concept":"obj_common","champvaleur":"dist","valeur":"' + distance + '","operateur":"<=","foncteur":"AND"}]}';
            var requete = '//' + document.domain + '/sites/all/modules/adt21_carte/parse.php?type=' + typeObj + '&params=' + encodeURIComponent(params) + '&verf=true';
            //console.log(requete);
            //
            //-- chargement du calque
            var kmlLayer = new geoXML3.parser({map:map, afterParse:layerReady});
            kmlLayer.parse(requete);

            //-- enregistrement du calque
            layers[typeObj] = kmlLayer;
        }
    });
}

function layerReady(data)
{
    if (++numLayersReady == numActiveLayers)
    {    
        jQuery('#btn_update_map').show();
        jQuery('#txt_chargement').hide();
    }
}