(function ($) {

    /**
     * Attach infinite scroll to the relevant views.
     */
    Drupal.behaviors.views_infinite_scroll = {
        attach: function (context, settings) {


            // Make sure that autopager plugin is loaded.
            if (!$.autopager) {
                return;
            }
            // IMAGE LOADED
            function loadImg(options, callback) {
                var seconds = 0,
                        maxSeconds = 10,
                        complete = false,
                        done = false;

                if (options.maxSeconds) {
                    maxSeconds = options.maxSeconds;
                }

                function tryImage() {
                    if (done) {
                        return;
                    }
                    if (seconds >= maxSeconds) {
                        callback({err: 'timeout'});
                        done = true;
                        return;
                    }
                    if (complete && img.complete) {
                        if (img.width && img.height) {
                            callback({img: img});
                            done = true;
                            return;
                        }
                        callback({err: '404'});
                        done = true;
                        return;
                    } else if (img.complete) {
                        complete = true;
                    }
                    seconds++;
                    callback.tryImage = setTimeout(tryImage, 1000);
                }
                var img = new Image();
                img.onload = tryImage();
                img.src = options.src;
                tryImage();
            }

            var settings = settings.views_infinite_scroll[0];

            // Ensure we are refreshing the view component.
            var view_selector = 'div.view-id-' + settings.view_name + '.view-display-id-' + settings.display;
            var $view = $(context).is(view_selector) ? $(context) : $(context).find(view_selector);
            if ($view.length == 0) {
                return;
            }
            // Destroy an existing instance of autopager.
            $.autopager('destroy');

            var content_selector = view_selector + ' > ' + settings.content_selector;
            //console.log(content_selector);

            // DECLARE FUNCTION MASONRY
            $(content_selector).imagesLoaded(function () {
                $(content_selector).masonry({
                    columnWidth: 'figure',
                    itemSelector: 'figure'
                });
            }, 1);


            var $items = $view.find(settings.items_selector);
            var $pager = $view.find('> div.item-list ' + settings.pager_selector);
            var next_selector = view_selector + ' ' + settings.next_selector;
            //console.log(next_selector);
            var $next = $(next_selector);

            var $img_location = $view.find('div.view-content');
            var img_path = settings.img_path;
            var img = '<div id="views_infinite_scroll-ajax-loader"><img src="' + img_path + '" alt="loading..."/></div>';
            //            $($pager).hide();

            $.autopager({
                appendTo: content_selector,
                content: content_selector + ' ' + settings.items_selector,
                link: next_selector,
                page: 0,
                autoLoad: !settings.manual_load,
                start: function () {
                    $img_location.after(img);
                    /*custom for  LOAD MORE <= width => content_selector === .view-content*/
                    $('.views-row', content_selector).addClass('load-done');
                    // console.log('start function');
                },
                load: function (current, next) {
                    $('div#views_infinite_scroll-ajax-loader').remove();
                    Drupal.attachBehaviors(this);
                    // Use >= because of views page numbers begin at 0.
                    if (next.page >= settings.pager_max) {
                        $('#views_infinite_scroll_button').addClass('display_none');
                        $('#work-wrap').addClass('loadfinish');
                    }
                    /* Call RELOAD MASONRY + RESIZE WINDOW*/
                    $(content_selector).isotope('reloadItems');
                    $(content_selector).masonry('reloadItems');

                    $.each($('.views-row', content_selector).not(".load-done"), function () {
                        var src_picture = $('img', this).attr('src');
                        loadImg({src: src_picture}, function () {
                            if (status.err) {
                                return;
                            }
                            $('.portfolioFilter a.current').trigger('click');
                            $('body').trigger('resize');
                        });
                    });
                }
            });
            // CHECK SHOW MORE BUTTON
            if (settings.manual_load) {
                // The pager is hidden. Pop "next" link out so it will be visible.
                $next.text(settings.text);
                $next.on('click', function () {
                    // do load
                    $.autopager('load');
                    return false;
                });
                $($pager).before($next);
                // Wrap the button to allow for easier styling in the theme
                $next.wrap('<div id="views_infinite_scroll_button" class="scroll_load_button" />');
                $more = $('.scroll_load_button');
                if ($more.length) {
                    $('.pager-previous').addClass('display_none');
                    $('.pager-current').addClass('display_none');
                    $('#views_infinite_scroll_button a').addClass('magnific btn button-line btn-default');
                }
            }
            else {
                $(content_selector).on('change', function () {
//                    $('.portfolioFilter a.current').trigger('click', console.log('thanhdsd'));
//                    $(content_selector).isotope('reloadItems');

                });
                $('.pager').hide();
                // Trigger autoload if content height is less than doc height already
                var prev_content_height = $(content_selector).height();
                do {
                    var last = $($items).filter(':last');
                    if ($('.blog-masonry').height() + $('.blog-masonry').offset().top < $(document).scrollTop() + $(window).height()) {
                        last = $($items).filter(':last');
                        $masonry = $('.blog-masonry').height();
                        $.autopager('load');
                    }
                    else {
                        break;
                    }
                }
                while ($('.loadfinish').length > 0);
            }
        }
    };
})(jQuery);
