//-- variables pour le diaporama
var cycleSpeed = 5000;
var fadeSpeed = 1200;
var photos, numPhotos;
var currentPhoto = 0;
var interval;
/*
 * Permet d'écouter le chargement des images même avec la mise en cache :
 */
jQuery.fn.extend({
    ensureLoad: function(handler) {
        return this.each(function() {
            if(this.complete) {
                handler.call(this);
            } else {
                jQuery(this).load(handler);
            }
        });
    }
});
/*-----*/
jQuery(function()
{
    redimImages(jQuery('.galerie_diaporama_inner'));
    
    lanceGalerie(jQuery('.galerie_diaporama_inner').eq(0));
    
    jQuery('.btn_galerie_prec').click(function()
    {
        clickGaleriePrec();
    });

    jQuery('.btn_galerie_suiv').click(function()
    {
        clickGalerieSuiv();
    }); 
});

function redimImages(conteneur)
{
    var images = conteneur.find('img');
    var img, w, h, ratioImg;
    
    //-- calcule les dimensions du cadre
    var ratioCadre = conteneur.width() / conteneur.height();
    
    //-- référence à body pour les opérations de clonage temporaire
    var jbody = jQuery('body');
    
    images.ensureLoad(function()
    {
        img = jQuery(this);
        
        //-- créé un clone visible pour pouvoir extraire les dimensions de l'image
        var clone = img.clone();
        clone.css({position:'absolute', left:'-10000px'});
        jbody.append(clone);
        
        //-- calcule les dimensions de l'image
        ratioImage = clone.width() / clone.height();
        
        //-- supprime le clone du DOM
        clone.remove();
        
        //-- applique le bon style à l'image
        if (ratioImage > ratioCadre){
            img.css('height', '100%');
        }
        else {
            img.css('width', '100%');
        }
    });
}

/*
 *  Boutons pour naviguer dans la galerie :
 */
function clickGaleriePrec()
{
    stopGalerie();
    
    jQuery(photos[currentPhoto]).fadeOut(fadeSpeed * .5);
    if (--currentPhoto < 0) currentPhoto = numPhotos -1;
    jQuery(photos[currentPhoto]).fadeIn(fadeSpeed * .5);
}

function clickGalerieSuiv()
{
    stopGalerie();
    
    jQuery(photos[currentPhoto]).fadeOut(fadeSpeed * .5);
    if (++currentPhoto == numPhotos) currentPhoto = 0;
    jQuery(photos[currentPhoto]).fadeIn(fadeSpeed * .5);
}

/*
 *  Démarre le diaporama de l'onglet en cours :
 *  
 *  @param photos Un objet JQuery qui contient les images du diaporama
 */
function lanceGalerie(conteneur)
{
    photos = conteneur.find('img');
    //photos = jQuery(idOnglet + ' .galerie_diaporama_inner').find('img');
    
    numPhotos = photos.length;
    
    if (numPhotos <= 1) return;
    
    var i = 0;
    
    photos.each(function()
    {
        if (i == 0) jQuery(this).show();
        
        if (i++ > 0){
            jQuery(this).hide();
        }
    })
    
    currentPhoto = 0;
    
    interval = setInterval(function()
    {
        jQuery(photos[currentPhoto]).fadeOut(fadeSpeed);
        
        if (++currentPhoto == numPhotos) currentPhoto = 0;
        
        jQuery(photos[currentPhoto]).fadeIn(fadeSpeed);
    },
    cycleSpeed);
}

/*
 *  Arrête le diaporama de l'onglet en cours :
 */
function stopGalerie()
{
    clearInterval(interval);
}