//-- variables pour les onglets
var boutonsOnglets;
var nbOnglets;
var currentOngletId = '#onglet_technique';


//-- variables pour la carte
var mapInited = false;
var map;
var idFiche;
var numActiveLayers;
var numLayersReady;

var ignKey ="aale714u358pd2vv7xoba2ai";


function makeIGNMapType(layer, name, maxZoom) {
        return new google.maps.ImageMapType({
            getTileUrl: function(coord, zoom) {
                return "http://gpp3-wxs.ign.fr/" + ignKey + "/geoportail/wmts?LAYER=" +
                    layer +
                    "&EXCEPTIONS=text/xml&FORMAT=image/jpeg&SERVICE=WMTS&VERSION=1.0.0" +
                    "&REQUEST=GetTile&STYLE=normal&TILEMATRIXSET=PM&TILEMATRIX=" +
                    zoom + "&TILEROW=" + coord.y + "&TILECOL=" + coord.x;
            },
            tileSize: new google.maps.Size(256,256),
            name: name,
            maxZoom: maxZoom
        });
    }


/*
 *  Au chargement du DOM :
 */
jQuery(document).ready(function()
{
    jQuery(currentOngletId).show();

    boutonsOnglets = jQuery('.btn_onglet');
    nbOnglets = boutonsOnglets.length;
    
    boutonsOnglets.eq(1).addClass('btn_onglet_suiv');

    boutonsOnglets.click(function()
    {
        clickOnglet(jQuery(this));
    });    
    
    // lance le processus de synchronisation du noeud
    jQuery.ajax({
        url:'/admin/config/webservice_nodes/synchronisation/sync/' + Drupal.settings.node.nid + '/' + Drupal.settings.node.adt_request_nid,
        type:'POST',
        dataType:'text'
        /*success: function(data){
            console.log('success:');
            console.log(data);
        },
        error: function(data){
            console.log('error : ');
            console.log(data);
        }*/
    });
    
    jQuery('#onglet_nature').readmore({
    speed: 200,
    lessLink: '<a href="#" class="lireplus icon fontello icon-angle-up">Réduire<span class="icon fontello icon-angle-up"></span></a>',
    moreLink: '<a href="#" class="lireplus icon fontello icon-angle-down">Lire la suite<span class="icon fontello icon-angle-down"></span></a>'
  });
      jQuery('#onglet_patrimoine').readmore({
    speed: 200,
    lessLink: '<a href="#" class="lireplus icon fontello icon-angle-up">Réduire<span class="icon fontello icon-angle-up"></span></a>',
    moreLink: '<a href="#" class="lireplus icon fontello icon-angle-down">Lire la suite<span class="icon fontello icon-angle-down"></span></a>'
  });
  
   //Gestion des lightbox du carousel
        jQuery('.carousel-fiche').magnificPopup({ delegate: 'a.open-lightbox', // child items selector, by clicking on it popup will open
                                            gallery: {
                                                // options for gallery
                                                enabled: true
                                                } , 
                                            //image: {
                                              // options for image content type
                                              titleSrc: 'title',
                                           // },
                                            type: 'image'});
                jQuery.fn.imgLoad = function(callback) {
                        return this.each(function() {
                            if (callback) {
                                if (this.complete || /*for IE 10-*/ $(this).height() > 0) {
                                    callback.apply(this);
                                }
                                else {
                                    $(this).on('load', function(){
                                        callback.apply(this);
                                    });
                                }
                            }
                        });
                    };
                  jQuery('.carousel-fiche').first().imagesLoaded( function() {
                    // images have loaded
                    console.log("All images loaded");

                    jQuery('img.imgFicheADT21').imgLoad(function(){
                        console.log("une image with src " +jQuery(this).attr("src"));
                        console.log("une image width " +jQuery(this).width());
                        console.log("une image height" + jQuery(this).height());
                        console.log("hauteur du conteneur " + jQuery(".owl-wrapper-outer").first().height());
                        var heightCarou = jQuery(".owl-wrapper-outer").first().height();
                        heightCarou=800;
                        var aspectRatio = jQuery(this).width()/jQuery(this).height();
                        jQuery(this).data("aspect-ratio", aspectRatio);

                        // Conditional statement
                        console.log("une image ratio" + aspectRatio);
                        if(aspectRatio > 1) {
                            // Image is landscape
                          /*  $(this).css({
                                width: "100%",
                                height: "auto"
                            });*/
                            jQuery(this).addClass("imgFicheADT21Paysage");
                        } else if (aspectRatio < 1) {
                            // Image is portrait
                           /*$(this).css({
                                maxWidth: "100%",
                                height: heightCarou + "px"
                            });*/
                            jQuery(this).addClass("imgFicheADT21Portrait");
                        } else {
                            // Image is square
                            /*$(this).css({
                                maxWidth: "100%",
                                height: heightCarou + "px"
                            });*/
                            jQuery(this).addClass("imgFicheADT21Paysage");
                        }

                    });
                  });

  
  
  
    activeCarte();
});

/*
 *  Affichage des onglets
 */
function clickOnglet(elt)
{
    var idBtn = elt.attr('id');     // id du bouton (ex: btn_onglet_technique)
    var idOnglet = idBtn.substr(4); // enlève 'btn_' 
    var onglet = jQuery('#' + idOnglet);
    
    //-- masque tous les onglets
    jQuery(currentOngletId).hide();
    
    //-- rétablit la classe par défaut pour tous les onglets
    boutonsOnglets.removeClass('btn_onglet_suiv').removeClass('btn_onglet_prec').removeClass('btn_onglet_actif');
    
    //-- cherche la position de l'onglet (pour ajouter les ombres)
    var positionOnglet = boutonsOnglets.index(elt);
    
    if (positionOnglet < nbOnglets-1){
        boutonsOnglets.eq(positionOnglet + 1).addClass('btn_onglet_suiv');
    }
    if (positionOnglet > 0){
        boutonsOnglets.eq(positionOnglet - 1).addClass('btn_onglet_prec');
    }
    
    //-- arrête la galerie en cours
    stopGalerie();
    
    currentOngletId = '#' + idOnglet;
    
    //-- affiche l'onglet sur lequel on a cliqué
    onglet.show();
    elt.addClass('btn_onglet_actif');
    
    //-- pour tous les onglets sauf la carte, lance la galerie d'images
    if (idOnglet != 'onglet_carte')
    {
        jQuery('.titre_fiche').show();
        
        //-- lance la galerie du nouvel onglet
        lanceGalerie(jQuery(currentOngletId + ' .galerie_diaporama_inner'));
    }
    
    //-- pour l'onglet carte
    else
    {
        jQuery('.titre_fiche').hide();
        
        activeCarte();
    }

    

    //--Ajout du tracking Google Analytics pour les onglets
    var url = window.location.href.toString().split(window.location.host)[1];
    
    if (typeof _gaq !== 'undefined') _gaq.push(['_trackEvent', 'Onglets', 'Clic page - '+ url, currentOngletId ]);

}





/*
 *  Gestion de la carte interactive :
 */
function activeCarte()
{
    if (!mapInited)
    {
        initCarteFiche();
        
        jQuery('#slider_distance').slider(
        {
            range: "min",
            value: 10,
            min: 1,
            max: 100,
            slide: function( event, ui )
            {
                jQuery('#map_distance').text(ui.value + 'km');
            }
        });
        
        jQuery('#map_distance').text( jQuery('#slider_distance').slider('value') + 'km' );
        
        jQuery('#btn_update_map').click(function()
        {
            majCarte();
        });
    }
}

function initCarteFiche()
{
    var positionOrigine = new google.maps.LatLng(47.1794809355125, 4.5640154570312585);
    
    
    
 
    

    
  
    var mapOptions =
    {
        center: positionOrigine,
        zoom: 11,
        mapTypeId: google.maps.MapTypeId.TERRAIN,
	
        mapTypeControl: true,
        mapTypeControlOptions: {
                mapTypeIds: [
                     google.maps.MapTypeId.TERRAIN,'IGNScanExpress','IGN', 'EtatMajor' ],
                style: google.maps.MapTypeControlStyle.HORIZONTAL_BAR
            },
        zoomControl: true,
        panControl: true,
        scaleControl: false,
        streetViewControl: true,
        overviewMapControl: false,

        navigationControlOptions: {
            position: google.maps.ControlPosition.TOP_LEFT
        }
    }
    
    map = new google.maps.Map(document.getElementById('map_canvas_fiche'), mapOptions);
    map.mapTypes.set('IGN', makeIGNMapType("GEOGRAPHICALGRIDSYSTEMS.MAPS", "IGN", 18));
    map.mapTypes.set('IGNScanExpress', makeIGNMapType("GEOGRAPHICALGRIDSYSTEMS.MAPS.SCAN-EXPRESS.CLASSIQUE", "IGN Scan Express", 16));
    //map.mapTypes.set('Cassini', makeIGNMapType("GEOGRAPHICALGRIDSYSTEMS.CASSINI", "Cassini", 14));
    map.mapTypes.set('EtatMajor', makeIGNMapType("GEOGRAPHICALGRIDSYSTEMS.ETATMAJOR40", "État-Major XIXe", 15));
    
    
    var urlKml = location.protocol +"//"+ location.host+'/sites/all/modules/adt21_carte/parse.php?id=' + idFiche + '&support=NATURE&alea=1259656';
    console.log(urlKml);
    var kmlLayer = new google.maps.KmlLayer(location.protocol +"//"+ location.host+'/sites/all/modules/adt21_carte/parse.php?id=' + idFiche + '&support=NATURE&alea='+Math.random());
    kmlLayer.setMap(map);
    
    mapInited = true;
}

var layers = [];

function majCarte()
{
    var distance = jQuery('#slider_distance').slider('value');
    
    numActiveLayers = jQuery('#map_select_type input[type="checkbox"]:checked').length;
    numLayersReady = 0;
    
    if (numActiveLayers > 0){
        jQuery('#btn_update_map').hide();
        jQuery('#txt_chargement').show();
    }
    
    jQuery('#map_select_type input[type="checkbox"]').each(function()
    {
        //var checked = jQuery(this).attr('checked');
         var checked = jQuery(this).prop('checked');
        var typeObj = this.name;
        var layerExists = typeof layers[typeObj] != 'undefined';
        
        //-- si la case n'est pas cochée et que le calque existe
        if (layerExists)
        {
            //-- masque puis détruit le calque
            layers[typeObj].hideDocument();
            delete layers[typeObj];
        }
        
        if (checked)
        {
            //-- construction de la requête
            var params = '{"crit":[{"concept":"dist","champvaleur":"' + idFiche + '","valeur":"' + idFiche + '","operateur":"=","foncteur":"AND"},{"concept":"obj_common","champvaleur":"dist","valeur":"' + distance + '","operateur":"<=","foncteur":"AND"}]}';
            //var requete = '//' + document.domain + '/sites/all/modules/adt21_carte/parse.php?type=' + typeObj + '&params=' + encodeURIComponent(params) + '&verf=true';
            var requete = 'https://www.cotedor-tourisme.com/sites/all/modules/adt21_carte/parse.php?type=' + typeObj + '&params=' + encodeURIComponent(params) + '&verf=true';
            //console.log(requete);
            //
            //-- chargement du calque
            var kmlLayer = new geoXML3.parser({map:map, afterParse:layerReady});
            kmlLayer.parse(requete);

            //-- enregistrement du calque
            layers[typeObj] = kmlLayer;
        }
    });
}

function layerReady(data)
{
    if (++numLayersReady == numActiveLayers)
    {    
        jQuery('#btn_update_map').show();
        jQuery('#txt_chargement').hide();
    }
}