(function($) {
	$(window).load(function() {
	"use strict";
			setTimeout(function () {
					$('.loader-overlay').addClass('loaded');
			},300);

	});
	$(document).ready(function() {
		
		var endDate = String($('#countdown').data('time'));
			$('#countdown').countdown(endDate, function(event) {
					$(this).html(event.strftime('%w weeks %d days <br /> %H:%M:%S'));
			});

			$('.social-nav ul li').mouseover(function(){
					$(this).animate({'padding-top' : 130}, {queue: false, duration: 500});
			}).mouseleave(function(){
					$(this).animate({'padding-top' : 100}, {queue: false, duration: 500});
			});

			$('.main-nav ul li a, .content.show a').click(function(e) {
					e.preventDefault();
					var link = $(this).attr('href').substr(1);
					
					if ( !$('section.content.show, section#' + link).is(':animated') ) {
							$('.main-nav ul li a').removeClass('active'); //remove active
							$('section.content.show').addClass('show').animate({'opacity' : 0}, {queue: false, duration: 500,
									complete: function() {
											$('section.content.show').hide().removeClass('show').addClass('hide');
											$('a[href="#'+link+'"]').addClass('active'); // add active
											$('section#' + link).show();
											$('section#' + link).removeClass('hide').addClass('show').animate({'opacity' : 1}, {queue: false, duration: 500});    
									}
							});
					}
			});
	});
	
  Drupal.behaviors.myMap = {
    attach: function (context, settings) {    
	/* GOOGLE MAPS */
			
			comingMap($('#map', context));
			map_height($('#map', context));
			
			$(window).resize(function() {
					map_height($('#map', context));
					comingMap($('#map', context));
			});
	}};
	
	function map_height(maps){
			maps.height('');
			var window_h = $(window).height();
			var html_h = $(document).height();
			maps.css({ 'height' : window_h });
	}

	function comingMap(maps) {
		var $location = maps.data('location'),
				$map_location = [],  
        $number_location = $location.split(",");
            
        for (var i=0; i<$location.length; i++)
            $map_location.push( + $number_location[i] ); 
		
		var myOptions = {
			zoom: 4,
			center: new google.maps.LatLng($map_location[0],$map_location[1]),
			navigationControlOptions: {
				style: google.maps.NavigationControlStyle.NORMAL,
				position: google.maps.ControlPosition.RIGHT_TOP
			},
			streetViewControl: false,
			scrollwheel: false,
			zoomControl: false,
			panControl: false,
			zoomControlOptions: {
						style: google.maps.ZoomControlStyle.DEFAULT,
						position: google.maps.ControlPosition.RIGHT_TOP
				},
			mapTypeControl: false,
			mapTypeControlOptions: {
				style: google.maps.MapTypeControlStyle.DROPDOWN_MENU,
						position: google.maps.ControlPosition.TOP_RIGHT,
				mapTypeIds: ["ptMap"]
			}
		};
		
		map = new google.maps.Map(document.getElementById('map'), myOptions);
		var mapStyle = [
			{ featureType: "administrative", elementType: "all", stylers: [ { visibility: "off" } ] },
			{ featureType: 'landscape', elementType: 'all', stylers: [ { color: '#3C3C3C' }, { visibility: 'on' } ] },
			{ featureType: "poi", elementType: "all", stylers: [ { visibility: "off" } ] },
			{ featureType: "road", elementType: "all", stylers: [ { visibility: "on" }, { lightness: -30 } ] },
			{ featureType: "transit", elementType: "all", stylers: [ { visibility: "off" } ] },
			{ featureType: "water", elementType: "all", stylers: [ { color: '#232323' } ] }
		];
			
		var styledMapOptions = {name: "Map"};
			var ptMapType = new google.maps.StyledMapType(mapStyle, styledMapOptions);
			map.mapTypes.set("ptMap", ptMapType);
			map.setMapTypeId("ptMap");  
		
		var circle = {
				path: google.maps.SymbolPath.CIRCLE,
				fillOpacity: 0.6,
				fillColor: '#319db5',
				strokeWeight: 0, 
				scale: 12
		};
		
		var marker = new MarkerWithLabel({
					position: map.getCenter(),
					icon: {
							path: google.maps.SymbolPath.CIRCLE,
							scale: 0
					},
					map: map,
					draggable: true,
					labelAnchor: new google.maps.Point(10, 10),
					labelClass: 'pulse-label'
			});		
	}
})(jQuery);