(function ($) {

    var topnav = $('.topnav');
    var header = $('header');
    var topText = $('.top-text');
    var headerInfo = $('.header-info');
    var topnavHeight = topnav.height();
    var headerHeight = header.height();
    var headerInfoHeight = $('.header-info').outerHeight();
    var contactInfoHeight = $('.contact-info').outerHeight()+20;
    var windowWidth = $(window).width();
    var windowHeight = $(window).height();
    $(window).load(function () {

        'use strict';
        setTimeout(function () {
            $('.loader-overlay').addClass('loaded');
            $('body > section').animate({
                opacity: 1,
            }, 400);
            progressBar();
        }, 500);
    });
    $(window).scroll(function () {

        'use strict';
        var scrollPos = $(window).scrollTop();
        scrollPos > 220 ? $('.sticky-section').addClass('nav-bg') : $('.sticky-section').removeClass('nav-bg');
        if ($('.header-info').length) {
            if($('.region_detail').length < 1){
                topnav.addClass("nopading_sticky");
                if ($('.contact-info').length) {
                  if (scrollPos < contactInfoHeight)
                    headerInfo.css('margin-top', -scrollPos);
                  else
                    headerInfo.css('margin-top', -contactInfoHeight);   
                }
            }
            else {
                if (scrollPos < headerInfoHeight)
                    headerInfo.css('margin-top', -scrollPos);
                else
                    headerInfo.css('margin-top', -headerInfoHeight);
            }            
        }
        navbarScroll(topnav, topnavHeight);
        fadeText(this);
        handleFixedColumn();
    });
    /* ----------------------------- 
     Backgroung slider
     ----------------------------- */
    $(window).ready(function () {

        'use strict';
        handleNavigation();
        navbarScroll(topnav, topnavHeight);
        rotateText();
        imageZoom();
        var scrollPos = $(window).scrollTop();
        if (scrollPos < headerInfoHeight)
            headerInfo.css('margin-top', -scrollPos);
        else
            headerInfo.css('margin-top', -headerInfoHeight);
        /* Full Height */
        $('.height-full').each(function () {
            var contentHeight = $(this).height();
            if (contentHeight < windowHeight) {
                if ($('html').hasClass('border-page')) {
                    $(this).height(windowHeight - 40);
                }
                else {
                    $(this).height(windowHeight);
                }
            }
        });
        /* Page Transition Fade Out */
        // $('.topnav li a').on('click', function (e) {
        //     e.preventDefault();
        //     var targetLink = $(this).attr('href');
        //     if (targetLink == '#' || targetLink == '')
        //         return;
        //     if ($('html').hasClass('one-page'))
        //         return;
        //     $('body').fadeOut(350, function () {
        //         window.location.href = targetLink;
        //     });
        // })
    
        
        /* Navbar fix */
        if ($('.topnav li.menu-scroll a').length) {
            $('.awemenu-nav').onePageNav({
                currentClass: 'current',
                scrollSpeed: 1000,
                easing: 'easeInOutQuint',
                filter: ':not(.toggle-header-index)'
            });
        }


        if ($.fn.appear) {
            $('.animated').appear({force_process: true});
        }

        $('.animated').on('appear', function (event, $all_appeared_elements) {
            var element = $(this),
                    animation = element.data('animation'),
                    animationDelay = element.data('animation-delay');
            if (animationDelay) {
                setTimeout(function () {
                    element.addClass(animation + " visible");
                }, animationDelay);
            } else {
                element.addClass(animation + " visible");
            }
        });
        $('.next-section').on('click', function (e) {
            e.preventDefault();
            var scrollToElement = $(this).parent().next();
            if ($(this).parent().parent().is('section'))
                scrollToElement = $(this).parent().parent().next();
            if ($(this).parent().parent().is('header'))
                scrollToElement = $(this).parent().parent().next();
            if ($(this).parent().parent().parent().is('header'))
                scrollToElement = $(this).parent().parent().parent().next();
            if ($(this).parent().parent().parent().parent().is('header'))
                scrollToElement = $(this).parent().parent().parent().parent().next();
            if ($(this).parent().parent().parent().parent().parent().parent().is('header'))
                scrollToElement = $(this).parent().parent().parent().parent().parent().parent().next();
            if ($(this).parent().parent().parent().parent().parent().parent().parent().is('header'))
                scrollToElement = $(this).parent().parent().parent().parent().parent().parent().parent().next();
            if ($(this).parent().parent().parent().parent().parent().parent().parent().parent().is('header'))
                scrollToElement = $(this).parent().parent().parent().parent().parent().parent().parent().parent().next();
            if ($(this).parent().parent().parent().parent().parent().parent().parent().parent().parent().is('header'))
                scrollToElement = $(this).parent().parent().parent().parent().parent().parent().parent().parent().parent().next();
            if ($(this).parent().parent().parent().parent().parent().parent().parent().parent().parent().parent().is('header'))
                scrollToElement = $(this).parent().parent().parent().parent().parent().parent().parent().parent().parent().parent().next();
            $('html, body').animate({
                scrollTop: scrollToElement.offset().top - 60
            }, 1000);
        });
        $('.go-section-two').on('click', function (e) {
            e.preventDefault();
            $('html, body').animate({
                scrollTop: $('#section-two').offset().top
            }, 1000);
        });
        $('.go-carte').on('click', function (e) {
            e.preventDefault();
            $('html, body').animate({
                scrollTop: $('#zone_carte').offset().top - 80
            }, 1000);
        });
        $('.go-team').on('click', function (e) {
            e.preventDefault();
            $('html, body').animate({
                scrollTop: $('#team').offset().top
            }, 1000);
        });
        /* Background Slider */
        if ($('.bg-slider').length && $.fn.backstretch) {
            $('.bg-slider').height(windowHeight);
            if ($('.bg-slider').attr('data-images')) {
                var bgImages = [];
                bgImages = $('.bg-slider').attr('data-images').split(',');
                // Access the instance
                var instance = $('.bg-slider').data('images');
                // Then, you can manipulate the images array directly
                $('.bg-slider').backstretch(
                        instance,
                        {
                            fade: 600,
                            duration: 4000
                        });
            }
            else {
                $('.bg-slider').backstretch([
                    '../../common-files/images/bg/bg-6.jpg',
                    '../../common-files/images/bg/bg-2.jpg',
                    '../../common-files/images/bg/bg-3.jpg'],
                        {
                            fade: 600,
                            duration: 4000
                        });
            }

        }

        /* Video Background */
        if ($(".video-player").length) {
            $(".video-player").each(function () {
                $(this).mb_YTPlayer();
            });
            $('.video-player').on("YTPPause",function(e){
               $('.mbYTP_wrapper').css({'opacity': 0});
            });
            $('.video-player').on("YTPStart",function(e){
               $('.mbYTP_wrapper').css({'opacity': 1});
            });
        }

        $('#play-video').click(function (e) {
            e.preventDefault();
            if ($(this).hasClass("icon-control-play")) {
                $('.video-player').playYTP();
            } else {
                $('.video-player').pauseYTP();
            }
            $(this).toggleClass("icon-control-play icon-control-pause");
            return false;
        });
        /* Background Slider */
        if ($('.bg-image').length && $.fn.backstretch) {
            $('.bg-image').height(windowHeight);
            $('.bg-image').backstretch(["images/bg/bg-2.jpg"]);
        }

        /* Scroll into viewPort Animation */
        if ($.fn.appear) {
            $('.animated').appear(function () {
                var element = $(this),
                        animation = element.data('animation'),
                        animationDelay = element.data('animation-delay');
                if (animationDelay) {
                    setTimeout(function () {
                        element.addClass(animation + " visible");
                    }, animationDelay);
                } else {
                    element.addClass(animation + " visible");
                }
            });
        }

        $('.toggle-aside').on('click', function (e) {
            e.preventDefault();
            setTimeout(function () {
                $('#aside').addClass('open');
            }, 100);
        });
        document.addEventListener('click', function (ev) {
            if ($('#aside').hasClass('open')) {
                var ecommerceSidebar = document.getElementById('aside');
                var target = ev.target;
                if (target !== ecommerceSidebar) {
                    if ($('#aside').hasClass('open')) {
                        $('#aside').removeClass('open');
                    }
                }
            }
        });
        /* Fitvids init */
        if ($('.video-content').length) {
            $('.video-content').fitVids();
        }

        /* Testimonial Slider */
        if ($('.testimonials-slider').length) {
            $('.testimonials-slider').bxSlider({
                pagerCustom: '#testimonials-pager',
                pager: true,
                touchEnabled: true,
                controls: false
            });
        }

        /* IE 9 Placeholder fix */
        /*$('[placeholder]').focus(function () {
            var input = $(this);
            if (input.val() == input.attr('placeholder')) {
                input.val('');
                input.removeClass('placeholder');
            }
        }).blur(function () {
            var input = $(this);
            if (input.val() == '' || input.val() == input.attr('placeholder')) {
                input.addClass('placeholder');
                input.val(input.attr('placeholder'));
            }
        }).blur();*/
        if ($.fn.select2) {
            $('select:not(.select-picker)').each(function () {
                $(this).select2({
                    placeholder: $(this).data('placeholder') ? $(this).data('placeholder') : '',
                    allowClear: $(this).data('allowclear') ? $(this).data('allowclear') : true,
                    minimumInputLength: $(this).data('minimumInputLength') ? $(this).data('minimumInputLength') : -1,
                    minimumResultsForSearch: $(this).data('search') ? 1 : -1,
                    dropdownCssClass: $(this).data('style') ? 'form-white' : ''
                });
            });
        }

        if ($('.select-picker').length && $.fn.selectpicker) {
            $('.select-picker').selectpicker();
        }

        /* Image Carousel */
        $('[data-plugin-carousel]:not(.manual), .owl-carousel:not(.manual, .image-slide-show)').each(function () {
            var $this = $(this), opts = null,
                    pluginOptions = $this.data('plugin-options'),
                    defaults = {
                        "autoPlay": 3000,
                        "items": 1,
                        "singleItem": true,
                        "itemsDesktop": [1199, 5],
                        "itemsDesktopSmall": [980, 4],
                        "itemsTablet": [768, 3],
                        "itemsMobile": [479, 2],
                    };
            opts = $.extend({}, defaults, pluginOptions);
            $this.owlCarousel(opts);
        });
       /* Perso Carousel */
        $('.myCarousel').each(function () {
            var $this = $(this), opts = null,
                    pluginOptions = $this.data('plugin-options'),
                    defaults = {
                        "autoPlay": 3000,
                        "items": 4,
                        "singleItem": false,
                        "itemsDesktop": [1199, 4],
                        "itemsDesktopSmall": [980, 3],
                        "itemsTablet": [768, 2],
                        "itemsMobile": [479, 1],
                        "navigationText":["<i class=\"icon fontello icon-angle-left\"></i>","<i class=\"icon fontello icon-angle-right\"></i>"]
                    };
                    //console.log("toto");
            opts = $.extend({}, defaults, pluginOptions);
            //console.log(opts);
            $this.owlCarousel(opts);
        });
        
        $('.ActuMenuCarousel').each(function () {
            var $this = $(this), opts = null,
                    pluginOptions = $this.data('plugin-options'),
                    defaults = {
                        "autoPlay": 3000,
                        "items": 4,
                        "singleItem": true,
                        "itemsDesktop": [1199, 4],
                        "itemsDesktopSmall": [980, 3],
                        "itemsTablet": [768, 2],
                        "itemsMobile": [479, 1],
                        "navigationText":["<i class=\"icon fontello icon-angle-left\"></i>","<i class=\"icon fontello icon-angle-right\"></i>"]
                    };
                    console.log("toto");
            opts = $.extend({}, defaults, pluginOptions);
            //console.log(opts);
            $this.owlCarousel(opts);
        });
        /* Video */
        if ($(".video").length && $.fn.fitVids) {
            $(".video").fitVids();
        }

        /* Blog Masonry */
        $(".blog-masonry").imagesLoaded(function () {
        if ($(".blog-masonry").length && $.fn.masonry) {
            $('.blog-masonry').masonry();
        }
        }, 1);

        /* Background Image */
        var backgroundImage = $("header, section");
        backgroundImage.each(function () {
            if ($(this).attr("data-img")) {
                if ($(this).parent().hasClass('demo-page')) {
                    $(this).css("background-image", "url(" + $(this).data("img") + ")");
                } else {
                    $(this).css("background-image", "url(" + $(this).data("img") + ")");
                }

            }
        });
        /* Parallax */
        $('.parallax').each(function () {
            var parallaxSpeed = $(this).data('speed') ? $(this).data('speed') : 0.1;
            $(this).parallax("50%", parallaxSpeed);
        });
        
        /**** To Search ****/
        if ($('.region_not_transparent .header-info').length) {
            $('.region_not_transparent .main_section_normal').css('margin-top', $('.topnav').height());
        }

        if($(".header-info .contact-info").length < 1 && $(".header-info .region_detail").length < 1){
            $( ".header-info" ).addClass("header_infodetail");    
        }
        
        $('.toggle-header-index a').on('click', function (e) {
            e.preventDefault();
            $('.header-info-toggle').toggleClass('index-open');
        });
        $('.search-close a').on('click', function (e) {
            e.preventDefault();
            $('.form-search').removeClass('search-open');
        });
        handleiCheck();
        showTooltip();
        scrollTop();
    });
// Handles custom checkboxes & radios using jQuery iCheck plugin
    function handleiCheck() {
        if (!$().iCheck)
            return;
        $(':checkbox:not(.js-switch, .switch-input, .switch-iphone, .onoffswitch-checkbox, .ios-checkbox, .facetapi-checkbox, .ajax-processed), :radio:not(.form-input-radio)').each(function () {
            var checkboxClass = $(this).attr('data-checkbox') ? $(this).attr('data-checkbox') : 'icheckbox_minimal-grey';
            var radioClass = $(this).attr('data-radio') ? $(this).attr('data-radio') : 'iradio_minimal-grey';
            if (checkboxClass.indexOf('_line') > -1 || radioClass.indexOf('_line') > -1) {
                $(this).iCheck({
                    checkboxClass: checkboxClass,
                    radioClass: radioClass,
                    insert: '<div class="icheck_line-icon"></div>' + $(this).attr("data-label")
                });
            } else {
                $(this).iCheck({
                    checkboxClass: checkboxClass,
                    radioClass: radioClass
                });
            }
        });
    }

    /* Image Zoom */
    function imageZoom() {
        if ($('.portfolioContainer').length && $.fn.magnificPopup) {

            $('.portfolioContainer').magnificPopup({
                type: 'image',
                delegate: '.magnific',
                gallery: {enabled: true}
            });
        }
        else {
            if ($('.magnific').length && $.fn.magnificPopup) {

                $('.magnific').magnificPopup({
                    type: 'image',
                    closeOnContentClick: true,
                    closeBtnInside: false,
                    fixedContentPos: true,
                    mainClass: 'mfp-no-margins mfp-with-zoom', // class to remove default margin from left and right side
                    image: {
                        verticalFit: true
                    },
                    zoom: {
                        enabled: true,
                        duration: 300 // don't foget to change the duration also in CSS
                    }
                });
            }

        }

    }

    /* Handle Aside Fixed */
    function handleFixedColumn() {
        var fixedcustom = 50;
//        EDIT IF HAVE FIXED HEADER
        var topScroll = $(document).scrollTop();
        if ($('.portfolio-single .col-md-8').length) {
            var topPortfolioSingle = $('.portfolio-single .col-md-8').offset().top;
        }
        if (topPortfolioSingle < topScroll) {
            if ($('.portfolio-single').length) {
                var portfolioGalleryHeight = $('.portfolio-single .col-md-8').height();
                //console.log(portfolioGalleryHeight );
                var portfolioTextHeight = $('.portfolio-single .col-md-4').height();
                //console.log(portfolioTextHeight);
                var differenceHeight = portfolioGalleryHeight - portfolioTextHeight;
                var fixedscroll = portfolioGalleryHeight - portfolioTextHeight;
                $('.fixed-column').css('margin-top', topScroll - topPortfolioSingle + fixedcustom);
                // 50 : Fixed-column margin top when scroll load
                //console.log(fixedscroll);
                if (fixedscroll + topPortfolioSingle < topScroll) {
                    $('.fixed-column').css('margin-top', fixedscroll);
                    //console.log('fixed');
                }
            }
            else {
                $('.fixed-column').css('margin-top', topScroll);
            }
        }
        else {
            $('.fixed-column').css('margin-top', 0);
        }
    }

    /* Fade Text / Element on Scroll */
    function fadeText() {
        var topScroll = $(document).scrollTop();
        if ($('.fade-text').length && topScroll <= headerHeight) {
            $('.fade-text').css('opacity', (1 - topScroll / headerHeight * 1));
        }
    }

    /* Text Rotation */
    function rotateText() {
        $('[data-plugin-rotate-text]:not(.manual), .rotate-text:not(.manual)').each(function () {
            var $this = $(this), opts = null,
                    pluginOptions = $this.data('plugin-options'),
                    defaults = {
                        "animation": "dissolve", // Options are dissolve (default), fade, flip, flipUp, flipCube, flipCubeUp and spin.
                        "separator": ",", // If you don't want commas to be the separator, you can define a new separator (|, &, * etc.) by yourself using this field.
                        "speed": 3500  // How many milliseconds until the next word show.
                    };
            opts = $.extend({}, defaults, pluginOptions);
            $this.textrotator(opts);
        });
    }

    /* Progress Bar */
    function progressBar() {
        var progressBar = $(".progress-bar");
        setTimeout(function () {
            progressBar.each(function (indx) {
                $(this).css("width", $(this).attr("aria-valuenow") + "%");
                $(this).find('span').css("opacity", 1);
            });
        }, 1000);
    }

    /* Show Tooltip */
    function showTooltip() {
        if ($('[data-rel="tooltip"]').length && $.fn.tooltip) {
            $('[data-rel="tooltip"]').tooltip();
        }
    }

    /* Scroll to top button */
    function scrollTop() {
        if ($(this).scrollTop() > 100)
            $('.scrollup').fadeIn();
        else
            $('.scrollup').fadeOut();
        $(window).scroll(function () {
            if ($(this).scrollTop() > 100)
                $('.scrollup').fadeIn();
            else
                $('.scrollup').fadeOut();
        });
        $('.scrollup').click(function () {
            $("html, body").animate({
                scrollTop: 0
            }, 1000);
            return false;
        });
    }


    /**** NAVIGATION ****/
    function handleNavigation() {
        /* Navbar fix */
        $('.navbar-nav .dropdown a').on('mouseenter', function () {
            $('.navbar-nav .dropdown a').removeClass('open');
        });
        /* One Page Main navigation */
        if ($('.menu_one_page').length) $('html').addClass('one-page');
        if ($('html').hasClass('one-page')) {
            $('.nav').onePageNav({
                currentClass: 'current',
                scrollSpeed: 1000,
                easing: 'easeInOutQuint',
                filter: ':not(.toggle-header-index)'
            });
        }
    }

    /* Navbar Height / Background on Scroll */
    function navbarScroll(topnav, topnavHeight) {
        var topScroll = $(window).scrollTop();
        if (topnav.length > 0) {
            if (topScroll >= $('#topbar-hold').height()) {
                topnav.removeClass('topnav-top');
                if (!topnav.hasClass('bg-black') && !topnav.hasClass('bg-white'))
                    topnav.removeClass('transparent');
            } else {
                topnav.addClass('topnav-top');
                if (!topnav.hasClass('bg-black') && !topnav.hasClass('bg-white'))
                    topnav.addClass('transparent');
            }
        }
    };
    /* Portfolio Isotope */

    function portfolioIsotope() {
        if ($('.portfolioContainer').length) {
            var $container = $('.portfolioContainer');
            $container.isotope();
            $('.portfolioFilter a').click(function () {
                $('.portfolioFilter .current').removeClass('current');
                $(this).addClass('current');
                var selector = $(this).attr('data-filter');
                $container.isotope({
                    filter: selector,
                    transitionDuration: "0.6s",
                    masonryHorizontal: {
                        rowHeight: 360
                    }
                });
                return false;
            });
        }
    }
    function adtIsotope() {
        if ($('.adtIsotope').length) {
            var $container = $('.adtIsotope');
            /*alert('isotope');*/
            $container.isotope(/*{
                   
                    transitionDuration: "0.6s",
                    masonry: {
                        columnWidth: 260,
                        isFitWidth: true
                    }
                }*/);
            $('.adtIsotopeFilter a').click(function () {
                $('.adtIsotopeFilter .current').removeClass('current');
                $(this).addClass('current');
                var selector = $(this).attr('data-filter');
                $container.isotope({
                    filter: selector,
                    transitionDuration: "0.6s",
                    masonry: {
                        columnWidth: 260,
                        isFitWidth: true
                    }
                });
                return false;
            });
        }
    }
    $(window).bind("load", function () {
        portfolioIsotope();
        adtIsotope();
    }
    );
    $(window).resize(function () {
        portfolioIsotope();
        adtIsotope();
        //$('figure:hidden').css("display", "block");
    });
        $('a').not('[href*="mailto:"]').each(function () {
                if(this.href!='javascript:window.print()'){
                    var isInternalLink = new RegExp('/' + window.location.host + '/');
                    if ( ! isInternalLink.test(this.href) ) {
                            $(this).attr('target', '_blank');
                    }
                    
                }
        });
                $('a[href$=".pdf"]').each(function () {                
                            $(this).attr('target', '_blank');
                });

        
     var sidebarheight, mainheight;
    var cushion = 0; // cushion for spapping to the bottom 
    function measureheight() {
        //sidebarheight = $('.sidebar').outerHeight() + cushion;
        console.log(sidebarheight);
        mainheight = $('.liste_circuits').outerHeight();
        //Si pas mobile largeur > 780px
        if($('body').outerWidth()>768){
            $('.col-carte-view').css("height", mainheight); 
            console.log(mainheight);

        } else {
            //si mobile
              $('.col-carte-view').css("height", $('#map_canvas').outerHeight());
              // $().Waypoints('destroy');
            }
        
    };
    measureheight();
    $(window).resize(measureheight);
    
    /**
     * Custom Tooltip
     */
    
    

        var originalLeave = $.fn.tooltip.Constructor.prototype.leave;
        $.fn.tooltip.Constructor.prototype.leave = function(obj){
          var self = obj instanceof this.constructor ?
            obj : $(obj.currentTarget)[this.type](this.getDelegateOptions()).data('bs.' + this.type)
          var container, timeout;

          originalLeave.call(this, obj);

          if(obj.currentTarget) {
            container = $(obj.currentTarget).siblings('.tooltip')
            timeout = self.timeout;
            container.one('mouseenter', function(){
              //We entered the actual popover – call off the dogs
              clearTimeout(timeout);
              //Let's monitor popover content instead
              container.one('mouseleave', function(){
                $.fn.tooltip.Constructor.prototype.leave.call(self, self);
              });
            });
          }
        };

    /** end tooltip**/
    //$('[data-toggle="tooltip"]').tooltip(); 
    $('body').tooltip({ selector: '[data-toggle]', trigger: 'click hover', placement: 'bottom auto', delay: {show: 50, hide: 400}});; 
        
})(jQuery);



  

