<?php

/**
 * @file
 * Template to display a view as a table.
 *
 * - $title : The title of this group of rows.  May be empty.
 * - $header: An array of header labels keyed by field id.
 * - $header_classes: An array of header classes keyed by field id.
 * - $fields: An array of CSS IDs to use for each field id.
 * - $classes: A class or classes to apply to the table, based on settings.
 * - $row_classes: An array of classes to apply to each row, indexed by row
 *   number. This matches the index in $rows.
 * - $rows: An array of row items. Each row is an array of content.
 *   $rows are keyed by row number, fields within rows are keyed by field ID.
 * - $field_classes: An array of classes to apply to each field, indexed by
 *   field id, then row number. This matches the index in $rows.
 * @ingroup views_templates
 */
drupal_add_css(path_to_theme() . '/css/liste_circuits.css');
drupal_add_js(path_to_theme() . '/js/liste_circuits.js');

$nodeType = NULL;

//-- recherche le type de contenu associé à la vue
if (property_exists($view, 'filter') && key_exists('type', $view->filter))
{
    foreach($view->filter['type']->value as $val)
    {
        $nodeType = $val;
        $nodeType = substr($nodeType, 10); //-- supprime le préfixe adt (clone_adt_), pour une raison "esthétique"
        break;
    }
}

//-- créé le lien vers la carte
if ($nodeType != NULL)
{    
    print '<a href="/carte/'. $nodeType .'" id="btn_carte_generale">Afficher les résultats sur la carte</a>';
}
?>

<table <?php if ($classes) { print 'class="'. $classes . '" '; } ?><?php print $attributes; ?>>
  <?php if (!empty($title)) : ?>
    <caption><?php print $title; ?></caption>
  <?php endif; ?>
  <?php if (!empty($header)) : ?>
    <thead>
      <tr>
        <?php foreach ($header as $field => $label): ?>
          <th <?php if ($header_classes[$field]) { print 'class="'. $header_classes[$field] . '" '; } ?>>
            <?php 
                print $label;
                
                if (key_exists($field, $view->style_plugin->options['info'])
                        && key_exists('sortable', $view->style_plugin->options['info'][$field])):
            ?>
              <img class="sortable-icon" src="<?php print IMAGESURL ?>sortable_icon.png" />
            <?php
                endif;
            ?>
          </th>
        <?php endforeach; ?>
      </tr>
    </thead>
  <?php endif; ?>
  <tbody>
    <?php foreach ($rows as $row_count => $row): ?>
      <tr <?php if ($row_classes[$row_count]) { print 'class="' . implode(' ', $row_classes[$row_count]) .'"';  } ?>>
        <?php foreach ($row as $field => $content): ?>
          <td <?php if ($field_classes[$field][$row_count]) { print 'class="'. $field_classes[$field][$row_count] . '" '; } ?><?php print drupal_attributes($field_attributes[$field][$row_count]); ?>>
              <div style="position:relative;">  
              <?php
                print $content;
                ?>
              </div>
          </td>
        <?php endforeach; ?>
      </tr>
    <?php endforeach; ?>
  </tbody>
</table>