<?php

/**
 * @file
 * This template is used to print a single field in a view.
 *
 * It is not actually used in default Views, as this is registered as a theme
 * function which has better performance. For single overrides, the template is
 * perfectly okay.
 *
 * Variables available:
 * - $view: The view object
 * - $field: The field handler object that can process the input
 * - $row: The raw SQL result that can be used
 * - $output: The processed output that will normally be used.
 *
 * When fetching output from the $row, this construct should be used:
 * $data = $row->{$field->field_alias}
 *
 * The above will guarantee that you'll always get the correct data,
 * regardless of any changes in the aliasing that might happen if
 * the view is modified.
 */

require_once('sites/all/libraries/utils.php');
    
$data = $row->field_field_adt_node_xml_data[0]['raw']['value'];
$xml = simplexml_load_string($data);
$obj = $xml->obj;
//dpm(print_r($obj, true));
$img = $obj->xpath('obj_common/photo/ass_obj_photo[doctype="photo" and vignette=1]/fic_z');
if (!$img || empty($img)) $img = $obj->xpath('obj_common/photo/ass_obj_photo[doctype="photo"]/fic_z');



$output = '';

if ($img && !empty($img))
{
    $img = (string) $img[0][0];
    $output .= '<div class="liste_activites_item_img">';
    $output .= ' <img src="' . variable_get('adt_pictures_path') . $img . '" />';
    $output .= '</div>';
}

$output .= '<div class="liste_activites_item_infos">';
$output .= '<p class="descriptif">' . limitWords($obj->descriptif_fr, 30) . '</p>';
$output .= '<p class="localite"><span class="infos_value">' . $obj->adresse1 . '</span></p>';
$output .= '<p class="localite"><span class="infos_value">'. $obj->cp . ' ' .$obj->localite . '</span></p>';
$output .= '<p class="tel"><span class="infos_value">' . $obj->obj_common->tel1 . '</span></p>';
$output .= '<p class="mel"><span class="infos_value"><a href="mailto:' . $obj->obj_common->mel1 . '">'. $obj->obj_common->mel1 .'</a></span></p>';
$output .= '</div>';

$output .= '<a class="lien_ajout_carnet lien_ajout_carnet_small" href="/carnet/add/'.$obj->id.'"></a>';

print $output;
?>