<?php
    
    require_once('sites/all/themes/bouger_nature/templates/fiches_activites/fiche-onglets.inc');

    function getInfosTechniques($xml)
    {
        $output = '';
        
        if (property_exists($xml, 'localite'))
        {
            $output .= '<p><span class="info_tech_value">'. $xml->localite .'</span></p>';
        }
        
        //-- infos spécifiques aux randos :
        if (property_exists($xml->obj_common, 'obj_rap_spec'))
        {
            //-- type de circuit
            if (property_exists($xml->obj_common->obj_rap_spec, 'itinérant'))
            {
                if (strtolower($xml->obj_common->obj_rap_spec->itinérant) == 'itinérant')
                {
                    $output .= '<p><span class="info_tech_value">Circuit itinérant</span></p>';
                }
                else
                {
                    $output .= '<p><span class="info_tech_value">Circuit non itinérant</span></p>';
                }
            }
            
            //-- niveau
            if (property_exists($xml->obj_common->obj_rap_spec, 'niveau'))// && $xml->obj_common->obj_rap_spec->niveau != '')
            {
                $diff_labels = array('Facile', 'Moyen', 'Soutenu' );
                $difficulty = strip_tags($xml->obj_common->obj_rap_spec->niveau)-1;
                
                if ($difficulty >= 0 && $difficulty <= count($diff_labels))
                    $output .= '<p>Niveau de difficulté : <span class="info_tech_value">'. $diff_labels[$difficulty] .'</span></p>';
            }
            //-- duree
            if (property_exists($xml->obj_common->obj_rap_spec, 'duree'))// && $xml->obj_common->obj_rap_spec->duree != '')
            {
                $output .= '<p>Durée : <span class="info_tech_value">'. $xml->obj_common->obj_rap_spec->duree .'</span></p>';
            }
            //-- longueur
            if (property_exists($xml->obj_common->obj_rap_spec, 'longueur'))// && $xml->obj_common->obj_rap_spec->longueur != '')
            {
                $output .= '<p>Longueur : <span class="info_tech_value">'. $xml->obj_common->obj_rap_spec->longueur .' km</span></p>';
            }
            //-- lieu de départ
            if (property_exists($xml->obj_common->obj_rap_spec, 'lieu_precis_depart'))// && $xml->obj_common->obj_rap_spec->lieu_precis_depart != '')
            {
                $output .= '<p>Lieu de départ : <span class="info_tech_value">'. $xml->obj_common->obj_rap_spec->lieu_precis_depart .'</span></p>';
            }
            
        }
        
        return $output;
    }
?>