<?php
    drupal_add_css(path_to_theme() . '/css/fiche_activite.css');
    
    $rawXML = $node->field_adt_node_xml_data['und'][0]['value'];
    $xml = new SimpleXMLElement($rawXML);
    $xml = $xml->obj;
    
    require_once('sites/all/libraries/utils.php');
    $tabContents = xml2array($rawXML);
    
    $output = '';
    
    //dpm($tabContents);
    
    /*
     * Galerie d'images :
     */
    if (property_exists($xml->obj_common, 'photo') && property_exists($xml->obj_common->photo, 'ass_obj_photo'))
    {
        $numPhotos = count($xml->obj_common->photo->ass_obj_photo);
        
        if ($numPhotos > 0)
        {
            //drupal_add_js(THEMEURL . 'js/galerie_fiche.js');
            //dpm($numPhotos);
            $output .= '<div id="galerie_fiche">';
            
            foreach ($xml->obj_common->photo->ass_obj_photo as $photo)
            {
                $url = $photo->fic_m;
                $ext = strtolower(substr($url, strrpos($url, '.') + 1));
                
                if ($ext == 'jpg' || $ext == 'jpeg' || $ext == 'gif' || $ext == 'png' || $ext == 'tiff')
                {
                    $output .= '<img src="'. variable_get('adt_pictures_path') . $url .'" />';
                }
            }
            $output .= '</div>';
        }
    }
    
    
    /*
     * Descriptif :
     * (on va chercher soit dans un champ du noeud, soit dans le xml)
     */
    $output .= '<div id="descriptif_fiche">';
    if (isset($node->field_descriptif))
    {
        $output .= $node->field_descriptif['und'][0]['value'];
    }
    else if (property_exists($xml, 'descriptif_fr'))
    {
        $output .= $xml->descriptif_fr;
    }
    $output .= '</div>';
    
    /*
     *  Bloc "infos" :
     *  (affiché sur la droite de la fiche)
     */
    $output .= '<div id="bloc_info_fiche">';

    if (property_exists($xml, 'localite'))
    {
        $output .= '<p>'. $xml->localite .'</p>';
    }
    
        /*
         *  Infos spécifiques aux randonnées :
         *  TODO : faire la même chose pour les autres activités
         */
        if (property_exists($xml->obj_common, 'obj_rap_spec'))
        {
            if (property_exists($xml->obj_common->obj_rap_spec, 'niveau') && $xml->obj_common->obj_rap_spec->niveau != '')
            {
                $output .= '<p>Niveau de difficulté : <strong>'. $xml->obj_common->obj_rap_spec->niveau .'</strong></p>';
            }
            if (property_exists($xml->obj_common->obj_rap_spec, 'duree') && $xml->obj_common->obj_rap_spec->duree != '')
            {
                $output .= '<p>Durée : <strong>'. $xml->obj_common->obj_rap_spec->duree .'</strong></p>';
            }
            if (property_exists($xml->obj_common->obj_rap_spec, 'longueur') && $xml->obj_common->obj_rap_spec->longueur != '')
            {
                $output .= '<p>Longueur : <strong>'. $xml->obj_common->obj_rap_spec->longueur .'</strong></p>';
            }
            if (property_exists($xml->obj_common->obj_rap_spec, 'lieu_precis_depart') && $xml->obj_common->obj_rap_spec->lieu_precis_depart != '')
            {
                $output .= '<p>Lieu de départ : <strong>'. $xml->obj_common->obj_rap_spec->lieu_precis_depart .'</strong></p>';
            }
        }
    
    $output .= '</div>';
    
    print $output;
 ?>