<?php

    drupal_add_css(path_to_theme() . '/css/fiche_activite.css');
    drupal_add_js(path_to_theme() . '/js/fiche_onglets.js');
    
    require_once('sites/all/libraries/utils.php');
    require_once(path_to_theme() . '/templates/gallerie_diaporama.inc');
    
    //-- extraction des données XML
    $rawXML = $node->field_adt_node_xml_data['und'][0]['value'];
    $xml = new SimpleXMLElement($rawXML);
    $xml = $xml->obj;
    
    //-- transformation en tableau pour explorer plus facilement les champs xml
    //$tabContents = xml2array($rawXML);
    //dpm($tabContents);
    // dpm(print_r($xml, true));
    //dpm($node);
    
    //-- Fonction destinée à être réécrite dans les templates individuels :
    if (!function_exists('getInfosTechniques')) {
        function getInfosTechniques($xml) { return ''; }
    }
    
    $output = '';
    $texteTechnique = getTexteTechnique($node, $xml);
    $infosTechniques = getInfosTechniques($xml);        //-- cette fonction doit être surchargée dans chaque template
    $textePatrimoine = getTextePatrimoine($node, $xml);
    $texteNature = getTexteNature($node, $xml);
    
    /********************************************************************************/
    /**
     *      Extraction de données :
     */
    
    $pdfLink = buildPDFLink(getPDF($xml, 'TECHN'));
    $type_presta=strtoupper(substr($xml->id,0,3));
    $mailtopb = variable_get('mail_signaler_probleme');
    if($type_presta=="RAV") $mailtopb=variable_get('mail_signaler_probleme_rav');
    
    $mailLink = '<a class="lien_signaler_probleme '. $type_presta.'" href="mailto:'.$mailtopb.'?subject=Problème sur la fiche ' . $xml->id . '">Signaler un problème</a>';
    
    /********************************************************************************/
    
     /**
      *     Menu onglets :
      */
    $output .= '<ul id="menu_onglets" rel="' . $xml->id . '">';
    $output .= '    <li class="btn_onglet btn_onglet_actif btn_onglet_first" id="btn_onglet_technique">Fiche technique</li>';
    
    if ($textePatrimoine)
    $output .= '    <li class="btn_onglet" id="btn_onglet_patrimoine">Patrimoine</li>';
    
    if ($texteNature)
    $output .= '    <li class="btn_onglet" id="btn_onglet_nature">Nature</li>';
    
    $output .= '    <li class="btn_onglet" id="btn_onglet_carte">Carte interactive</li>';
    
    $output .= '    <div id="share_links">' . render($content['links']) . '</div>';
    
    $output .= '    <div id="bordure_gauche"></div>';
    $output .= '</ul>';
    
    $output .= '<h1 class="titre_fiche">' . $node->title . '</h1>';
    
    $output .= '<div id="conteneur_onglets">';
    
    
    
    
    /********************************************************************************/
    
     /**
      *     Onglet FICHE TECHNIQUE :
      */
    $output .= '<div id="onglet_technique" class="onglet_fiche">';
    
        //-- Bandeau de gauche :
        $output .= '<div class="bandeau_gauche">';  
            //-- Espace perso
            $output .= '<a class="lien_ajout_carnet" href="/carnet/add/'.$xml->id.'"></a>';
            //-- Galerie technique
            $output .= buildGalleryA(getPhotos('TECHN', $xml));
            //-- PDF
            $output .= $pdfLink;
            //--GPX
            $output .= '<a href="/carnet/download?file='.getKml($xml).'&type=gpx"><img alt="GPX" src="'.IMAGESURL.'btn_gpx.png" /></a>';
            //--KML
            $output .= '<a href="/carnet/download?file='.getKml($xml).'&type=kml""><img alt="KML" src="'.IMAGESURL.'btn_kml.png" /></a>';
            //-- Signaler un pb
            $output .= $mailLink;
        $output .= '</div>';
            
        //-- Descriptif :
        $output .= '<div class="texte_onglet" id="texte_technique">';
        $output .= $texteTechnique;
        $output .= '</div>';
        
        //-- Infos techniques :
        $output .= '<div class="bloc_infos_technique">';
        $output .= $infosTechniques;
        $output .= '</div>';
        
    $output .= '</div>';
    
    
    /********************************************************************************/
    
    /**
     *    Onglet PATRIMOINE :
     */
    if ($textePatrimoine)
    {
        $output .= '<div id="onglet_patrimoine" class="onglet_fiche">';

            //-- Bandeau de gauche :
            $output .= '<div class="bandeau_gauche">';
                //-- Espace perso
                $output .= '<a class="lien_ajout_carnet" href="/carnet/add/'.$xml->id.'"></a>';
                //-- PDF
                $output .= $pdfLink;            
                //-- Galerie patrimoine
                $output .= buildGalleryB(getPhotos('PATRI', $xml));
                //-- Signaler un pb
                $output .= $mailLink;
            $output .= '</div>';

            //-- Descriptif :
            $output .= '<div class="texte_onglet" id="texte_patrimoine">';
            $output .= $textePatrimoine;
            $output .= '</div>';

        $output .= '</div>';
    }
    
    /********************************************************************************/
    
    /**
     *    Onglet NATURE :
     */
    if ($texteNature)
    {
        $output .= '<div id="onglet_nature" class="onglet_fiche">';

            $output .= '<div class="bandeau_gauche">';
                //-- Espace perso
                 $output .= '<a class="lien_ajout_carnet" href="/carnet/add/'.$xml->id.'"></a>';
                //-- PDF
                $output .= $pdfLink;
                //-- Galerie nature
                $output .= buildGalleryB(getPhotos('NATUR', $xml));
                //-- Signaler un pb
                $output .= $mailLink;
            $output .= '</div>';

            //-- Descriptif :
            $output .= '<div class="texte_onglet" id="texte_nature">';
            $output .= $texteNature;
            $output .= '</div>';

        $output .= '</div>';
    }
    
    /********************************************************************************/
    
    /**
     *    Onglet CARTE INTERACTIVE :
     */
    require_once('gmap_fiche_circuit.php');
    
    $output .= '<div id="onglet_carte" class="onglet_fiche">';
        $output .= getGMapFiche($node);
    $output .= '</div>';
    
    
    /********************************************************************************/
    
    
    
    //-- fin du div #conteneur_onglets
    $output .= '</div>';
    
    print $output;
    
    
    
    /********************************************************************************/
    /********************************************************************************/
    /********************************************************************************/
    
    /**
     *  Fonctions pour extraire les données du XML ou des champs du noeud :
     */
    function getTexteTechnique($node, $xml)
    {
        return extraitTexte($node, $xml, 'field_texte_technique', 'TECHN');
    }
    function getTextePatrimoine($node, $xml)
    {
        return extraitTexte($node, $xml, 'field_texte_patrimoine', 'PATRI');
    }
    function getTexteNature($node, $xml)
    {
        return extraitTexte($node, $xml, 'field_texte_nature', 'NATUR');
    }
    
    function extraitTexte($node, $xml, $fieldName, $typeDescriptif)
    {        
        $output = '';
        
        //-- on va chercher soit dans un champ du noeud, soit dans le xml :
        if (isset($node->{$fieldName}))
        {
            //-- on prend la valeur 'safe' si elle existe (préserve le formatage HTML)
            if (isset($node->{$fieldName}['und'][0]['safe_value']))
                $output = $node->{$fieldName}['und'][0]['safe_value'];
            else if (!empty($node->{$fieldName}))
               $output = nl2br2($node->{$fieldName}['und'][0]['value']);
            else
                return FALSE;
        }
        else if (property_exists($xml->obj_common, 'siteaff_desc'))
        {
            //-- si le champ n'existe pas, on va chercher manuellement dans le XML
            $data = $xml->xpath('obj_common/siteaff_desc/ass_obj_siteaff_desc[type_descriptif="'.$typeDescriptif.'"]/descriptif_spec');
            
            //-- retourne FALSE si la valeur n'existe pas => l'onglet ne sera pas créé
            if (!$data) return FALSE;
            
            $output = nl2br2($data[0][0]);
        }
        else
        {
            //-- retourne FALSE si le champ n'existe pas => l'onglet ne sera pas créé
            return FALSE;
        }
        
        $output = html_entity_decode($output);
        
        //-- ajoute un espace si il n'y a pas de texte pour que le div soit pris en compte
        if ($output == '') $output = '&nbsp;';
        
        return $output;
    }
    
    function getPhotos($type, $xml)
    {
        $tabPhotos = array();
        
        if (property_exists($xml->obj_common, 'photo') && property_exists($xml->obj_common->photo, 'ass_obj_photo'))
        {
            $xmlPhotos = $xml->obj_common->photo->ass_obj_photo;
            $numPhotos = count($xmlPhotos);
            
            if ($numPhotos > 0)
            {
                foreach($xmlPhotos as $xmlPhoto)
                {    
                    /*  DEBUG :*/
                    /*dpm($xmlPhoto);
                    foreach($xmlPhoto as $k=>$v){
                        dpm($k.':'.$v);
                    }*/
                    
                    if ($xmlPhoto->doctype == 'photo' && $xmlPhoto->type_descriptif == $type)
                    {
                        
                        //$href = $xmlPhoto->fic_o;
                        //$ext = substr($href, strrpos($href, '.') + 1);                        
                        //if ($ext != 'pdf')
                            $tabPhotos[] = $xmlPhoto;
                    }
                }
            }
        }
        
        return $tabPhotos;
    }
    
    function buildGalleryA($tabPhotos)
    {
        $images = array();
        
        //-- transforme en tableau compatible avec creeDiaporama()
        foreach($tabPhotos as $photo)
        {
            $images[] = array(
                'path' => variable_get('adt_pictures_path') . $photo->fic_o,
                'title' => $photo->copyright,
                'alt' => $photo->titre,
            );
        }
        
        //-- méthode définie dans gallerie_diaporama.inc
        return creeDiaporama($images);
    }
    
    function buildGalleryB($tabPhotos)
    {
        $output = '<div class="galerie_onglet_b">';
        
        foreach($tabPhotos as $photo)
        {
            $path = variable_get('adt_pictures_path') . $photo->fic_o;
            
            $output .= '<div class="galerie_onglet_item">';
            $output .= '<a href="' . $path . '" rel="shadowbox[gallery]" title="' . $photo->titre . '">';
	    if( $photo->titre!='')$photo->copyright=$photo->titre .' - '. $photo->copyright;
            $output .= '    <img src="' . $path . '" alt="' . $photo->titre . '" title="' . $photo->copyright . '" />';
            $output .= '</a>';
            $output .= '</div>';
        }
        
        $output .= '</div>';
        
        return $output;
    }
    
    function getPDF($xml, $type)
    {
        /*
         *  Le fichier PDF est contenu dans un noeud photo.
         *  Il faut donc explorer chaque photo et tester son extension pour trouver le PDF
         *  -> possib de rajouter une clé pour accélérer ?
         */
        if (property_exists($xml->obj_common, 'photo') && property_exists($xml->obj_common->photo, 'ass_obj_photo'))
        {
            $xmlPhotos = $xml->obj_common->photo->ass_obj_photo;
            $numPhotos = count($xmlPhotos);
            
            if ($numPhotos > 0)
            {
                foreach($xmlPhotos as $xmlPhoto)
                {
                    if ($xmlPhoto->doctype == 'PDF' && $xmlPhoto->type_descriptif == $type)
                    {                    
                        //$href = $xmlPhoto->fic_o;
                        //$ext = substr($href, strrpos($href, '.')+1);

                        //if ($ext == 'pdf')
                        return $xmlPhoto;
                    }
                }
            }
        }
    }
    
    function buildPDFLink($pdf)
    {
        if (!is_object($pdf)) return;
        
        $href = $pdf->fic_o;
        return '<a href="' . variable_get('adt_pictures_path') . $href . '" target="_blank" class="lien_pdf_fiche">Télécharger le topo-guide</a>';
    }
    
    function buildShareLinks($links)
    {
        $currentURL = 'http://' .$_SERVER['HTTP_HOST'] .$_SERVER['REQUEST_URI'];
        $encodedTitle = drupal_get_title(); //urlencode(drupal_get_title());
        $fb = '<a href="http://www.facebook.com/share.php?u='.$currentURL.'&t='.$encodedTitle.'" title="Partager sur Facebook" target="_blank"><img alt="Facebook" src="'.IMAGESURL.'btn_facebook.png" /></a>';
        $tw = '<a href="http://twitter.com/home?status='.$encodedTitle.' '.$currentURL.'" title="Partager sur twitter" target="_blank" rel="nofollow"><img alt="Twitter" src="'.IMAGESURL.'btn_twitter.png" /></a>';
        $links = render($links);
        return $fb . $tw . $links;
    }
?>