<?php

/**
 * Here we override the default HTML output of drupal.
 * refer to http://drupal.org/node/550722
 */
 
//Definition des constantes
global $base_url;
define('BASEURL', $base_url);
define('THEMEURL', base_path().drupal_get_path('theme', 'bouger_nature') . '/');
define('IMAGESURL', THEMEURL . 'images/');

// Auto-rebuild the theme registry during theme development.
if (theme_get_setting('clear_registry'))
{
  // Rebuild .info data.
  system_rebuild_theme_data();
  // Rebuild theme registry.
  drupal_theme_rebuild();
}
// Add Zen Tabs styles
if (theme_get_setting('bouger_nature_tabs')) {
  drupal_add_css( drupal_get_path('theme', 'bouger_nature') .'/css/tabs.css');
}


/**
 *  Implémentation de hook_preprocess_page() :
 */
function bouger_nature_preprocess_page(&$vars, $hook)
{
    drupal_add_library('system', 'ui.draggable');
    
    if (isset($vars['node_title'])) {
      $vars['title'] = $vars['node_title'];
    }

    //-- injecte le formulaire de recherche dans page.tpl.php ($search_box)
    /*$search_form = drupal_get_form('search_form');
    $search_box = drupal_render($search_form);
    $vars['search_box'] = $search_box;*/
    $searchBlock = module_invoke('custom_search', 'block_view', 'recherche_menu');
    $vars['search_block'] = $searchBlock['content'];
    
    /*
     *  Ajoute le chemin en cours dans les settings JS :
     */
    drupal_add_js(array('path' =>
        array(
            'arg0' => arg(0)
        )),
        'setting'
    );
    
    /*
     *  Extraction du block 'carte' si on est sur la page correspondante :
     */
    if (arg(0) == 'carte')
    {
          $mapBlock = module_invoke('mapmodule', 'block_view', 'carte');
          $vars['map_block'] = $mapBlock['content'];
    }
    
    /*
     *  Sinon, choix d'un diaporama :
     */
    else
    {
        $pathAlias = drupal_is_front_page() ? '<front>' : drupal_get_path_alias();
        
        $aliases = array_reverse(explode('/', $pathAlias));
        
        foreach($aliases as $alias)
        {
            $alias = '%' . $alias . '%';
            
            $bgResult = db_query("select entity_id as nid from {field_data_field_aliases_associ_s} where field_aliases_associ_s_value LIKE :path", array(':path' => $alias))
                ->fetchObject();
            
            if ($bgResult)
            {                
                break;
            }
        }
        
        /*$pathAlias = '%' . $pathAlias . '%';
        
        $bgResult = db_query("select entity_id as nid from {field_data_field_aliases_associ_s} where field_aliases_associ_s_value LIKE :path", array(':path' => $pathAlias))
                ->fetchObject();*/
       
        if (!$bgResult)
        {
            $bgResult = db_query("select nid from {node} where type = :t", array(':t'=>'diapo_arr_plan'))
                    ->fetchObject();
        }
        
        if ($bgResult)
        {
            $bgNode = node_load($bgResult->nid);
            $bgOutput = '';
            
            foreach($bgNode->field_images['und'] as $image)
            {
                $bgOutput .= theme('image', array('path' => $image['uri'], 'title' => $image['title']));
            }
            
            $vars['diapo_bg'] = $bgOutput;
        }
    }
}

/**
 *  Implémentation de hook_node_view() :
 */
function bouger_nature_preprocess_node(&$vars)
{    
    $currentURL = 'http://' .$_SERVER['HTTP_HOST'] .$_SERVER['REQUEST_URI'];
    $encodedTitle = urlencode(drupal_get_title());
    //$fb = '<a href="http://www.facebook.com/share.php?u='.$currentURL.'&t='.$encodedTitle.'" title="Partager sur Facebook" target="_blank"><img alt="Facebook" src="'.IMAGESURL.'btn_facebook.png" /></a>';
    //$tw = '<a href="http://twitter.com/home?status='.$encodedTitle.' '.$currentURL.'" title="Partager sur twitter" target="_blank" rel="nofollow"><img alt="Twitter" src="'.IMAGESURL.'btn_twitter.png" /></a>';
    
    $vars['content']['links']['facebook'] = array(
        '#theme' => 'links',
        '#links' => array( 'facebook' => array(
                'href' => 'http://www.facebook.com/share.php?u='.$currentURL.'&t='.$encodedTitle,
                'title' => '<img alt="Facebook" src="'.IMAGESURL.'btn_facebook.png" />',
                'attributes' => array(
                    'title' => 'Partager sur Facebook',
                    'target' => '_blank',
                ),
                'html' => TRUE,
        ))
    );
    
    $vars['content']['links']['twitter'] = array(
        '#theme' => 'links',
        '#links' => array( 'twitter' => array(
                'href' => 'http://twitter.com/share?url='. urlencode($currentURL) . '&text=' . $encodedTitle,
                //'href' => 'http://twitter.com/intent/tweet?url='. urlencode($currentURL),
                'title' => '<img alt="Twitter" src="'.IMAGESURL.'btn_twitter.png" />',
                'attributes' => array(
                    'title' => 'Partager sur twitter',
                    'target' => '_blank',
                ),
                'html' => TRUE,
        ))
    );
}



/**
 * Return a themed breadcrumb trail.
 *
 * @param $breadcrumb
 *   An array containing the breadcrumb links.
 * @return
 *   A string containing the breadcrumb output.
 */
function bouger_nature_breadcrumb($variables)
{
    $breadcrumb = $variables['breadcrumb'];
    $breadcrumbSeparator = '<span class="breadcrumb_separator"> &gt; </span>';
    
    $output = '<div class="breadcrumb">: : :&nbsp;&nbsp;&nbsp;';
    
    if (module_exists('webservice_nodes'))
    {
        $node = menu_get_object();

        if ($node && hasADTClonePrefix($node->type))
        {
            $activite = getActiviteByCloneType($node->type);
            
            $output .= '<a href="/">Accueil</a>' . $breadcrumbSeparator;
            
            $paths = explode('|', $activite->parent_path);
            $titles = explode('|', $activite->parent_title);
            $i = 0;
            
            $parentPath = '';
            
            foreach($paths as $path)
            {            
                $parentPath .= '/' . $path;
                $output .= '<a href="' . $parentPath . '">' . $titles[$i++] . '</a>' . $breadcrumbSeparator;
            }
            
            $output .= '<span class="breadcrumb_node_title">' . $node->title . '</span>';
            $output .= '</div>';
            return $output;
            //drupal_set_breadcrumb($breadcrumb);
        }
        /*else if ($node && $node->type == 'adt21_engine')
        {
            $output .= '<a href="/">Accueil</a>' . $breadcrumbSeparator;
            $output .= '<a href="/">' . $node->title . '</a>' . $breadcrumbSeparator;
            $output .= '</div>';
            return $output;
        }*/
    }
    
    if (!empty($breadcrumb))
    {
        $breadcrumb[] = '<span class="breadcrumb_node_title">' . drupal_get_title() . '</span>';
        $output .= implode($breadcrumbSeparator, $breadcrumb) . '</div>';
        return $output;
    }
}

function bouger_nature_id_safe($string) {
  // Replace with dashes anything that isn't A-Z, numbers, dashes, or underscores.
  $string = strtolower(preg_replace('/[^a-zA-Z0-9_-]+/', '-', $string));
  // If the first character is not a-z, add 'n' in front.
  if (!ctype_lower($string{0})) { // Don't use ctype_alpha since its locale aware.
    $string = 'id'. $string;
  }
  return $string;
}

/**
 * Generate the HTML output for a menu link and submenu.
 *
 * @param $variables
 *  An associative array containing:
 *   - element: Structured array data for a menu link.
 *
 * @return
 *  A themed HTML string.
 *
 * @ingroup themeable
 * 
 */
function bouger_nature_menu_link(array $variables) {
  $element = $variables['element'];
  $sub_menu = '';

  if ($element['#below']) {
    $sub_menu = drupal_render($element['#below']);
  }
  $output = l($element['#title'], $element['#href'], $element['#localized_options']);
  // Adding a class depending on the TITLE of the link (not constant)
  $element['#attributes']['class'][] = bouger_nature_id_safe($element['#title']);
  // Adding a class depending on the ID of the link (constant)
  $element['#attributes']['class'][] = 'mid-' . $element['#original_link']['mlid'];
  return '<li' . drupal_attributes($element['#attributes']) . '>' . $output . $sub_menu . "</li>\n";
}

/**
 * Override or insert variables into theme_menu_local_task().
 */
function bouger_nature_preprocess_menu_local_task(&$variables) {
  $link =& $variables['element']['#link'];

  // If the link does not contain HTML already, check_plain() it now.
  // After we set 'html'=TRUE the link will not be sanitized by l().
  if (empty($link['localized_options']['html'])) {
    $link['title'] = check_plain($link['title']);
  }
  $link['localized_options']['html'] = TRUE;
  $link['title'] = '<span class="tab">' . $link['title'] . '</span>';
}

/**
 * Duplicate of theme_menu_local_tasks() but adds clearfix to tabs.
 */
function bouger_nature_menu_local_tasks(&$variables) {  
  $output = '';

  if (!empty($variables['primary'])) {
    $variables['primary']['#prefix'] = '<h2 class="element-invisible">' . t('Primary tabs') . '</h2>';
    $variables['primary']['#prefix'] .= '<ul class="tabs primary clearfix">';
    $variables['primary']['#suffix'] = '</ul>';
    $output .= drupal_render($variables['primary']);
  }
  if (!empty($variables['secondary'])) {
    $variables['secondary']['#prefix'] = '<h2 class="element-invisible">' . t('Secondary tabs') . '</h2>';
    $variables['secondary']['#prefix'] .= '<ul class="tabs secondary clearfix">';
    $variables['secondary']['#suffix'] = '</ul>';
    $output .= drupal_render($variables['secondary']);
  }

  return $output;
}




/**
 *  Change l'aspect du formulaire de recherche :
 */
function bouger_nature_form_alter(&$form, &$form_state, $form_id)
{
    if ($form_id == 'search_form')
    {
        $form['basic']['keys']['#title'] = '';
        $form['basic']['keys']['#size'] = '15';
        $form['basic']['submit']['#value'] = 'OK';
    }
}


/**
 *  Change l'aspect des tableaux triables :
 *  -> tableaux de circuits
 */
function bouger_nature_tablesort_indicator($variables) {
  if ($variables['style'] == "asc") {
    return theme('image', array('path' => IMAGESURL.'sort_asc_icon.png', 'width' => 8, 'height' => 7, 'alt' => t('sort ascending'), 'title' => t('sort ascending')));
  }
  else {
    return theme('image', array('path' => IMAGESURL.'sort_desc_icon.png', 'width' => 8, 'height' => 7, 'alt' => t('sort descending'), 'title' => t('sort descending')));
  }
}