var x = 0;
var minimum;
var btnHaut, btnBas;

jQuery(document).ready(function()
{
    // variable definissant la cible des boutons si true : contenu principal, si false contenu secondaire
    var focus=true;
    
    var menu = jQuery('.contenu-categorie .menu');
    btnHaut = jQuery('.btn-menu-haut');
    btnBas = jQuery('.btn-menu-bas');
    
    // hauteur du masque
    var hauteurMasque = jQuery(".contenu-categorie").height();

    // hauteur du contenu
    var hauteurContenu = menu.height();
    
    // tests de minimum pour la position (pas d'espaces vides apres les items)
    minimum = hauteurMasque - hauteurContenu + 1;
    
    //-- ajoute une classe "active" au li sélectionné
    var activeLi = menu.find('a.active').parent();
    
    if (activeLi.length > 0)
    {
        activeLi.addClass('active');
        
        x = -activeLi.position().top;
        x += 50;
        
        checkBounds();
        
        //menu.css('top', x + 'px');
        menu.animate({top: x + "px"}, 700);
    }
    else
    {
        // la fleche du haut est masquée car inutile
        desactiveBouton(btnHaut);
    }
    
    btnHaut.click(function()
    {
        if (btnHaut.hasClass('off')) return;
        
        // ajout de l'incrementation de deplacement
        x += hauteurMasque;
        
        checkBounds();

        // déplacement
        menu.animate({top: x + "px"}, 700);
    });

    btnBas.click(function()
    {
        if (btnBas.hasClass('off')) return;
        
        // ajout de l'incrementation de deplacement
        x -= hauteurMasque;
        
        checkBounds();
        
        // déplacement
        menu.animate({top: x + "px"}, 700);
    });
});

function checkBounds()
{
    activeBouton(btnBas);
    activeBouton(btnHaut);
    
    if (x <= minimum)
    {
        x = minimum;            
        desactiveBouton(btnBas);
        return;
    }
    else if (x >=0)
    {
        x = 0;
        desactiveBouton(btnHaut);
    }
}

function desactiveBouton(btn)
{
    btn.css({ opacity: 0.3, cursor: 'auto' });
    btn.addClass('off');
}
function activeBouton(btn)
{
    btn.css({ opacity: 1, cursor: 'pointer' });
    btn.removeClass('off');
}