/*
 * Drupal.behaviors.ajaxHijackErrors
 * HiJack the ajax error reporting in D7. Avoiding the alert box for users
 * http://drupal.org/node/1232416 - comments: #93, #97, #98
 */



/*
 * 
 */
var menuIsDown = false;
var currentMenuItem = null;
var bg;

jQuery(document).ready(function(jQuery)
{
    bg = jQuery('#bg');
    
    jQuery('#primary li a').click(function(evt){
        var elt = this;

        if(jQuery(elt).parent().hasClass('first')){
            //console.log('no submenu');
        }else{
            if (menuIsDown && currentMenuItem == elt)
            {
                slideUpMenu(elt, false);
            }
            else
            {
                slideDownMenu(elt);
            }
            evt.preventDefault();
            return false;
        }
    });
    
    var jContent, jCanvas, mapControls;
    
    jContent = jQuery('#main, #content');
    
    if (Drupal.settings.path.arg0 == 'carte')
        jCanvas = jQuery('#map_canvas');

    //Resize du BG en fcontion de la taille de l'ecran
    jQuery(window).bind('load resize', function()
    {
        var windowHeight = jQuery(window).height();
        bg.height(windowHeight - 130);
        jContent.css("min-height", windowHeight - 130);
        if (Drupal.settings.path.arg0 == 'carte')
        {
            jCanvas.css("min-height", windowHeight - 130);
            
            var windowWidth = jQuery(window).width();
            
            if (windowWidth < 1024) windowWidth = 1024;
            
            if (windowWidth <= 1160)
                jQuery('#map_controls').css('left', ((1 - (1160 - windowWidth) / 136) * 80 + 180) + 'px');
            else jQuery('#map_controls').css('left', '0');
        }
    });

    //Diapo pour le Background (sauf pour la carte)
    if (Drupal.settings.path.arg0 != 'carte')
    {
        if (bg.children().length == 1)
        {
            bg.children().show();
        }
        else
        {            
            bg.cycle({
                slideResize: false, 
                easeIn:'swing', 
                easeOut:'swing', 
                speed:2500,
                after:function(){
                    jQuery('#credits_bg').html(this.title);
                }
            });
        }
    }
    
    //Mise en place des tooltips
    tooltip();
    
    //Auto submit du formulaire de recherche
    jQuery('#form-menu-search').unbind('submit');
    jQuery(document).on('click', '#autocomplete', function(e){
        jQuery('#form-menu-search').submit();
    });
    
    //-- hack pour ne pas afficher les alert ajax lorsque la requête est interrompue avant la fin
    // => vérifier que ça marche...
    Drupal.behaviors.ajaxHijackErrors = {
        attach:function(context, settings){
        if (typeof context !== 'undefined') { //run only if there is a context var
          window.console = window.console || {};
          var methods = ['log', 'warn', 'error'];
          for (var i = 0; i < methods.length; i++) {
            window.console[methods[i]] = window.console[methods[i]] || function() {};
          } //end for

          jQuery.ajaxSetup({
            beforeSend: function(jqXHR, settings) {
              settings.error = function(jqXHR, textStatus, errorThrown) { 
                //end user doesn't need to see debugging info
                {console.log('ajax error: ' + textStatus);};
              }; //end settings.error
            } //end beforeSend
          }); //end $.ajaxSetup
        } // end if (typeof context !== 'undefined')
        } // end attach:function(context, settings)
    } //end Drupal.behaviors.ajaxHijackErrors
});

/*
 * Permet d'écouter le chargement des images même avec la mise en cache :
 */
jQuery.fn.extend({
    ensureLoad: function(handler) {
        return this.each(function() {
            if(this.complete) {
                handler.call(this);
            } else {
                jQuery(this).load(handler);
            }
        });
    }
});

function slideUpMenu(elt, slideDownOnComplete)
{    
    jQuery('#zoneCentre').animate({top:-1 * jQuery('#subnav').height() + 'px'}, 350, 'swing', function()
    {
        menuIsDown = false;
        
        jQuery('#primary li a').removeClass('hover-bg');
        jQuery('#subnav').children().hide();
        
        if (slideDownOnComplete)
        {
            slideDownMenu(currentMenuItem);
        }
        else
        {
            currentMenuItem = null;
        }
    });
}

function slideDownMenu(elt)
{
    currentMenuItem = elt;
    
    if (menuIsDown)
    {
        jQuery('#zoneCentre').stop(true, false);
        slideUpMenu(currentMenuItem, true);
        return;
    }
    
    var eltClasses = jQuery(elt).parent('li').attr('class').split(' ');
    var menuClass = eltClasses[0];
    var menuId = menuClass.substr(5);
    
    jQuery('#subnav').children('#submenu-' + menuId).show();
    //jQuery('#subnav').children('#submenu-' + menuId).css('display', 'inline-block');
    
    menuIsDown = true;
    
    jQuery(elt).addClass('hover-bg');
    
    jQuery('#zoneCentre').animate({top:0}, 400, 'swing', function()
    {
    });
}