//-- variables pour les onglets
var boutonsOnglets;
var nbOnglets;
var currentOngletId = '#onglet_technique';


//-- variables pour la carte
var mapInited = false;
var map;
var idFiche;
var numActiveLayers;
var numLayersReady;


/*
 *  Au chargement du DOM :
 */
jQuery(document).ready(function()
{
    jQuery(currentOngletId).show();

    boutonsOnglets = jQuery('.btn_onglet');
    nbOnglets = boutonsOnglets.length;
    
    boutonsOnglets.eq(1).addClass('btn_onglet_suiv');

    boutonsOnglets.click(function()
    {
        clickOnglet(jQuery(this));
    });    
    
    // lance le processus de synchronisation du noeud
    jQuery.ajax({
        url:'/admin/config/webservice_nodes/synchronisation/sync/' + Drupal.settings.node.nid + '/' + Drupal.settings.node.adt_request_nid,
        type:'POST',
        dataType:'text'
        /*success: function(data){
            console.log('success:');
            console.log(data);
        },
        error: function(data){
            console.log('error : ');
            console.log(data);
        }*/
    });
});

/*
 *  Affichage des onglets
 */
function clickOnglet(elt)
{
    var idBtn = elt.attr('id');     // id du bouton (ex: btn_onglet_technique)
    var idOnglet = idBtn.substr(4); // enlève 'btn_' 
    var onglet = jQuery('#' + idOnglet);
    
    //-- masque tous les onglets
    jQuery(currentOngletId).hide();
    
    //-- rétablit la classe par défaut pour tous les onglets
    boutonsOnglets.removeClass('btn_onglet_suiv').removeClass('btn_onglet_prec').removeClass('btn_onglet_actif');
    
    //-- cherche la position de l'onglet (pour ajouter les ombres)
    var positionOnglet = boutonsOnglets.index(elt);
    
    if (positionOnglet < nbOnglets-1){
        boutonsOnglets.eq(positionOnglet + 1).addClass('btn_onglet_suiv');
    }
    if (positionOnglet > 0){
        boutonsOnglets.eq(positionOnglet - 1).addClass('btn_onglet_prec');
    }
    
    //-- arrête la galerie en cours
    stopGalerie();
    
    currentOngletId = '#' + idOnglet;
    
    //-- affiche l'onglet sur lequel on a cliqué
    onglet.show();
    elt.addClass('btn_onglet_actif');
    
    //-- pour tous les onglets sauf la carte, lance la galerie d'images
    if (idOnglet != 'onglet_carte')
    {
        jQuery('.titre_fiche').show();
        
        //-- lance la galerie du nouvel onglet
        lanceGalerie(jQuery(currentOngletId + ' .galerie_diaporama_inner'));
    }
    
    //-- pour l'onglet carte
    else
    {
        jQuery('.titre_fiche').hide();
        
        activeCarte();
    }

    

    //--Ajout du tracking Google Analytics pour les onglets
    var url = window.location.href.toString().split(window.location.host)[1];
    
    if (typeof _gaq !== 'undefined') _gaq.push(['_trackEvent', 'Onglets', 'Clic page - '+ url, currentOngletId ]);

}





/*
 *  Gestion de la carte interactive :
 */
function activeCarte()
{
    if (!mapInited)
    {
        initCarteFiche();
        
        jQuery('#slider_distance').slider(
        {
            range: "min",
            value: 10,
            min: 1,
            max: 100,
            slide: function( event, ui )
            {
                jQuery('#map_distance').text(ui.value + 'km');
            }
        });
        
        jQuery('#map_distance').text( jQuery('#slider_distance').slider('value') + 'km' );
        
        jQuery('#btn_update_map').click(function()
        {
            majCarte();
        });
    }
}

function initCarteFiche()
{
    var positionOrigine = new google.maps.LatLng(47.1794809355125, 4.5640154570312585);
    
    var mapOptions =
    {
        center: positionOrigine,
        zoom: 11,
        mapTypeId: google.maps.MapTypeId.TERRAIN,
        mapTypeControl: true,
        zoomControl: true,
        panControl: true,
        scaleControl: false,
        streetViewControl: true,
        overviewMapControl: false,

        navigationControlOptions: {
            position: google.maps.ControlPosition.TOP_LEFT
        }
    }
    
    map = new google.maps.Map(document.getElementById('map_canvas_fiche'), mapOptions);
    //console.log(location.protocol +"//"+ location.host+'/sites/all/modules/adt21_carte/parse.php?id=' + idFiche + '&support=NATURE');
    
    //var kmlLayer = new google.maps.KmlLayer('http://flux.cotedor-tourisme.com/kml/itineraire.php?id=' + idFiche);
    var kmlLayer = new google.maps.KmlLayer(location.protocol +"//"+ location.host+'/sites/all/modules/adt21_carte/parse.php?id=' + idFiche + '&support=NATURE');
    kmlLayer.setMap(map);
    
    mapInited = true;
}

var layers = [];

function majCarte()
{
    var distance = jQuery('#slider_distance').slider('value');
    
    numActiveLayers = jQuery('#map_select_type input[type="checkbox"]:checked').length;
    numLayersReady = 0;
    console.log("MAJ map");
    if (numActiveLayers > 0){
        jQuery('#btn_update_map').hide();
        jQuery('#txt_chargement').show();
    }
    
    jQuery('#map_select_type input[type="checkbox"]').each(function()
    {
        console.log("Check MAJ map");
        //var checked = jQuery(this).attr('checked');
        var checked = $(this).prop('checked');
        var typeObj = this.name;
        var layerExists = typeof layers[typeObj] != 'undefined';
        
        //-- si la case n'est pas cochée et que le calque existe
        if (layerExists)
        {
            //-- masque puis détruit le calque
            layers[typeObj].hideDocument();
            delete layers[typeObj];
        }
        
        if (checked)
        {
            //-- construction de la requête
            var params = '{"crit":[{"concept":"dist","champvaleur":"' + idFiche + '","valeur":"' + idFiche + '","operateur":"=","foncteur":"AND"},{"concept":"obj_common","champvaleur":"dist","valeur":"' + distance + '","operateur":"<=","foncteur":"AND"}]}';
            var requete = '//' + document.domain + '/sites/all/modules/adt21_carte/parse.php?type=' + typeObj + '&params=' + encodeURIComponent(params) + '&verf=true';
            //console.log(requete);
            //
            //-- chargement du calque
            var kmlLayer = new geoXML3.parser({map:map, afterParse:layerReady});
            kmlLayer.parse(requete);

            //-- enregistrement du calque
            layers[typeObj] = kmlLayer;
        }
    });
}

function layerReady(data)
{
    if (++numLayersReady == numActiveLayers)
    {    
        jQuery('#btn_update_map').show();
        jQuery('#txt_chargement').hide();
    }
}