<?php

/**
 *  Synchronisation d'un noeud en particulier :
 * 
 *      -> reçoit en GET les paramètres de la requête ADT (+id de la fiche)
 *      -> affiche les différences entre le noeud et le résultat de la requête
 *      -> proposer de synchroniser tout ou partie des champs
 */

function page_synchronisation_noeud($nid)
{     
    //-- charge le noeud correspondant au nid
    $node = node_load($nid);
    
    //-- si le noeud n'existe pas
    if (!$node)
    {
        drupal_set_message("Aucun noeud trouvé pour le nid '" . $nid . "'", 'error');
        drupal_goto(base_path().'admin/config/webservice_nodes/synchronisation');
        return;
    }
    
    drupal_set_title('Synchronisation du noeud "' . $node->title . '"');
    
    //-- prépare la chaîne de sortie
    $output = '';
    
    //-- lance la requête ADT
    $table = $_GET['table'];
    $support = $_GET['support'];
    $params = urldecode($_GET['params']);
    $id = $_GET['id'];
    $rawData = sendDataXMLRequest($table, $support, $params, $id);
    
    //-- extrait les données du noeud
    $nodeData = $node->{variable_get('FIELD_ADT_NODE_XML_DATA')}['und'][0]['value'];
    
    //-- transforme les XML en tableaux pour pouvoir les comparer :
    require_once('sites/all/libraries/utils.php');
    $oldArray = xml2array($rawData);
    $newArray = xml2array($nodeData);
    
    $output .= '<p>Le noeud "' . $node->title . '" n\'est plus à jour. Voici le détail des différences :</p>';
    
    $output .= '<table><tr>';
    $output .= '<th>Clé</th>';
    $output .= '<th>Ancienne valeur</th>';
    $output .= '<th>Nouvelle valeur</th>';
    $output .= '</tr><tr>';
    
    //-- fouille dans les deux tableaux pour trouver les différences :
    $output .= exploreAndCompare($newArray, $oldArray, '');
    
    $output .= '</tr></table>';
    
    $output .= '<p>Voulez-vous synchroniser le noeud avec la base ADT ?</p>';
    
    //-- créé le formulaire de synchronisation
    $output .= render( drupal_get_form('form_synchro_noeud', $nid, $rawData) );
    
    return $output;
}

function exploreAndCompare($array1, $array2, $parents)
{   
    $output = '';
    
    foreach($array1 as $key => $value)
    {
        if (is_array($value))
        {
            if (key_exists($key, $array2))
            {
                $output .= exploreAndCompare($value, $array2[$key], $parents . '/' . $key);
            }
            else
            {
                $output .= '<tr>';
                $output .= '<td>' . $parents . '/' . $key . '</td>';
                $output .= '<td><em>[Array]</em></td>';
                $output .= '<td><em>[NA]</em></td>';
                $output .= '</tr>';
            }
        }
        else
        {
            if (!key_exists($key, $array2) || $value != $array2[$key])
            {
                $output .= '<tr>';
                $output .= '<td>' . $parents . '/' . $key . '</td>';
                $output .= '<td>' . $value . '</td>';
                $output .= '<td>' . (key_exists($key, $array2) ? $array2[$key] : '<em>[NA]</em>') . '</td>';
                $output .= '</tr>';
            }
        }
    }
    return $output;
}



/**
 *  Pour synchroniser un noeud en particulier :
 */
function form_synchro_noeud($form, &$form_state, $nid, $rawData)
{
    $form['nid'] = array(
        '#type' => 'hidden',
        '#value' => $nid,
    );
    
    $form['rawData'] = array(
        '#type' => 'hidden',
        '#value' => $rawData,
    );
    
    $form['submit'] = array(
        '#type' => 'submit',
        '#value' => 'Synchroniser'
    );    
    
    return $form;
}

function form_synchro_noeud_submit($form, &$form_state)
{
    $values = $form_state['values'];
    $nid = $values['nid'];
    $rawData = $values['rawData'];
    
    module_load_include('inc', 'webservice_nodes', 'sync.functions');
    
    updateADTNode($nid, $rawData);
    
    drupal_set_message("Le noeud à bien été synchronisé !");
    drupal_goto(base_path() . 'admin/config/webservice_nodes/synchronisation');
}


?>
