<?php

/**
 *  Formulaire de confirmation pour supprimer une activité :
 */
function form_suppression_activite($form, &$form_state, $idActivite)
{
    $form['idActivite'] = array('#type' => 'value', '#value' => $idActivite);
    
    $activite = getActiviteById($idActivite);

    $message = 'Êtes-vous sûr de vouloir supprimer l\'activité "' . $activite->nom . '"';
    $caption = '<p>Cette action ne peut être annulée</p>';

    return confirm_form($form, $message, 'admin/config/webservice_nodes/activites', $caption, 'Supprimer');
}

/**
 *  Suppression de l'activité :
 */
function form_suppression_activite_submit($form, &$form_state)
{
    $idActivite = $form['idActivite']['#value'];
    
    $activite = getActiviteById($idActivite);
    
    $clonesContentType = $activite->clones_content_type;
    $ADTRequestNid = $activite->adt_request_nid;
    
    //-- recherche tous les noeuds clônés issus de la requête
    $nodes = db_select('node', 'n')
            ->fields('n', array('nid'))
            ->condition('type', $clonesContentType, '=')
            ->execute();
    
    //-- supprime tous les noeuds clônés issus de la requête
    foreach ($nodes as $n)
    {
        node_delete($n->nid);
    }
    
    //-- supprime le type de contenu des noeuds clônés
    node_type_delete($clonesContentType);
    
    //-- supprime le noeud qui stocke les paramètres de la requête
    node_delete($ADTRequestNid);
    
    //-- supprime l'entrée dans la table adt_activités
    db_delete(variable_get('TABLE_ACTIVITES'))
        ->condition('id', $idActivite)
        ->execute();
    
    //-- redirige vers la liste des activités
    drupal_set_message('L\'activité "' . $activite->nom . '" a bien été supprimée');
    drupal_goto('/admin/config/webservice_nodes/activites');
}

?>
