<?php

/**
 *  Formulaire pour sélectionner les champs qui seront extraits automatiquement lors de la
 *  synchronisation des noeuds ADT.
 * 
 *  @param $idActivite L'identifiant de l'activité à traiter 
 */
function form_selection_champs_activite($form, &$form_state, $idActivite)
{
    require_once('sites/all/libraries/utils.php');
    
    //-- recherche l'activité dans la bases
    $activite = getActiviteById($idActivite);
    
    //-- retour à la liste si aucune activité trouvée
    if (!$activite)
    {
        drupal_set_message('Aucune activité trouvée pour l\'id : ' . $idActivite);
        drupal_goto('admin/config/webservice_nodes/activites');
        return;
    }
    
    //-- recherche la requête associée à l'activité
    $requeteADT = node_load($activite->adt_request_nid);
    $table = $requeteADT->{variable_get('FIELD_ADT_TABLE')}['und'][0]['value'];
    $support = $requeteADT->{variable_get('FIELD_ADT_SUPPORT')}['und'][0]['value'];
    $params = $requeteADT->{variable_get('FIELD_ADT_PARAMS')}['und'][0]['value'];
    
    //-- envoie la requête à la base ADT
    $results = sendDataXMLRequest($table, $support, $params, 'all');
    $xmlResults = @simplexml_load_string($results);
    
    //-- vérifie si la requête aboutit et renvoie des résultats
    if (!$xmlResults || count($xmlResults->obj) == 0)
    {
        drupal_set_message('La requête n\'a renvoyé aucun résultat. Veuillez vérifier les paramètres.');
        drupal_goto('admin/config/webservice_nodes/activites' . $idActivite . '/edit');
        return;
    }
    
    //-- extrait le premier résultat
    $firstNode = $xmlResults->obj[0];
    
    //-- renvoie la requête pour obtenir le noeud XML complet
    $tabResult = xml2array(sendDataXMLRequest($table, $support, $params, $firstNode->id));
    $tabResult = $tabResult['objs']['obj'];
    
    //-- parcours la liste des noeuds XML
    exploreXML($tabResult, $form, 'obj');
    
    return $form;
}

function exploreXML($xmlArray, &$form, $fieldset)
{   
    $form[$fieldset] = array(
        '#title' => $fieldset,
        '#type' => 'fieldset',
        '#collapsible' => TRUE,
        '#attributes' => array('class' => array('container-inline')), 
        //'#collapsed' => $fieldset != 'obj',
    );
    
    foreach($xmlArray as $key => $value)
    {
        if (is_array($value))
        {
            if (count($value) > 0)
            {
                exploreXML($xmlArray[$key], $form[$fieldset], $key);
            }
        }
        else
        {
            $sum = strlen($value) > 50 ? (substr($value, 0, 50) . '...') : $value;
            
            $form[$fieldset][$key] = array(
                '#title' => $key,
                '#type' => 'checkbox',
                /*'#description' => 'ex: <em>' . $sum . '</em>',*/
                '#field_prefix' => '&nbsp;&nbsp;',
            );
        }
    }
    
   // return $form;
}

?>
