<?php

/**
 *  Formulaire d'édition d'une activité existante :
 */
function form_edition_activite($form, &$form_state, $idActivite)
{
    require_once('ajout_activite.pages.inc');
    
    //-- recherche l'activité dans la bases
    $activite = getActiviteById($idActivite);
    
    //-- retour à la liste si aucune activité trouvée
    if (!$activite)
    {
        drupal_set_message('Aucune activité trouvée pour l\'id : ' . $idActivite);
        drupal_goto('admin/config/webservice_nodes/activites');
        return;
    }
    
    drupal_set_title('Édition de l\'activité : ' . $activite->nom);
    
    $requeteADT = node_load($activite->adt_request_nid);
    $table = $requeteADT->{variable_get('FIELD_ADT_TABLE')}['und'][0]['value'];
    $support = $requeteADT->{variable_get('FIELD_ADT_SUPPORT')}['und'][0]['value'];
    $params = $requeteADT->{variable_get('FIELD_ADT_PARAMS')}['und'][0]['value'];
    
    /*
     *  Lien pour aller sur la page de sélection des champs :
     */    
    $form['selection_des_champs'] = array(
        '#type' => 'markup',
        '#markup' => '<a href="edit/selection_champs">Paramètres d\'extraction des champs</a>',
    );
    
    
    /**
     *  Valeurs cachées, à transmettre avec le formulaire :
     */
    
    $form['id_activite'] = array(
        '#type' => 'hidden',
        '#value' => $idActivite,
    );
    $form['nid_requete'] = array(
        '#type' => 'hidden',
        '#value' => $activite->adt_request_nid,
    );   
    
    /*
     *  Paramètres généraux :
     */
    
    $form['nom_activite'] = array(
        '#title' => 'Nom de l\'activité',
        '#type' => 'textfield',
        '#default_value' => $activite->nom,
    );
    
    
    /*
     *  Paramètres de la requête ADT :
     */
    $form['adt'] = array(
        '#type' => 'fieldset',
        '#title' => 'Paramètres ADT',
        '#collapsible' => TRUE,
        '#collapsed' => FALSE,
    );
    
    $form['adt']['table'] = array(
        '#type' => 'textfield',
        '#title' => 'Table',
        '#default_value' => $table,
        '#description' => 'Table à interroger dans la base ADT',
        '#required' => TRUE,
    );
    
    $form['adt']['support'] = array(
        '#type' => 'textfield',
        '#title' => 'Support',
        '#default_value' => $support,
        '#description' => 'Support à interroger dans la base ADT',
        '#required' => TRUE,
    );
    
    $form['adt']['params'] = array(
        '#type' => 'textarea',
        '#title' => 'Paramètres',
        '#default_value' => $params,
        '#description' => 'Paramètres de la requête',
        '#required' => TRUE,
    );
    
    
    
    /*
     *  Choix du template associé aux noeuds :
     */
    $form['template'] = array(
        '#type' => 'fieldset',
        '#title' => 'Choix d\'un template',
        '#collapsible' => TRUE,
        '#collapsed' => FALSE,
    );
    
    //-- envoie une requête vers la base pour récupérer la liste des templates
    $templateOptions = getTemplateOptions();
    $currentTemplate = getClonesTemplateById($activite->template_id)->path;
    
    $form['template']['template_path'] = array(
        '#type' => 'select',
        '#title' => 'Chemin du template',
        '#options' => $templateOptions,
        '#default_value' => $currentTemplate,
    );
    
    $form['template']['new_path'] = array(
        '#title' => 'Nouveau template',
        '#type' => 'textfield',
        '#description' => 'Entrez le nom complet du fichier, qui doit commencer par "node--" et avoir l\'extension ".tpl.php". Penser à vider le cache pour que Drupal prenne en compte le nouveau template.'
    );
    
    /*
     *  Chemin parent :
     *  (utilisé pour le fil d'ariane)
     */    
    $form['parent_page'] = array(
        '#type' => 'fieldset',
        '#title' => 'Fil d\'ariane',
        '#description' => 'Informations sur la page où seront listés les noeuds, utilisées pour générer le fil d\'ariane.',
        '#collapsible' => TRUE,
        '#collapsed' => FALSE,
    );
    
    $form['parent_page']['parent_path'] = array(
        '#title' => 'Chemin de la page parente',
        '#type' => 'textfield',
        '#description' => 'Entrez le chemin relatif de la page où seront listés les noeuds, sans mettre de slash (/) devant.<br />Vous pouvez indiquer plusieurs niveaux en séparant les valeurs par des barres verticales (|).',
        '#default_value' => $activite->parent_path,
    );
    
    $form['parent_page']['parent_title'] = array(
        '#title' => 'Titre de la page parente',
        '#type' => 'textfield',
        '#description' => 'Entrez le titre de la page où seront listés les noeuds (affiché dans le fil d\'ariane).<br />Vous pouvez indiquer plusieurs niveaux en séparant les valeurs par des barres verticales (|).',
        '#default_value' => $activite->parent_title,
    );
    
    /*
     *  Submit
     */
    
    $form['submit'] = array(
        '#type' => 'submit',
        '#value' => 'Enregistrer',
    );
    
    return $form;
}



/**
 *  Soumission du formulaire d'édition :
 */
function form_edition_activite_submit($form, &$form_state)
{
    $values = $form_state['values'];
    
    $idActivite = $values['id_activite'];
    $nidRequete = $values['nid_requete'];
    
    $nomActivite = $values['nom_activite'];
    
    $tableADT = $values['table'];
    $supportADT = $values['support'];
    $paramsADT = $values['params'];
    
    $parentPath = $values['parent_path'];
    $parentTitle = $values['parent_title'];
    
    //-- met à jour le noeud adt_request
    $requeteADT = node_load($nidRequete);
    $requeteADT->{variable_get('FIELD_ADT_TABLE')}['und'][0]['value'] = $tableADT;
    $requeteADT->{variable_get('FIELD_ADT_SUPPORT')}['und'][0]['value'] = $supportADT;
    $requeteADT->{variable_get('FIELD_ADT_PARAMS')}['und'][0]['value'] = $paramsADT;
    node_save($requeteADT);
    
    $templateIsNew = $values['new_path'] != '';
    $templatePath = $templateIsNew ? $values['new_path'] : $values['template_path'];
    
    $idTemplate = enregistreTemplate($templatePath);
    
    //-- met à jour la table "adt_activites"
    db_update(variable_get('TABLE_ACTIVITES'))
        ->fields(array(
            'nom' => $nomActivite,
            'template_id' => $idTemplate,
            'parent_path' => $parentPath,
            'parent_title' => $parentTitle,
        ))
        ->condition('id', $idActivite, '=')
        ->execute();
    
    drupal_set_message('Les paramètres de l\'activité ont bien été enregistrés');
    drupal_goto('/admin/config/webservice_nodes/activites');
}



?>
