<?php

/*
 *  Formulaire pour ajouter une activité :
 *  (admin/config/webservices_nodes/ajout_activite)
 * 
 *      -> créé un nouveau type de contenu pour les futurs noeuds (clonés depuis le webservice)
 *      -> créé un contenu de type "adt_node_list"
 *          -> stocke les paramètres d'accès au webservice
 *          -> stocke l'id du type de contenu
 */
function form_ajout_activite($form, &$form_state)
{
    $form['nom'] = array(
        '#type' => 'textfield',
        '#title' => 'Nom',
        '#description' => "Nom de l'activité à créer",
        '#required' => TRUE,
    );
    
    $form['nom-machine'] = array(
        '#type' => 'machine_name',
        '#title' => 'Nom machine',
        '#required' => TRUE,
        '#maxlength' => 22,
        '#machine_name' => array(
            'exists' => '_check_if_content_type_exists',
            'source' => array('nom'),
        ),
    );
    
    /*
     *  Paramètres de la requête ADT :
     */
    $form['adt'] = array(
        '#type' => 'fieldset',
        '#title' => 'Paramètres ADT',
        '#collapsible' => TRUE,
        '#collapsed' => FALSE,
    );
    
    $form['adt']['table'] = array(
        '#type' => 'textfield',
        '#title' => 'Table',
        '#description' => 'Table à interroger dans la base ADT',
        '#required' => TRUE,
    );
    
    $form['adt']['support'] = array(
        '#type' => 'textfield',
        '#title' => 'Support',
        '#default_value' => 'NATURE',
        '#description' => 'Support à interroger dans la base ADT',
        '#required' => TRUE,
    );
    
    $form['adt']['params'] = array(
        '#type' => 'textarea',
        '#title' => 'Paramètres',
        '#description' => 'Paramètres de la requête',
        '#required' => TRUE,
    );
    
    /*
     *  Choix du template associé aux noeuds :
     */
    $form['template'] = array(
        '#type' => 'fieldset',
        '#title' => 'Choix d\'un template',
        '#collapsible' => TRUE,
        '#collapsed' => FALSE,
    );
    
    //-- envoie une requête vers la base pour récupérer la liste des templates
    $templateOptions = getTemplateOptions();
    
    $form['template']['template_path'] = array(
        '#type' => 'select',
        '#title' => 'Chemin du template',
        '#options' => $templateOptions,
        /*'#value' => $defaultTemplate,*/
    );
    
    $form['template']['new_path'] = array(
        '#title' => 'Nouveau template',
        '#type' => 'textfield',
        '#description' => 'Entrez le nom complet du fichier, qui doit commencer par "node--" et avoir l\'extension ".tpl.php". Penser à vider le cache pour que Drupal prenne en compte le nouveau template.'
    );
    
    /*
     *  Chemin parent :
     *  (utilisé pour le fil d'ariane)
     */
    $form['parent_page'] = array(
        '#type' => 'fieldset',
        '#title' => 'Fil d\'ariane',
        '#description' => 'Informations sur la page où seront listés les noeuds, utilisées pour générer le fil d\'ariane.',
        '#collapsible' => TRUE,
        '#collapsed' => FALSE,
    );
    
    $form['parent_page']['parent_path'] = array(
        '#title' => 'Chemin de la page parente',
        '#type' => 'textfield',
        '#description' => 'Entrez le chemin relatif de la page où seront listés les noeuds, sans mettre de slash (/) devant.<br />Vous pouvez indiquer plusieurs niveaux en séparant les valeurs par des barres verticales (|).',
    );
    
    $form['parent_page']['parent_title'] = array(
        '#title' => 'Titre de la page parente',
        '#type' => 'textfield',
        '#description' => 'Entrez le titre de la page où seront listés les noeuds (affiché dans le fil d\'ariane).<br />Vous pouvez indiquer plusieurs niveaux en séparant les valeurs par des barres verticales (|).',
    );
    
    /*
     *  Submit :
     */    
    $form['submit'] = array(
        '#type' => 'submit',
        '#value' => "Créer l'activité",
    );
    
    return $form;
}

function form_ajout_activite_submit($form, &$form_state)
{
    //-- extraction des valeurs du formulaire
    $values = $form_state['values'];
    $nom = $values['nom'];
    $nom_machine = $values['nom-machine'];
    $adt_table = $values['table'];
    $adt_support = $values['support'];
    $adt_params = $values['params'];
    $parent_path = $values['parent_path'];
    $parent_title = $values['parent_title'];
    
    //-- construction du nom du futur type de contenu pour les noeuds clônés
    $nom_machine = 'clone_adt_' . $nom_machine;
    
    //-- vérifie si le template existe déjà où s'il faut le créer
    $templateIsNew = $values['new_path'] != '';
    $template_path = $templateIsNew ? $values['new_path'] : $values['template_path'];
    
    //-- créé le type de contenu pour les noeuds clônés issus de la requête
    creeTypeContenuCloneADT($nom, $nom_machine);
    
    //-- créé un noeud ADT_Request pour stocker les paramètres de la requête
    $nidRequete = creeRequeteADT($nom, $nom_machine, $adt_table, $adt_support, $adt_params);
    
    //-- enregistre le template sélectionné (table à part)
    $idTemplate = enregistreTemplate($template_path, $nom_machine);
    
    //-- enregistre l'activité qui vient d'être créée (table à part)
    enregistreActivite($nom, $nidRequete, $nom_machine, $idTemplate, $parent_path, $parent_title);
    
    drupal_set_message('La requête <strong>' . $nom_machine . '</strong> a bien été créée.<br /><br />');
    drupal_set_message('Vous pouvez maintenant <a href="/admin/structure/types/manage/' . $nom_machine . '/fields">ajouter des champs</a> si besoin. Pour extraire des valeurs du xml, renseignez la valeur par défaut du champ.<br />Exemple pour extraire la durée d\'un circuit : <em>obj_common/obj_rap_spec/duree</em><br />Exemple avec une condition : <em>obj_common/siteaff_desc/ass_obj_siteaff_desc[type_descriptif="PATRI"]/descriptif_spec</em>');
    
    //drupal_goto('/admin/structure/types/manage/' . $nom_machine . '/fields');    
    drupal_goto('/admin/config/webservice_nodes/activites');
}


/**
 *  Création du type de contenu pour accueillir les futurs "clones" :
 */
function creeTypeContenuCloneADT($nom, $nom_machine)
{
    //-- paramètres du type de contenu
    $customParams = array(
        'type' => $nom_machine,
        'name' => 'ADT Clones - ' . $nom,
        'base' => 'node_content',
        'title_label' => 'Titre',
        'description' => 'Noeuds clônés depuis la base ADT (NE PAS CRÉER MANUELLEMENT).',
        'custom' => TRUE,
    );
    
    //-- ajout des paramètres par défaut
    $params = node_type_set_defaults($customParams);
    
    //-- enregistrement du type de contenu
    node_type_save($params);
    
    //-- désactive les options par défaut des types de contenu
    variable_set('comment_' . $nom_machine, 'COMMENT_NODE_HIDDEN');
    variable_set('node_submitted_' . $nom_machine, 0);
    variable_set('node_preview_' . $nom_machine, 0);
    variable_set('menu_options_' . $nom_machine, array());
    variable_set('menu_parent_' . $nom_machine, 0);
    
    /*
     *  Création si besoin du champ ID :
     */
    if (field_info_field(variable_get('FIELD_ADT_NODE_ID')) == NULL)
    {
        field_create_field(array(
            'field_name' => variable_get('FIELD_ADT_NODE_ID'),
            'type'       => 'text',
        ));
    }
    
    /*
     *  Création si besoin du champ XMLDATA :
     */
    if (field_info_field(variable_get('FIELD_ADT_NODE_XML_DATA')) == NULL)
    {
        field_create_field(array(
            'field_name' => variable_get('FIELD_ADT_NODE_XML_DATA'),
            'type'       => 'text_long',
        ));
    }
    
    
    /*
     *  Ajout d'une instance du champ ID :
     */       
    field_create_instance(array(
        'field_name'    => variable_get('FIELD_ADT_NODE_ID'),
          'entity_type'   => 'node',
          'bundle'        => $nom_machine,
          'label'         => t('ID de la fiche'),
          'description'   => t(''),
          'widget'        => array(
              'type'      => 'text',
              'weight'    => 5,
          ),
          'formatter'     => array(
              'label'     => t('label'),
              'format'    => 'text'
          ),
    ));
    
    /*
     *  Ajout d'une instance du champ XML_DATA :
     */       
    field_create_instance(array(
        'field_name'    => variable_get('FIELD_ADT_NODE_XML_DATA'),
          'entity_type'   => 'node',
          'bundle'        => $nom_machine,
          'label'         => t('Données XML'),
          'description'   => t(''),
          'widget'        => array(
              'type'      => 'textarea',
              'weight'    => 6,
          ),
          'formatter'     => array(
              'label'     => t('label'),
              'format'    => 'text'
          ),
    ));
}


/*
 *  Création d'un noeud de type "adt_request" :
 *      -> stocke les paramètres d'accès au webservice
 *      -> stocke l'id du type de contenu correspondant
 */
function creeRequeteADT($nom, $id_contenu, $table, $support, $params)
{
    $node = new stdClass();
    $node->type = variable_get('ADT_REQUEST_CONTENT_TYPE');
    node_object_prepare($node);
    
    $node->title = 'Requête ADT : ' . $nom;
    $node->language = LANGUAGE_NONE;
    
    $node->{variable_get('FIELD_ADT_TABLE')}['und'][0]['value'] = $table;
    $node->{variable_get('FIELD_ADT_SUPPORT')}['und'][0]['value'] = $support;
    $node->{variable_get('FIELD_ADT_PARAMS')}['und'][0]['value'] = $params;
    $node->{variable_get('FIELD_ASSOC_CLONES_CONTENT_TYPE')}['und'][0]['value'] = $id_contenu;
    
    node_save($node);
    
    return $node->nid;
}

/*
 *  Associe le nouveau type de contenu au template choisi :
 */
function enregistreTemplate($template)
{
    //-- vérifie si le template est référencé dans la base
    $existing = getClonesTemplateByPath($template);
    
    //-- enregistrement du template s'il n'existe pas
    if (!$existing)
    {
        db_insert(variable_get('TABLE_CLONES_TEMPLATES'))
                ->fields(array(
                    'path' => $template,
                ))
                ->execute();
        
        $templateId = db_select(variable_get('TABLE_CLONES_TEMPLATES'), 't')
                        ->fields('t', array('id'))
                        ->condition('path', $template, '=')
                        ->execute()
                        ->fetchObject()
                        ->id;
    }
    else
    {    
        $templateId = $existing->id;
    }
    
    return $templateId;
}

/**
 *  Créé un enregistrement dans la table adt_activites
 * 
 * @param $nidRequete Le nid du noeud adt_request
 * @param $clonesContentType Le type de contenu associé aux noeuds clônés
 * @param $idTemplate L'identifiant du template associé aux noeuds clônés
 */
function enregistreActivite($nom, $nidRequete, $clonesContentType, $idTemplate, $parentPath, $parentTitle)
{
    db_insert(variable_get('TABLE_ACTIVITES'))
         ->fields(array(
             'nom' => $nom,
             'adt_request_nid' => $nidRequete,
             'clones_content_type' => $clonesContentType,
             'template_id' => $idTemplate,
             'parent_path' => $parentPath,
             'parent_title' => $parentTitle,
         ))
         ->execute();
}




/*
 *  Callback AJAX pour la création d'un template :
 */
function newPathAjaxCallback($form, $form_state)
{
    return $form['template']['template_path'];
}

/*
 *  Construit un tableau associatif pour obtenir une liste des templates compatible avec la form API:
 */
function getTemplateOptions()
{
   $templates = getClonesTemplates();
   
   $templateOptions = array();
   
   foreach ($templates as $tpl)
   {
       $templateOptions[$tpl->path] = $tpl->path;
   }
   
   return $templateOptions;
}


function _check_if_content_type_exists($name)
{
    return array_key_exists($name, node_type_get_types()) ? 1 : 0;
}


?>
