<?php

function page_test_add_node()
{
    $html = 'Test';
    
    $ADTContentTypes = getADTContentTypes();
    
    $stopAtOnce = 0;
    $numCreated = 0;
    
    foreach($ADTContentTypes as $contentType)
    {
        if ($stopAtOnce++==1) break;
        
        $html .= '<h2>' . $contentType . '</h2>';
        
        $nodes = node_load_multiple(array(), array('type' => $contentType));
        
        foreach($nodes as $node)
        {
            //-- si l'id est différent de all, ce n'est pas une liste, on continue...
            if (property_exists($node, 'field_adt_id') && $node->field_adt_id['und'][0]['value'] != 'all')
                continue;
            
            $html .= '<h4>' . $node->title . '</h4>';
            
            $table = $node->field_adt_table['und'][0]['value'];
            $support = $node->field_adt_support['und'][0]['value'];
            $params = $node->field_adt_params['und'][0]['value'];
            $id = 'all';
            
            $rawData = sendDataXMLRequest($table, $support, $params, $id);
            $xmlData = new SimpleXMLElement($rawData);
            
            //-- boucle sur tous les items de la série
            foreach($xmlData->obj as $item)
            {
                $html .= '- ' . $item->societe . '<br />';
                
                $id = (string) $item->id;
                
                //-- vérifie si un noeud existe dans drupal avec le même id
                $results = db_select('field_data_field_adt_node_id', 'f')
                ->fields('f', array('field_adt_node_id_value'))
                ->condition('field_adt_node_id_value', $id, '=')
                ->execute();
                $nodeExists = $results->rowCount() > 0;
               
                if (!$nodeExists)
                {
                    createNodeClone($id, $item->societe, $rawData);
                    $numCreated ++;
                }
            }
        }
    }
    
    drupal_set_message($numCreated . ' nouveaux noeuds ont été créés');
    
    return $html;
}

?>
