<?php

/**
 *  Callback pour /admin/config/webservice_agenda/parametres_generaux :
 *  (via drupal_get_form)
 */
function form_config_webservice_agenda($form, &$form_state)
{
    /*
     *  Paramètres de la requête pour la page d'accueil :
     */
    
    $form['accueil'] = array(
        '#type' => 'fieldset',
        '#title' => 'Page d\'accueil',
        '#description' => 'Paramètres de la requête pour les news de la page d\'accueil',
        '#collapsible' => TRUE,
        '#collapsed' => TRUE,
    );
    
    $form['accueil']['nb_actus_accueil'] = array(
        '#type' => 'textfield',
        '#title' => 'Nombre d\'actus',
        '#description' => 'Nombre d\'actualités affichées sur la page d\'accueil (ce nombre inclut les actus créées dans Drupal). Un paramètres "limit" sera automatiquement injecté dans la requête ADT.',
        '#default_value' => variable_get('nb_actus_accueil'),
        '#required' => TRUE,
    );
    
    $form['accueil']['accueil_table'] = array(
        '#type' => 'textfield',
        '#title' => 'Table',
        '#description' => 'Table à interroger dans la base ADT',
        '#default_value' => variable_get('agenda_accueil_table'),
        '#required' => TRUE,
    );
    
    $form['accueil']['accueil_support'] = array(
        '#type' => 'textfield',
        '#title' => 'Support',
        '#description' => 'Support à interroger dans la base ADT',
        '#default_value' => variable_get('agenda_accueil_support'),
        '#required' => TRUE,
    );
    
    $form['accueil']['accueil_params'] = array(
        '#type' => 'textarea',
        '#title' => 'Paramètres',
        '#default_value' => variable_get('agenda_accueil_params'),
        '#description' => 'Paramètres de la requête vers la base ADT.<br />Attention : ne pas mettre de paramètre "limit", il sera injecté automatiquement par le module lors de la requête',
        '#required' => TRUE,
    );
    
    
    /*
     *  Paramètres de la requête pour le sous-menu :
     */
    
    $form['sous_menu'] = array(
        '#type' => 'fieldset',
        '#title' => 'Sous-menu "Mon Agenda"',
        '#description' => 'Paramètres de la requête pour le sous-menu de la rubrique "Mon Agenda"',
        '#collapsible' => TRUE,
        '#collapsed' => TRUE,
    );
    
    $form['sous_menu']['ssmenu_table'] = array(
        '#type' => 'textfield',
        '#title' => 'Table',
        '#description' => 'Table à interroger dans la base ADT',
        '#default_value' => variable_get('agenda_ssmenu_table'),
        '#required' => TRUE,
    );
    
    $form['sous_menu']['ssmenu_support'] = array(
        '#type' => 'textfield',
        '#title' => 'Support',
        '#default_value' => 'NATURE',
        '#description' => 'Support à interroger dans la base ADT',
        '#default_value' => variable_get('agenda_ssmenu_support'),
        '#required' => TRUE,
    );
    
    $form['sous_menu']['ssmenu_params'] = array(
        '#type' => 'textarea',
        '#title' => 'Paramètres',
        '#description' => 'Paramètres de la requête vers la base ADT.<br />Attention : ne pas mettre de paramètre "limit", il sera injecté automatiquement par le module lors de la requête',
        '#default_value' => variable_get('agenda_ssmenu_params'),
        '#required' => TRUE,
    );
    
    
    /*
     *  Submit :
     */
    
    $form['submit'] = array(
        '#type' => 'submit',
        '#value' => 'Enregistrer',
    );
    
    return $form;
}

function form_config_webservice_agenda_submit($form, &$form_state)
{
    $values = $form_state['values'];
    
    variable_set('nb_actus_accueil', $values['nb_actus_accueil']);
    variable_set('agenda_accueil_table', $values['accueil_table']);
    variable_set('agenda_accueil_support', $values['accueil_support']);
    variable_set('agenda_accueil_params', $values['accueil_params']);
    
    variable_set('agenda_ssmenu_table', $values['ssmenu_table']);
    variable_set('agenda_ssmenu_support', $values['ssmenu_support']);
    variable_set('agenda_ssmenu_params', $values['ssmenu_params']);    
}



?>
