CKEDITOR.plugins.add( 'tooltip', {
    icons: 'tooltip',
    init: function( editor ) {
        editor.addCommand( 'tooltip', new CKEDITOR.dialogCommand( 'tooltipDialog' ) );

		editor.ui.addButton( 'tooltip', {

			// The text part of the button (if available) and tooptip.
			label: 'Inserer une bulle',

			// The command to execute on click.
			command: 'tooltip',

			// The button placement in the toolbar (toolbar group name).
			toolbar: 'insert'
		});

		if ( editor.contextMenu ) {
            editor.addMenuGroup( 'tooltipGroup' );
            editor.addMenuItem( 'tooltipItem', {
                label: 'Editer le tooltip',
                icon: this.path + 'icons/tooltip.png',
                command: 'tooltip',
                group: 'tooltipGroup'
            });

            editor.contextMenu.addListener( function( element ) {
                if ( element.getAscendant( 'a', true ) ) {
                    return { tooltipItem: CKEDITOR.TRISTATE_OFF };
                }
            });
        }

		CKEDITOR.dialog.add( 'tooltipDialog', this.path + 'dialogs/tooltip.js' );
    }
});