/**
 * The abbr dialog definition.
 *
 * Created out of the CKEditor Plugin SDK:
 * http://docs.ckeditor.com/#!/guide/plugin_sdk_sample_1
 */

// Our dialog definition.
CKEDITOR.dialog.add( 'tooltipDialog', function( editor ) {
	return {

		// Basic properties of the dialog window: title, minimum size.
		title: 'Contenu de la bulle',
		minWidth: 400,
		minHeight: 200,

		// Dialog window contents definition.
		contents: [
			{
				// Definition of the Basic Settings dialog tab (page).
				id: 'tab-basic',
				label: 'Paramètres',

				// The tab contents.
				elements: [
					{
						// Text input field for the abbreviation text.
						type: 'text',
						id: 'exp',
						label: 'Expression',

						// Validation checking whether the field is not empty.
						validate: CKEDITOR.dialog.validate.notEmpty( "Le champ expression ne peut etre vide" ),
						setup: function( element ) {
							this.setValue( element.getText() );
						},
				        commit: function( element ) {
				            element.setText( this.getValue() );
				        }	        		
					},
					{
						// Text input field for the abbreviation title (explanation).
						type: 'textarea',
						id: 'title',
						label: 'Explications',
						validate: CKEDITOR.dialog.validate.notEmpty( "Le champ explication ne peut etre vide" ),
						setup: function( element ) {
							this.setValue( element.getAttribute( "title" ) );
						},
				        commit: function( element ) {
				            element.setAttribute( "title", this.getValue() );
				        }
					}
				]
			}
		],
        onShow: function() {
            var selection = editor.getSelection(),
                element = selection.getStartElement();
            if ( element )
                element = element.getAscendant( 'a', true );

            if ( !element || element.getName() != 'a' || element.data( 'cke-realelement' ) ) {
                element = editor.document.createElement( 'a' );
                this.insertMode = true;
            }
            else
                this.insertMode = false;

            this.element = element;

            if ( !this.insertMode )
                this.setupContent( this.element );
        },
		// This method is invoked once a user clicks the OK button, confirming the dialog.
		onOk: function() {

			// The context of this function is the dialog object itself.
			// http://docs.ckeditor.com/#!/api/CKEDITOR.dialog
			var dialog = this;

			a = this.element;
			
			this.commitContent( a );

			// Finally, inserts the element at the editor caret position.
			if ( this.insertMode )
				a.setAttribute( 'href', '#');
				a.setAttribute( 'class', 'tooltip');
				editor.insertElement( a );
		}
	};
});